@extends('layouts.app')

@section('title', 'Nova Barragem')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-plus mr-3 text-blue-600"></i>
                    Nova Barragem
                </h1>
                <p class="text-gray-600 mt-2">Adicionar uma nova barragem ao sistema hidrológico</p>
            </div>
            <a href="{{ route('barragens.index') }}" 
               class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 transition-colors">
                <i class="fas fa-arrow-left mr-2"></i>
                Voltar
            </a>
        </div>
    </div>

    <!-- Form -->
    <div class="bg-white rounded-lg shadow p-6">
        <form method="POST" action="{{ route('barragens.store') }}">
            @csrf
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Informações Básicas -->
                <div class="space-y-4">
                    <h3 class="text-lg font-medium text-gray-900 border-b pb-2">
                        <i class="fas fa-info-circle mr-2 text-blue-600"></i>
                        Informações Básicas
                    </h3>
                    
                    <div>
                        <label for="nome" class="block text-sm font-medium text-gray-700 mb-2">Nome da Barragem *</label>
                        <input type="text" id="nome" name="nome" value="{{ old('nome') }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('nome') border-red-500 @enderror">
                        @error('nome')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    
                    <div>
                        <label for="codigo" class="block text-sm font-medium text-gray-700 mb-2">Código *</label>
                        <input type="text" id="codigo" name="codigo" value="{{ old('codigo') }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('codigo') border-red-500 @enderror">
                        @error('codigo')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    
                    <div>
                        <label for="bacia_hidrografica_id" class="block text-sm font-medium text-gray-700 mb-2">Bacia Hidrográfica</label>
                        <select id="bacia_hidrografica_id" name="bacia_hidrografica_id"
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('bacia_hidrografica_id') border-red-500 @enderror">
                            <option value="">Selecione uma bacia</option>
                            @foreach($bacias as $bacia)
                                <option value="{{ $bacia->id }}" {{ old('bacia_hidrografica_id') == $bacia->id ? 'selected' : '' }}>
                                    {{ $bacia->nome }}
                                </option>
                            @endforeach
                        </select>
                        @error('bacia_hidrografica_id')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    
                    <div>
                        <label for="estado" class="block text-sm font-medium text-gray-700 mb-2">Estado *</label>
                        <select id="estado" name="estado" required
                                class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('estado') border-red-500 @enderror">
                            <option value="">Selecione o estado</option>
                            <option value="activa" {{ old('estado') == 'activa' ? 'selected' : '' }}>Ativa</option>
                            <option value="inactiva" {{ old('estado') == 'inactiva' ? 'selected' : '' }}>Inativa</option>
                            <option value="manutencao" {{ old('estado') == 'manutencao' ? 'selected' : '' }}>Manutenção</option>
                        </select>
                        @error('estado')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
                
                <!-- Localização -->
                <div class="space-y-4">
                    <h3 class="text-lg font-medium text-gray-900 border-b pb-2">
                        <i class="fas fa-map-marker-alt mr-2 text-green-600"></i>
                        Localização
                    </h3>
                    
                    <div>
                        <label for="provincia" class="block text-sm font-medium text-gray-700 mb-2">Província</label>
                        <input type="text" id="provincia" name="provincia" value="{{ old('provincia') }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('provincia') border-red-500 @enderror">
                        @error('provincia')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    
                    <div>
                        <label for="distrito" class="block text-sm font-medium text-gray-700 mb-2">Distrito</label>
                        <input type="text" id="distrito" name="distrito" value="{{ old('distrito') }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('distrito') border-red-500 @enderror">
                        @error('distrito')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label for="latitude" class="block text-sm font-medium text-gray-700 mb-2">Latitude</label>
                            <input type="number" id="latitude" name="latitude" value="{{ old('latitude') }}" step="any"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('latitude') border-red-500 @enderror">
                            @error('latitude')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="longitude" class="block text-sm font-medium text-gray-700 mb-2">Longitude</label>
                            <input type="number" id="longitude" name="longitude" value="{{ old('longitude') }}" step="any"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('longitude') border-red-500 @enderror">
                            @error('longitude')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Características Técnicas -->
            <div class="mt-8 space-y-8">
                <!-- Cotas e Níveis Técnicos -->
                <div class="bg-blue-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-blue-900 border-b border-blue-200 pb-2 mb-4">
                        <i class="fas fa-mountain mr-2 text-blue-600"></i>
                        Cotas e Níveis Técnicos
                    </h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Cotas Básicas -->
                        <div>
                            <label for="cota_maxima" class="block text-sm font-medium text-blue-700 mb-2">Cota Máxima (m)</label>
                            <input type="number" id="cota_maxima" name="cota_maxima" value="{{ old('cota_maxima') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-blue-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('cota_maxima') border-red-500 @enderror">
                            @error('cota_maxima')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="cota_minima" class="block text-sm font-medium text-blue-700 mb-2">Cota Mínima (m)</label>
                            <input type="number" id="cota_minima" name="cota_minima" value="{{ old('cota_minima') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-blue-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('cota_minima') border-red-500 @enderror">
                            @error('cota_minima')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="cota_npa" class="block text-sm font-medium text-blue-700 mb-2">Nível Pleno de Armazenamento - NPA (m)</label>
                            <input type="number" id="cota_npa" name="cota_npa" value="{{ old('cota_npa') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-blue-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('cota_npa') border-red-500 @enderror">
                            <small class="text-blue-600">Nível de Pleno Armazenamento</small>
                            @error('cota_npa')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-6">
                        <!-- Cotas Avançadas -->
                        <div>
                            <label for="cota_nme" class="block text-sm font-medium text-blue-700 mb-2">Nível Mínimo de Exploração - NME (m)</label>
                            <input type="number" id="cota_nme" name="cota_nme" value="{{ old('cota_nme') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-blue-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('cota_nme') border-red-500 @enderror">
                            <small class="text-blue-600">Nível Máximo Extraordinário</small>
                            @error('cota_nme')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="cota_nmc" class="block text-sm font-medium text-blue-700 mb-2">Nível Máximo de Cheia - NMC (m)</label>
                            <input type="number" id="cota_nmc" name="cota_nmc" value="{{ old('cota_nmc') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-blue-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('cota_nmc') border-red-500 @enderror">
                            <small class="text-blue-600">Nível Máximo de Cheia</small>
                            @error('cota_nmc')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="nivel_descargador" class="block text-sm font-medium text-blue-700 mb-2">Nível Descargador (m)</label>
                            <input type="number" id="nivel_descargador" name="nivel_descargador" value="{{ old('nivel_descargador') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-blue-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('nivel_descargador') border-red-500 @enderror">
                            @error('nivel_descargador')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                    </div>
                </div>
                
                <!-- Volumes e Capacidades -->
                <div class="bg-green-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-green-900 border-b border-green-200 pb-2 mb-4">
                        <i class="fas fa-tint mr-2 text-green-600"></i>
                        Volumes e Capacidades
                    </h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                        <div>
                            <label for="volume_maximo" class="block text-sm font-medium text-green-700 mb-2">Volume Máximo (Mm³)</label>
                            <input type="number" id="volume_maximo" name="volume_maximo" value="{{ old('volume_maximo') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-green-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('volume_maximo') border-red-500 @enderror">
                            @error('volume_maximo')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="volume_morto" class="block text-sm font-medium text-green-700 mb-2">Volume Morto (Mm³)</label>
                            <input type="number" id="volume_morto" name="volume_morto" value="{{ old('volume_morto') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-green-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('volume_morto') border-red-500 @enderror">
                            @error('volume_morto')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="volume_util" class="block text-sm font-medium text-green-700 mb-2">Volume Útil (Mm³)</label>
                            <input type="number" id="volume_util" name="volume_util" value="{{ old('volume_util') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-green-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('volume_util') border-red-500 @enderror">
                            <small class="text-green-600">Se vazio, será calculado automaticamente</small>
                            @error('volume_util')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="capacidade_total" class="block text-sm font-medium text-green-700 mb-2">Capacidade Total (Mm³)</label>
                            <input type="number" id="capacidade_total" name="capacidade_total" value="{{ old('capacidade_total') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-green-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('capacidade_total') border-red-500 @enderror">
                            @error('capacidade_total')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <!-- Características Físicas -->
                <div class="bg-purple-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-purple-900 border-b border-purple-200 pb-2 mb-4">
                        <i class="fas fa-ruler-combined mr-2 text-purple-600"></i>
                        Características Físicas
                    </h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                        <div>
                            <label for="area_bacia_hidraulica" class="block text-sm font-medium text-purple-700 mb-2">Área Bacia Hidrográfica (km²)</label>
                            <input type="number" id="area_bacia_hidraulica" name="area_bacia_hidraulica" value="{{ old('area_bacia_hidraulica') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-purple-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500 @error('area_bacia_hidraulica') border-red-500 @enderror">
                            @error('area_bacia_hidraulica')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="area_inundacao" class="block text-sm font-medium text-purple-700 mb-2">Área de Inundação (km²)</label>
                            <input type="number" id="area_inundacao" name="area_inundacao" value="{{ old('area_inundacao') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-purple-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500 @error('area_inundacao') border-red-500 @enderror">
                            @error('area_inundacao')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="altura_barragem" class="block text-sm font-medium text-purple-700 mb-2">Altura da Barragem (m)</label>
                            <input type="number" id="altura_barragem" name="altura_barragem" value="{{ old('altura_barragem') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-purple-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500 @error('altura_barragem') border-red-500 @enderror">
                            @error('altura_barragem')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="comprimento_crista" class="block text-sm font-medium text-purple-700 mb-2">Comprimento da Crista (m)</label>
                            <input type="number" id="comprimento_crista" name="comprimento_crista" value="{{ old('comprimento_crista') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-purple-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500 @error('comprimento_crista') border-red-500 @enderror">
                            @error('comprimento_crista')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <!-- Classificação de Riscos -->
                <div class="bg-yellow-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-yellow-900 border-b border-yellow-200 pb-2 mb-4">
                        <i class="fas fa-shield-alt mr-2 text-yellow-600"></i>
                        Classificação de Riscos e Monitoramento
                    </h3>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                            <label for="classe_risco" class="block text-sm font-medium text-yellow-700 mb-2">Classe de Risco</label>
                            <select id="classe_risco" name="classe_risco"
                                    class="w-full px-3 py-2 border border-yellow-300 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 @error('classe_risco') border-red-500 @enderror">
                                <option value="baixo" {{ old('classe_risco') == 'baixo' ? 'selected' : '' }}>Baixo</option>
                                <option value="medio" {{ old('classe_risco', 'medio') == 'medio' ? 'selected' : '' }}>Médio</option>
                                <option value="alto" {{ old('classe_risco') == 'alto' ? 'selected' : '' }}>Alto</option>
                            </select>
                            @error('classe_risco')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="categoria_dano" class="block text-sm font-medium text-yellow-700 mb-2">Categoria de Dano Potencial</label>
                            <select id="categoria_dano" name="categoria_dano"
                                    class="w-full px-3 py-2 border border-yellow-300 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 @error('categoria_dano') border-red-500 @enderror">
                                <option value="baixo" {{ old('categoria_dano') == 'baixo' ? 'selected' : '' }}>Baixo</option>
                                <option value="medio" {{ old('categoria_dano', 'medio') == 'medio' ? 'selected' : '' }}>Médio</option>
                                <option value="alto" {{ old('categoria_dano') == 'alto' ? 'selected' : '' }}>Alto</option>
                            </select>
                            @error('categoria_dano')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="frequencia_monitoramento" class="block text-sm font-medium text-yellow-700 mb-2">Frequência de Monitoramento</label>
                            <select id="frequencia_monitoramento" name="frequencia_monitoramento"
                                    class="w-full px-3 py-2 border border-yellow-300 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 @error('frequencia_monitoramento') border-red-500 @enderror">
                                <option value="diario" {{ old('frequencia_monitoramento', 'diario') == 'diario' ? 'selected' : '' }}>Diário</option>
                                <option value="semanal" {{ old('frequencia_monitoramento') == 'semanal' ? 'selected' : '' }}>Semanal</option>
                                <option value="mensal" {{ old('frequencia_monitoramento') == 'mensal' ? 'selected' : '' }}>Mensal</option>
                                <option value="continuo" {{ old('frequencia_monitoramento') == 'continuo' ? 'selected' : '' }}>Contínuo</option>
                            </select>
                            @error('frequencia_monitoramento')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Classificação Técnica -->
            <div class="mt-8">
                <div class="bg-indigo-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-indigo-900 border-b border-indigo-200 pb-2 mb-4">
                        <i class="fas fa-tags mr-2 text-indigo-600"></i>
                        Classificação Técnica
                    </h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                            <label for="tipo_barragem" class="block text-sm font-medium text-indigo-700 mb-2">Tipo de Barragem</label>
                            <select id="tipo_barragem" name="tipo_barragem"
                                    class="w-full px-3 py-2 border border-indigo-300 rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 @error('tipo_barragem') border-red-500 @enderror">
                                <option value="terra" {{ old('tipo_barragem', 'terra') == 'terra' ? 'selected' : '' }}>Terra</option>
                                <option value="betao" {{ old('tipo_barragem') == 'betao' ? 'selected' : '' }}>Betão</option>
                                <option value="enrocamento" {{ old('tipo_barragem') == 'enrocamento' ? 'selected' : '' }}>Enrocamento</option>
                                <option value="mista" {{ old('tipo_barragem') == 'mista' ? 'selected' : '' }}>Mista</option>
                                <option value="gravidade" {{ old('tipo_barragem') == 'gravidade' ? 'selected' : '' }}>Gravidade</option>
                                <option value="arco" {{ old('tipo_barragem') == 'arco' ? 'selected' : '' }}>Arco</option>
                                <option value="contraforte" {{ old('tipo_barragem') == 'contraforte' ? 'selected' : '' }}>Contraforte</option>
                            </select>
                            @error('tipo_barragem')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="finalidade_principal" class="block text-sm font-medium text-indigo-700 mb-2">Finalidade Principal</label>
                            <select id="finalidade_principal" name="finalidade_principal"
                                    class="w-full px-3 py-2 border border-indigo-300 rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 @error('finalidade_principal') border-red-500 @enderror">
                                <option value="abastecimento" {{ old('finalidade_principal', 'abastecimento') == 'abastecimento' ? 'selected' : '' }}>Abastecimento</option>
                                <option value="irrigacao" {{ old('finalidade_principal') == 'irrigacao' ? 'selected' : '' }}>Irrigação</option>
                                <option value="energia" {{ old('finalidade_principal') == 'energia' ? 'selected' : '' }}>Energia</option>
                                <option value="controle_cheias" {{ old('finalidade_principal') == 'controle_cheias' ? 'selected' : '' }}>Controle de Cheias</option>
                                <option value="recreacao" {{ old('finalidade_principal') == 'recreacao' ? 'selected' : '' }}>Recreação</option>
                                <option value="piscicultura" {{ old('finalidade_principal') == 'piscicultura' ? 'selected' : '' }}>Piscicultura</option>
                                <option value="multipla" {{ old('finalidade_principal') == 'multipla' ? 'selected' : '' }}>Múltipla</option>
                            </select>
                            @error('finalidade_principal')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="tipo_descargador" class="block text-sm font-medium text-indigo-700 mb-2">Tipo de Descargador</label>
                            <select id="tipo_descargador" name="tipo_descargador"
                                    class="w-full px-3 py-2 border border-indigo-300 rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 @error('tipo_descargador') border-red-500 @enderror">
                                <option value="">Selecione...</option>
                                <option value="superficie" {{ old('tipo_descargador') == 'superficie' ? 'selected' : '' }}>Superfície</option>
                                <option value="fundo" {{ old('tipo_descargador') == 'fundo' ? 'selected' : '' }}>Fundo</option>
                                <option value="lateral" {{ old('tipo_descargador') == 'lateral' ? 'selected' : '' }}>Lateral</option>
                                <option value="tunel" {{ old('tipo_descargador') == 'tunel' ? 'selected' : '' }}>Túnel</option>
                                <option value="misto" {{ old('tipo_descargador') == 'misto' ? 'selected' : '' }}>Misto</option>
                            </select>
                            @error('tipo_descargador')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Características Hidrológicas -->
            <div class="mt-8">
                <div class="bg-cyan-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-cyan-900 border-b border-cyan-200 pb-2 mb-4">
                        <i class="fas fa-water mr-2 text-cyan-600"></i>
                        Características Hidrológicas
                    </h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="rio_principal" class="block text-sm font-medium text-cyan-700 mb-2">Rio Principal</label>
                            <input type="text" id="rio_principal" name="rio_principal" value="{{ old('rio_principal') }}"
                                   class="w-full px-3 py-2 border border-cyan-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 @error('rio_principal') border-red-500 @enderror">
                            @error('rio_principal')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="afluentes" class="block text-sm font-medium text-cyan-700 mb-2">
                                <i class="fas fa-water mr-2 text-cyan-500"></i>
                                Afluentes (Tributários)
                            </label>
                            <div class="relative">
                                <input type="text" id="afluentes_input"
                                       placeholder="Digite o nome de um rio e pressione Enter..."
                                       class="w-full px-3 py-2 border border-cyan-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 @error('afluentes') border-red-500 @enderror">
                                <div id="afluentes_suggestions" class="hidden absolute z-10 w-full bg-white border border-gray-300 rounded-md shadow-lg max-h-32 overflow-y-auto"></div>
                            </div>
                            <!-- Tags dos afluentes selecionados -->
                            <div id="afluentes_tags" class="mt-2 flex flex-wrap gap-2">
                                @php
                                    $old_afluentes = old('afluentes');
                                    if ($old_afluentes) {
                                        $afluentes_array = is_array($old_afluentes) ? $old_afluentes : explode(',', $old_afluentes);
                                        $afluentes_array = array_filter(array_map('trim', $afluentes_array));
                                    } else {
                                        $afluentes_array = [];
                                    }
                                @endphp
                                @foreach($afluentes_array as $afluente)
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-cyan-100 text-cyan-800">
                                        {{ $afluente }}
                                        <button type="button" onclick="removeAfluenteTag(this)" class="ml-1 text-cyan-600 hover:text-cyan-800">×</button>
                                    </span>
                                @endforeach
                            </div>
                            <!-- Input hidden com os valores finais -->
                            <input type="hidden" name="afluentes" id="afluentes_hidden" value="{{ old('afluentes') }}">
                            <p class="text-xs text-gray-500 mt-1">
                                <i class="fas fa-info-circle mr-1"></i>
                                Digite nomes de rios tributários. Pressione Enter para adicionar cada um.
                            </p>
                            @error('afluentes')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="mt-6">
                        <label for="estacoes_pluviometricas" class="block text-sm font-medium text-cyan-700 mb-2">
                            <i class="fas fa-cloud-rain mr-2 text-blue-500"></i>
                            Estações Pluviométricas Associadas
                        </label>
                        <select id="estacoes_pluviometricas" name="estacoes_pluviometricas[]" multiple
                                class="w-full px-3 py-2 border border-cyan-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500 @error('estacoes_pluviometricas') border-red-500 @enderror"
                                style="min-height: 120px;">
                            @foreach(App\Models\Estacao::where('tipo', 'pluviometrica')->orderBy('nome')->get() as $estacao)
                                <option value="{{ $estacao->id }}"
                                    {{ in_array($estacao->id, old('estacoes_pluviometricas', [])) ? 'selected' : '' }}>
                                    {{ $estacao->nome }} ({{ $estacao->codigo }}) - {{ $estacao->provincia }}
                                </option>
                            @endforeach
                        </select>
                        <small class="text-cyan-600">
                            <i class="fas fa-info-circle mr-1"></i>
                            Selecione múltiplas estações usando Ctrl+Click (Windows) ou Cmd+Click (Mac)
                        </small>
                        @error('estacoes_pluviometricas')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>
            
            <!-- Informações do Projeto -->
            <div class="mt-8">
                <div class="bg-gray-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-gray-900 border-b border-gray-200 pb-2 mb-4">
                        <i class="fas fa-building mr-2 text-gray-600"></i>
                        Informações do Projeto
                    </h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                            <label for="ano_construcao" class="block text-sm font-medium text-gray-700 mb-2">Ano de Construção</label>
                            <input type="number" id="ano_construcao" name="ano_construcao" value="{{ old('ano_construcao') }}" min="1900" max="{{ date('Y') }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('ano_construcao') border-red-500 @enderror">
                            @error('ano_construcao')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="ano_projeto" class="block text-sm font-medium text-gray-700 mb-2">Ano do Projeto</label>
                            <input type="number" id="ano_projeto" name="ano_projeto" value="{{ old('ano_projeto') }}" min="1900" max="{{ date('Y') }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('ano_projeto') border-red-500 @enderror">
                            @error('ano_projeto')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="ano_conclusao" class="block text-sm font-medium text-gray-700 mb-2">Ano de Conclusão</label>
                            <input type="number" id="ano_conclusao" name="ano_conclusao" value="{{ old('ano_conclusao') }}" min="1900" max="{{ date('Y') }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('ano_conclusao') border-red-500 @enderror">
                            @error('ano_conclusao')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                        <div>
                            <label for="empresa_projetista" class="block text-sm font-medium text-gray-700 mb-2">Empresa Projetista</label>
                            <input type="text" id="empresa_projetista" name="empresa_projetista" value="{{ old('empresa_projetista') }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('empresa_projetista') border-red-500 @enderror">
                            @error('empresa_projetista')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label for="empresa_construtora" class="block text-sm font-medium text-gray-700 mb-2">Empresa Construtora</label>
                            <input type="text" id="empresa_construtora" name="empresa_construtora" value="{{ old('empresa_construtora') }}"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('empresa_construtora') border-red-500 @enderror">
                            @error('empresa_construtora')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-6">
                        <div class="flex items-center">
                            <input type="checkbox" id="sistema_automatizado" name="sistema_automatizado" value="1" {{ old('sistema_automatizado') ? 'checked' : '' }}
                                   class="mr-2 h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="sistema_automatizado" class="text-sm font-medium text-gray-700">Sistema Automatizado</label>
                        </div>
                        
                        <div class="flex items-center">
                            <input type="checkbox" id="telemetria" name="telemetria" value="1" {{ old('telemetria') ? 'checked' : '' }}
                                   class="mr-2 h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="telemetria" class="text-sm font-medium text-gray-700">Sistema de Telemetria</label>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Observações -->
            <div class="mt-8">
                <label for="observacoes" class="block text-sm font-medium text-gray-700 mb-2">Observações</label>
                <textarea id="observacoes" name="observacoes" rows="4"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('observacoes') border-red-500 @enderror">{{ old('observacoes') }}</textarea>
                @error('observacoes')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
            
            <!-- Submit Button -->
            <div class="mt-8 flex justify-end space-x-4">
                <a href="{{ route('barragens.index') }}" 
                   class="bg-gray-600 text-white px-6 py-2 rounded-md hover:bg-gray-700 transition-colors">
                    Cancelar
                </a>
                <button type="submit" 
                        class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors">
                    <i class="fas fa-save mr-2"></i>
                    Salvar Barragem
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const afluentesInput = document.getElementById('afluentes_input');
    const afluentesHidden = document.getElementById('afluentes_hidden');
    const afluentesTags = document.getElementById('afluentes_tags');

    // Função para atualizar o input hidden
    function updateHiddenInput() {
        const tags = afluentesTags.querySelectorAll('span');
        const values = Array.from(tags).map(tag => tag.textContent.replace('×', '').trim());
        afluentesHidden.value = values.join(',');
    }

    // Função para adicionar tag
    function addAfluenteTag(value) {
        if (!value.trim()) return;

        // Verificar se já existe
        const existingTags = afluentesTags.querySelectorAll('span');
        const existingValues = Array.from(existingTags).map(tag => tag.textContent.replace('×', '').trim().toLowerCase());

        if (existingValues.includes(value.trim().toLowerCase())) {
            return;
        }

        // Criar nova tag
        const tagElement = document.createElement('span');
        tagElement.className = 'inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-cyan-100 text-cyan-800';
        tagElement.innerHTML = `
            ${value.trim()}
            <button type="button" onclick="removeAfluenteTag(this)" class="ml-1 text-cyan-600 hover:text-cyan-800">×</button>
        `;

        afluentesTags.appendChild(tagElement);
        updateHiddenInput();
        afluentesInput.value = '';
    }

    // Event listener para Enter no input
    afluentesInput.addEventListener('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            addAfluenteTag(this.value);
        }
    });

    // Event listener para blur (quando sai do campo)
    afluentesInput.addEventListener('blur', function() {
        if (this.value.trim()) {
            addAfluenteTag(this.value);
        }
    });
});

// Função global para remover tags
function removeAfluenteTag(button) {
    const tagElement = button.closest('span');
    tagElement.remove();

    // Atualizar input hidden
    const afluentesHidden = document.getElementById('afluentes_hidden');
    const afluentesTags = document.getElementById('afluentes_tags');
    const tags = afluentesTags.querySelectorAll('span');
    const values = Array.from(tags).map(tag => tag.textContent.replace('×', '').trim());
    afluentesHidden.value = values.join(',');
}
</script>

@endsection
