<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Boletim Informativo de Barragens</title>
    <style>
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 11px;
            line-height: 1.3;
            color: #333;
            margin: 0;
            padding: 15px;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #1e3a8a;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .header h1 {
            color: #1e3a8a;
            font-size: 18px;
            margin: 0;
            font-weight: bold;
        }
        .header h2 {
            color: #374151;
            font-size: 14px;
            margin: 5px 0;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
        }
        .info-item {
            text-align: center;
        }
        .info-label {
            font-weight: bold;
            color: #374151;
            display: block;
        }
        .info-value {
            color: #1e3a8a;
            font-weight: bold;
        }
        .section {
            margin-bottom: 20px;
        }
        .section-title {
            background-color: #1e3a8a;
            color: white;
            padding: 8px;
            font-weight: bold;
            font-size: 12px;
            margin-bottom: 10px;
        }
        .barragem-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-bottom: 15px;
        }
        .barragem-card {
            border: 1px solid #d1d5db;
            padding: 10px;
            background-color: #f9fafb;
        }
        .barragem-name {
            font-weight: bold;
            color: #1e3a8a;
            font-size: 12px;
            margin-bottom: 8px;
        }
        .barragem-data {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 5px;
            font-size: 10px;
        }
        .data-item {
            display: flex;
            justify-content: space-between;
        }
        .data-label {
            font-weight: bold;
        }
        .alertas {
            background-color: #fef3c7;
            border: 1px solid #f59e0b;
            padding: 10px;
            margin: 15px 0;
        }
        .alertas h4 {
            color: #92400e;
            margin: 0 0 8px 0;
            font-size: 12px;
        }
        .alertas ul {
            margin: 0;
            padding-left: 15px;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #d1d5db;
            font-size: 10px;
        }
        .footer-info {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        .status-normal { color: #059669; }
        .status-atencao { color: #d97706; }
        .status-alerta { color: #dc2626; }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>{{ $settings['organization_name'] ?? 'MINISTÉRIO DAS OBRAS PÚBLICAS, HABITAÇÃO E RECURSOS HÍDRICOS' }}</h1>
        <h2>{{ $settings['department_name'] ?? 'DIRECÇÃO NACIONAL DE GESTÃO DE RECURSOS HÍDRICOS' }}</h2>
        <h1>BOLETIM INFORMATIVO DE BARRAGENS</h1>
        <div style="margin-top: 10px;">
            <span class="info-label">Edição Nº:</span>
            <span class="info-value">{{ $boletim->numero_edicao ?? 'N/A' }}</span>
            &nbsp;&nbsp;&nbsp;
            <span class="info-label">Data:</span>
            <span class="info-value">{{ \Carbon\Carbon::parse($boletim->data_emissao)->format('d/m/Y') }}</span>
        </div>
    </div>

    <!-- Informações Gerais -->
    <div class="info-row">
        <div class="info-item">
            <span class="info-label">Período de Referência</span>
            <div class="info-value">
                @if($boletim->periodo_inicio && $boletim->periodo_fim)
                    {{ \Carbon\Carbon::parse($boletim->periodo_inicio)->format('d/m/Y') }} -
                    {{ \Carbon\Carbon::parse($boletim->periodo_fim)->format('d/m/Y') }}
                @else
                    {{ \Carbon\Carbon::parse($boletim->data_emissao)->format('d/m/Y') }}
                @endif
            </div>
        </div>
        <div class="info-item">
            <span class="info-label">Estado</span>
            <div class="info-value">{{ strtoupper($boletim->estado) }}</div>
        </div>
    </div>

    <!-- Barragens Principais -->
    <div class="section">
        <div class="section-title">SITUAÇÃO DAS PRINCIPAIS BARRAGENS DO PAÍS</div>

        <div class="barragem-grid">
            @foreach($dados['barragens'] ?? [] as $barragem)
            <div class="barragem-card">
                <div class="barragem-name">{{ $barragem['nome'] ?? 'Barragem' }}</div>
                <div class="barragem-data">
                    <div class="data-item">
                        <span class="data-label">Capacidade:</span>
                        <span>{{ $barragem['capacidade'] ?? 'N/A' }}</span>
                    </div>
                    <div class="data-item">
                        <span class="data-label">Nível Atual:</span>
                        <span class="status-normal">{{ $barragem['nivel_atual'] ?? 'N/A' }}</span>
                    </div>
                    <div class="data-item">
                        <span class="data-label">Volume:</span>
                        <span>{{ number_format($barragem['volume_atual'] ?? 0, 1) }} Mm³</span>
                    </div>
                    <div class="data-item">
                        <span class="data-label">Produção:</span>
                        <span>{{ $barragem['producao_energia'] ?? 'N/A' }}</span>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>

    <!-- Alertas e Observações -->
    @if(!empty($dados['alertas']))
    <div class="alertas">
        <h4>ALERTAS E OBSERVAÇÕES</h4>
        <ul>
            @foreach($dados['alertas'] as $alerta)
            <li>{{ $alerta }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <!-- Situação Prevalecente -->
    @if($boletim->situacao_prevalecente)
    <div class="section">
        <div class="section-title">SITUAÇÃO PREVALECENTE</div>
        <p style="text-align: justify; margin: 0;">{{ $boletim->situacao_prevalecente }}</p>
    </div>
    @endif

    <!-- Previsão -->
    @if($boletim->previsao_hidrologica)
    <div class="section">
        <div class="section-title">PREVISÃO HIDROLÓGICA</div>
        <p style="text-align: justify; margin: 0;">{{ $boletim->previsao_hidrologica }}</p>
    </div>
    @endif

    <!-- Alertas e Precauções -->
    @if($boletim->alertas_precaucoes)
    <div class="section">
        <div class="section-title">ALERTAS E PRECAUÇÕES</div>
        <p style="text-align: justify; margin: 0;">{{ $boletim->alertas_precaucoes }}</p>
    </div>
    @endif

    <!-- Footer -->
    <div class="footer">
        <div class="footer-info">
            <div>
                <strong>Elaborado por:</strong> {{ $boletim->elaborador->name ?? 'Sistema' }}<br>
                <strong>Data de Elaboração:</strong> {{ \Carbon\Carbon::parse($boletim->created_at)->format('d/m/Y H:i') }}
                @if($boletim->aprovador)
                <br><strong>Aprovado por:</strong> {{ $boletim->aprovador->name }}
                @endif
            </div>
            <div style="text-align: right;">
                <strong>Contactos:</strong><br>
                Tel: {{ $settings['contact_phone'] ?? '+258 21 430 906' }}<br>
                Email: {{ $settings['contact_email'] ?? 'dngrh@mophrh.gov.mz' }}
                @if($settings['contact_address'] ?? false)
                <br>{{ $settings['contact_address'] }}
                @endif
                @if($settings['website_url'] ?? false)
                <br>{{ $settings['website_url'] }}
                @endif
            </div>
        </div>
    </div>
</body>
</html>