<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Boletim Hidrológico da Província</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #000;
            max-width: 210mm;
            margin: 0 auto;
            padding: 20px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #0066cc;
            padding-bottom: 15px;
        }

        .header-left {
            display: flex;
            align-items: center;
        }

        .logo-ara {
            margin-right: 20px;
        }

        .ara-title {
            color: #0066cc;
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .ara-subtitle {
            color: #666;
            font-size: 10px;
            margin-bottom: 5px;
            text-transform: uppercase;
        }

        .ara-location {
            color: #0066cc;
            font-size: 14px;
            font-weight: bold;
        }

        .header-right {
            text-align: center;
        }

        .logo-ministerio {
            width: 80px;
            height: 80px;
            border: 1px solid #ccc;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #f0f8ff;
        }

        .title-section {
            text-align: center;
            margin: 25px 0;
        }

        .main-title {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 10px;
            text-transform: uppercase;
            line-height: 1.3;
        }

        .date-title {
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 12px;
            font-weight: bold;
            margin: 20px 0 10px 0;
            text-transform: uppercase;
        }

        .section-number {
            margin-right: 10px;
        }

        .content-section {
            margin-bottom: 20px;
            text-align: justify;
        }

        .subsection-title {
            font-weight: bold;
            margin: 15px 0 8px 0;
        }

        .precipitation-data {
            margin: 10px 0;
            font-style: italic;
        }

        .dam-data {
            margin: 10px 0;
        }

        .dam-item {
            margin-bottom: 8px;
            padding-left: 15px;
            position: relative;
        }

        .dam-item:before {
            content: "◆";
            position: absolute;
            left: 0;
            color: #0066cc;
            font-weight: bold;
        }

        .highlight {
            font-weight: bold;
        }

        .alert-section {
            margin: 15px 0;
        }

        .legend-section {
            margin-top: 30px;
            padding: 15px;
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        .legend-title {
            font-weight: bold;
            margin-bottom: 10px;
        }

        .legend-item {
            margin-bottom: 5px;
            font-size: 10px;
        }

        .signature-section {
            margin-top: 40px;
            text-align: center;
        }

        .signature-title {
            margin-bottom: 30px;
            font-size: 11px;
        }

        .signature-line {
            border-bottom: 1px solid #000;
            width: 250px;
            margin: 0 auto 10px;
        }

        .signature-name {
            font-weight: bold;
            margin-bottom: 5px;
        }

        .signature-position {
            font-size: 10px;
            color: #666;
        }

        .footer {
            margin-top: 40px;
            background: linear-gradient(135deg, #87ceeb 0%, #4682b4 100%);
            color: white;
            text-align: center;
            padding: 20px;
            border-radius: 10px;
        }

        .footer-logo {
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .contact-info {
            font-size: 11px;
            margin-bottom: 8px;
        }

        .address {
            font-size: 10px;
        }

        .value-highlight {
            font-weight: bold;
            color: #0066cc;
        }

        .percentage {
            color: #d63384;
            font-weight: bold;
        }

        .date-highlight {
            color: #198754;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-left">
            <div class="logo-ara">
                <div class="ara-title">ARA</div>
                <div class="ara-subtitle">Administração Regional de Águas do Norte</div>
                <div class="ara-location">Norte,IP</div>
            </div>
        </div>
        <div class="header-right">
            <div class="logo-ministerio">
                <span style="font-size: 8px; text-align: center;">Logo<br>Ministério</span>
            </div>
        </div>
    </div>

    <div class="title-section">
        <div class="main-title">
            BOLETIM HIDROLÓGICO DA PROVÍNCIA DE NAMPULA: Nº {{ $numero_edicao }}
        </div>
        <div class="date-title">
            DIA {{ \Carbon\Carbon::parse($data_emissao)->format('d.m.Y') }}
        </div>
    </div>

    <div class="content-section">
        <div class="section-title">
            <span class="section-number">1.</span>SITUAÇÃO PREVALECENTE
        </div>

        <div class="subsection-title">
            Precipitação registada nas últimas 24 horas nas bacias hidrográfica da província de Nampula:
        </div>

        <p>Nas últimas 24 horas houve registo de precipitação na rede de observação da região Norte:</p>

        <div class="precipitation-data">
            <strong>BACIA HIDROGRÁFICA DO LÚRIO</strong> (P-201 Ribáuè: <span class="value-highlight">{{ $dados['precipitacao']['ribaue'] ?? '2.6' }} mm</span>; P-1156 Malema: <span class="value-highlight">{{ $dados['precipitacao']['malema'] ?? '1.2' }} mm</span>).
        </div>

        <div class="subsection-title">
            Comportamento dos níveis hidrométricos nas principais bacias da região.
        </div>

        <p>Nas últimas 24h observou-se descida dos níveis hidrométricos nas bacias hidrográficas da região, com excepção da bacia do Lúrio em Mutauali que registou ligeira subida na ordem dos 90 cm.</p>
    </div>

    <div class="content-section">
        <div class="section-title">
            <span class="section-number">2.</span>SITUAÇÃO DE ENCHIMENTO DAS ALBUFEIRAS
        </div>

        <div class="dam-data">
            @foreach($barragens as $barragem)
            <div class="dam-item">
                <strong>Barragem de {{ $barragem['nome'] ?? 'N/A' }}:</strong> (<span class="percentage">{{ isset($barragem['percentual_enchimento']) ? number_format($barragem['percentual_enchimento'], 2) : '0.00' }}%</span>, <span class="value-highlight">{{ isset($barragem['volume_atual']) ? number_format($barragem['volume_atual'], 3) : '0.000' }} Mm³</span>), Q<sub>ef</sub> = <span class="value-highlight">{{ $barragem['caudal_efluente'] ?? '0' }} m³/s</span>; {{ ($barragem['nivel_atual'] ?? 0) > ($barragem['nivel_alerta'] ?? 0) ? 'Nível estacionário' : 'Nível a baixar' }}.
            </div>
            @endforeach
        </div>
    </div>

    <div class="content-section">
        <div class="section-title">
            <span class="section-number">3.</span>PREVISÃO HIDROLÓGICA
        </div>

        <p>Para as próximas 24 horas, não prevê-se alterações significativas do actual cenário hidrológico</p>
    </div>

    <div class="content-section">
        <div class="section-title">
            <span class="section-number">4.</span>ALERTA E PRECAUÇÕES
        </div>

        <p>A ARA-Norte, IP, apela à sociedade para a observância de medidas de precaução, evitar a travessia de cursos de água. Apela-se igualmente ao acompanhamento da informação hidrológica disseminada pela ARA Norte, IP, e outras entidades competentes.</p>
    </div>

    <div class="legend-section">
        <div class="legend-title">Legenda:</div>
        <div class="legend-item"><strong>NA:</strong> Nível de alerta</div>
        <div class="legend-item"><strong>S/NA:</strong> Sem Nível de alerta</div>
        <div class="legend-item"><strong>SI:</strong> Sem informação</div>
        <div class="legend-item"><strong>Q<sub>ef</sub>:</strong> Vazão efluente</div>
    </div>

    <div class="signature-section">
        <div class="signature-title">
            O chefe do Departamento dos Recursos Hídricos
        </div>
        <div class="signature-line"></div>
        <div class="signature-name">{{ $responsavel_nome ?? 'João Alberto Miguel Sitoe' }}</div>
        <div class="signature-position">({{ $responsavel_cargo ?? 'Técnico Superior N1' }})</div>
    </div>

    <div class="footer">
        <div class="footer-logo">A</div>
        <div class="contact-info">
            ☎ +258 86 201 7777 &nbsp;&nbsp;&nbsp; ✉ aranortep@aranorte.gov.mz
        </div>
        <div class="address">
            📍 Estrada Nacional nº 1, Bairro Mutauanha, Nampula-Moçambique
        </div>
    </div>
</body>
</html>