<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Boletim Hidrológico Regional</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #000;
            margin: 20px;
            padding: 0;
        }

        .header {
            margin-bottom: 15px;
            border-bottom: 2px solid #0066cc;
            padding-bottom: 10px;
            text-align: center;
        }

        .header-content {
            width: 100%;
        }

        .logo-ara {
            width: 120px;
            height: auto;
            margin-right: 20px;
        }

        .header-right {
            text-align: center;
        }

        .logo-ministerio {
            width: 80px;
            height: auto;
        }

        .title-section {
            text-align: center;
            margin: 20px 0;
        }

        .main-title {
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 5px;
            text-transform: uppercase;
            line-height: 1.3;
        }

        .subtitle {
            font-size: 10px;
            font-weight: bold;
            margin-bottom: 15px;
        }

        .content-wrapper {
            width: 100%;
            margin-top: 15px;
        }

        .map-section {
            width: 100%;
            margin-bottom: 15px;
        }

        .map-container {
            border: 1px solid #ccc;
            padding: 8px;
            text-align: left;
            background-color: #f9f9f9;
        }

        .map-legend {
            margin-top: 20px;
            font-size: 8px;
        }

        .legend-item {
            margin-bottom: 2px;
            line-height: 1.2;
        }

        .legend-color {
            display: inline-block;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            margin-right: 3px;
            vertical-align: middle;
        }

        .red { background-color: #ff4444; }
        .orange { background-color: #ff8844; }

        .info-section {
            width: 100%;
        }

        .section-title {
            font-size: 11px;
            font-weight: bold;
            margin: 15px 0 8px 0;
            text-transform: uppercase;
        }

        .station-data {
            margin-bottom: 10px;
        }

        .station-row {
            margin-bottom: 5px;
            line-height: 1.3;
        }

        .highlight {
            color: #cc0000;
            font-weight: bold;
        }

        .alert-box {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            padding: 10px;
            margin: 10px 0;
            border-radius: 3px;
        }

        .dam-data {
            margin-bottom: 8px;
        }

        .dam-item {
            margin-bottom: 5px;
            margin-left: 15px;
        }

        .footer {
            margin-top: 25px;
            padding-top: 12px;
            border-top: 1px solid #ccc;
        }

        .signature-section {
            text-align: center;
            margin-top: 20px;
        }

        .signature-line {
            border-bottom: 1px solid #000;
            width: 200px;
            margin: 20px auto 5px;
        }

        .signature-name {
            font-weight: bold;
            margin-bottom: 3px;
        }

        .signature-title {
            font-size: 10px;
            color: #666;
        }

        .bottom-section {
            background-color: #4682b4;
            color: white;
            text-align: center;
            padding: 12px;
            margin-top: 20px;
        }

        .contact-info {
            font-size: 9px;
            margin-bottom: 3px;
        }

        .address {
            font-size: 8px;
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <div style="width: 60px; height: 60px; border: 1px solid #ccc; border-radius: 50%; background-color: #f0f8ff; margin: 0 auto 15px auto; display: block; text-align: center; line-height: 60px; font-size: 7px;">Logo<br>Ministério</div>
            <div style="color: #0066cc; font-size: 14px; font-weight: bold; line-height: 1.3; margin-bottom: 5px;">{{ $settings['organization_name'] ?? 'MINISTÉRIO DAS OBRAS PÚBLICAS, HABITAÇÃO E RECURSOS HÍDRICOS' }}</div>
            <div style="color: #666; font-size: 10px; margin-bottom: 10px;">{{ $settings['department_name'] ?? 'DIRECÇÃO NACIONAL DE GESTÃO DE RECURSOS HÍDRICOS' }}</div>
        </div>
    </div>

    <div class="title-section">
        <div class="main-title">BOLETIM HIDROLÓGICO REGIONAL: Nº {{ $numero_edicao }}</div>
        <div class="subtitle">SUMÁRIO DO DIA {{ \Carbon\Carbon::parse($data_emissao)->format('d.m.Y') }}</div>
    </div>

    <div class="content-wrapper">
        <div class="map-section">
            <div class="map-container">
                <div style="font-size: 10px; margin-bottom: 10px; font-weight: bold; text-align: center;">LEGENDA</div>
                <div style="text-align: left; margin: 10px; font-size: 8px; line-height: 1.2;">
                    @for($i = 1; $i <= 30; $i++)
                        <div style="margin-bottom: 2px;">
                            {{ $i }} {{ $estacoes[$i-1]['nome'] ?? 'Estação ' . $i }}
                        </div>
                    @endfor
                </div>

                <div class="map-legend">
                    <div class="legend-item">
                        <div class="legend-color red"></div>
                        <span>Estações em alerta</span>
                    </div>
                    <div class="legend-item">
                        <div class="legend-color orange"></div>
                        <span>Risco de erosão</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="info-section">
            <div class="section-title">1. SITUAÇÃO PREVALECENTE</div>
            <div class="station-data">
                <strong>Precipitação registada nas últimas 24 horas:</strong><br>
                @if(!empty($dados['precipitacao_estacoes']))
                    Nas últimas 24 horas houve registo de precipitação na rede de observação da região Norte:<br><br>

                    @php
                        $precipitacao_por_bacia = collect($dados['precipitacao_estacoes'])->groupBy('bacia');
                    @endphp

                    @foreach($precipitacao_por_bacia as $bacia => $estacoes)
                        <div class="station-row">
                            <strong>{{ strtoupper($bacia) }}:</strong>
                            @foreach($estacoes as $index => $estacao)
                                @if($index > 0); @endif
                                <strong>{{ $estacao['codigo'] }} {{ $estacao['estacao'] }}:</strong> {{ $estacao['precipitacao'] }} mm
                            @endforeach
                        </div>
                    @endforeach
                @else
                    Nas últimas 24 horas não houve registo de precipitação na rede de observação da região Norte.<br><br>
                @endif
            </div>

            <div class="section-title">Comportamento dos níveis hidrométricos nas principais bacias da região:</div>
            <div class="station-data">
                <div class="dam-item">{{ $dados['analise_niveis']['texto'] ?? '• Não há dados disponíveis de níveis hidrométricos para análise.' }}</div>
            </div>

            <div class="section-title">2. ENCHIMENTO DAS PRINCIPAIS ALBUFEIRAS</div>
            <div class="dam-data">
                @foreach($barragens as $barragem)
                <div class="dam-item">
                    • <strong>Barragem de {{ $barragem->nome }}:</strong> ({{ number_format($barragem->percentual_enchimento, 2) }}%, {{ number_format($barragem->volume_atual, 3) }} Mm³), Q<sub>ef</sub> = {{ $barragem->caudal_efluente ?? '0' }} m³/s; {{ $barragem->nivel_atual > $barragem->nivel_alerta ? 'Nível a baixar' : 'Nível estacionário' }}.
                </div>
                @endforeach
            </div>

            <div class="section-title">3. PREVISÃO HIDROLÓGICA PARA AS PRÓXIMAS 24 HORAS.</div>
            <div class="station-data">
                {{ $boletim->previsao_hidrologica }}
            </div>

            <div class="section-title">4. ALERTA E PRECAUÇÕES</div>
            <div class="station-data">
                A ARA-Norte, IP, apela à sociedade para a observância de medidas de precaução, evitar a travessia de cursos de água. Apela-se igualmente ao acompanhamento da informação hidrológica disseminada pela ARA Norte, IP, e outras entidades competentes.
            </div>
        </div>
    </div>

    <div class="footer">
        <div class="signature-section">
            <div style="text-align: center; margin-bottom: 20px;">
                O chefe do Departamento dos Recursos Hídricos
            </div>
            <div class="signature-line"></div>
            <div class="signature-name">{{ $responsavel_nome ?? 'João Alberto Miguel Sitoe' }}</div>
            <div class="signature-title">({{ $responsavel_cargo ?? 'Técnico Superior N1' }})</div>
        </div>
    </div>

    <div class="bottom-section">
        <div style="font-size: 16px; font-weight: bold; margin-bottom: 10px;">{{ $settings['organization_name'] ?? 'MINISTÉRIO DAS OBRAS PÚBLICAS' }}</div>
        <div class="contact-info">
            Tel: {{ $settings['contact_phone'] ?? '+258 21 430 906' }} | Email: {{ $settings['contact_email'] ?? 'dngrh@mophrh.gov.mz' }}
        </div>
        <div class="address">
            Endereco: {{ $settings['contact_address'] ?? 'Av. 25 de Setembro, 1218, Maputo - Moçambique' }}
        </div>
        @if($settings['website_url'] ?? false)
        <div style="margin-top: 5px; font-size: 8px;">
            Website: {{ $settings['website_url'] }}
        </div>
        @endif
    </div>
</body>
</html>