<!-- Modal de Importação -->
<div id="importModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-4xl max-h-[90vh] overflow-hidden">

            <!-- Header do Modal -->
            <div class="bg-gradient-to-r from-blue-600 to-blue-700 px-6 py-4 text-white">
                <div class="flex justify-between items-center">
                    <div>
                        <h3 class="text-xl font-bold flex items-center">
                            <i class="fas fa-file-import mr-3"></i>
                            Importar Leituras - {{ $estacao->nome }}
                        </h3>
                        <p class="text-blue-100 text-sm mt-1">
                            Importe dados de leituras a partir de arquivos Excel ou CSV
                        </p>
                    </div>
                    <button type="button" onclick="hideImportModal()" class="text-white hover:text-gray-200 text-2xl">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

            <div class="p-6 space-y-6">
                <!-- Instruções -->
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <h4 class="font-semibold text-blue-900 mb-3 flex items-center">
                        <i class="fas fa-info-circle mr-2"></i>
                        Como Importar Dados
                    </h4>
                    <div class="text-sm text-blue-800 space-y-2">
                        <p>• <strong>Formatos aceitos:</strong> .xlsx, .xls, .csv</p>
                        <p>• <strong>Colunas reconhecidas:</strong> data, nivel_6h, nivel_12h, nivel_18h, precipitacao, temperatura_max, temperatura_min, etc.</p>
                        <p>• <strong>Formato de data:</strong> dd/mm/aaaa ou aaaa-mm-dd</p>
                        <p>• <strong>Separador decimal:</strong> Use vírgula (,) ou ponto (.)</p>
                        <p>• <strong>Primeira linha:</strong> Deve conter os nomes das colunas</p>
                    </div>
                </div>

                <!-- Formulário de Upload -->
                <form id="importForm" enctype="multipart/form-data">
                    @csrf
                    <div class="space-y-4">
                        <!-- Upload de Arquivo -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                <i class="fas fa-upload mr-1"></i>
                                Selecionar Arquivo
                            </label>
                            <div class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-blue-400 transition-colors">
                                <input type="file"
                                       id="arquivo_importacao"
                                       name="arquivo_importacao"
                                       accept=".xlsx,.xls,.csv"
                                       class="hidden"
                                       onchange="handleFileSelect(this)">

                                <div id="dropzone" onclick="document.getElementById('arquivo_importacao').click()" class="cursor-pointer">
                                    <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-4"></i>
                                    <p class="text-lg font-medium text-gray-600 mb-2">Clique para selecionar o arquivo</p>
                                    <p class="text-sm text-gray-500">ou arraste e solte aqui</p>
                                    <p class="text-xs text-gray-400 mt-2">Máximo: 10MB</p>
                                </div>

                                <div id="selected-file" class="hidden">
                                    <i class="fas fa-file-excel text-4xl text-green-600 mb-4"></i>
                                    <p class="text-lg font-medium text-gray-800" id="file-name"></p>
                                    <p class="text-sm text-gray-500" id="file-size"></p>
                                    <button type="button" onclick="clearFileSelection()" class="text-red-600 hover:text-red-800 text-sm mt-2">
                                        <i class="fas fa-times mr-1"></i>
                                        Remover arquivo
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Opções de Importação -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Ação para Duplicatas
                                </label>
                                <select name="acao_duplicatas" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="sobrescrever">Sobrescrever dados existentes</option>
                                    <option value="ignorar">Ignorar duplicatas</option>
                                    <option value="erro">Gerar erro para duplicatas</option>
                                </select>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    Validação
                                </label>
                                <select name="nivel_validacao" class="w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="rigorosa">Validação rigorosa</option>
                                    <option value="flexivel">Validação flexível</option>
                                    <option value="minima">Validação mínima</option>
                                </select>
                            </div>
                        </div>

                        <!-- Preview dos Dados -->
                        <div id="preview-container" class="hidden">
                            <h5 class="font-medium text-gray-900 mb-3 flex items-center">
                                <i class="fas fa-eye mr-2"></i>
                                Preview dos Dados
                            </h5>
                            <div class="bg-gray-50 rounded-lg p-4 max-h-64 overflow-auto">
                                <div id="preview-content">
                                    <!-- Conteúdo será inserido via JavaScript -->
                                </div>
                            </div>
                        </div>

                        <!-- Estatísticas da Importação -->
                        <div id="import-stats" class="hidden grid grid-cols-2 md:grid-cols-4 gap-4">
                            <div class="bg-blue-50 rounded-lg p-3 text-center">
                                <div class="text-2xl font-bold text-blue-600" id="total-registros">0</div>
                                <div class="text-sm text-blue-800">Registros</div>
                            </div>
                            <div class="bg-green-50 rounded-lg p-3 text-center">
                                <div class="text-2xl font-bold text-green-600" id="registros-validos">0</div>
                                <div class="text-sm text-green-800">Válidos</div>
                            </div>
                            <div class="bg-yellow-50 rounded-lg p-3 text-center">
                                <div class="text-2xl font-bold text-yellow-600" id="duplicatas">0</div>
                                <div class="text-sm text-yellow-800">Duplicatas</div>
                            </div>
                            <div class="bg-red-50 rounded-lg p-3 text-center">
                                <div class="text-2xl font-bold text-red-600" id="erros">0</div>
                                <div class="text-sm text-red-800">Erros</div>
                            </div>
                        </div>

                        <!-- Relatório de Erros -->
                        <div id="error-report" class="hidden">
                            <h5 class="font-medium text-red-900 mb-3 flex items-center">
                                <i class="fas fa-exclamation-triangle mr-2"></i>
                                Relatório de Erros
                            </h5>
                            <div class="bg-red-50 border border-red-200 rounded-lg p-4 max-h-40 overflow-auto">
                                <ul id="error-list" class="text-sm text-red-800 space-y-1">
                                    <!-- Erros serão inseridos via JavaScript -->
                                </ul>
                            </div>
                        </div>
                    </div>
                </form>

                <!-- Resultado da Importação -->
                <div id="import-result" class="hidden">
                    <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                        <div class="flex items-center">
                            <i class="fas fa-check-circle text-green-600 mr-3 text-xl"></i>
                            <div>
                                <h4 class="font-medium text-green-800">Importação Concluída!</h4>
                                <p class="text-sm text-green-700 mt-1" id="import-success-message"></p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Barra de Progresso -->
                <div id="progress-container" class="hidden">
                    <div class="flex items-center justify-between mb-2">
                        <span class="text-sm font-medium text-gray-700">Processando arquivo...</span>
                        <span class="text-sm text-gray-500" id="progress-text">0%</span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-2">
                        <div id="progress-bar" class="bg-blue-600 h-2 rounded-full transition-all duration-300" style="width: 0%"></div>
                    </div>
                </div>
            </div>

            <!-- Footer do Modal -->
            <div class="bg-gray-50 px-6 py-4 border-t flex justify-between items-center">
                <div class="flex items-center space-x-4">
                    <div class="relative">
                        <button type="button" onclick="toggleTemplatesDropdown()"
                                class="text-sm text-blue-600 hover:text-blue-800 flex items-center">
                            <i class="fas fa-download mr-1"></i>
                            Baixar Templates
                            <i class="fas fa-chevron-down ml-1"></i>
                        </button>

                        <div id="templates-dropdown" class="hidden absolute bottom-full left-0 mb-2 w-64 bg-white rounded-lg shadow-lg border border-gray-200 z-10">
                            <div class="p-3">
                                <h4 class="font-medium text-gray-900 mb-2">Escolha o Template:</h4>
                                <div class="space-y-2">
                                    <a href="{{ route('templates.leituras', [$estacao->tipo, 'novo']) }}"
                                       class="block p-2 rounded hover:bg-gray-50 border border-gray-200">
                                        <div class="font-medium text-blue-600">📊 Template Moderno</div>
                                        <div class="text-xs text-gray-500">Formato otimizado com validações</div>
                                    </a>

                                    <a href="{{ route('templates.leituras', [$estacao->tipo, 'existente']) }}"
                                       class="block p-2 rounded hover:bg-gray-50 border border-gray-200">
                                        <div class="font-medium text-green-600">📋 Template Atual</div>
                                        <div class="text-xs text-gray-500">Formato já usado no sistema</div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <span class="text-sm text-gray-500">|</span>

                    <button type="button" onclick="mostrarExemplosFormato()"
                            class="text-sm text-gray-600 hover:text-gray-800 flex items-center">
                        <i class="fas fa-question-circle mr-1"></i>
                        Formatos Aceitos
                    </button>
                </div>

                <div class="flex space-x-3">
                    <button type="button" onclick="hideImportModal()"
                            class="bg-gray-300 hover:bg-gray-400 text-gray-700 px-6 py-2 rounded-lg">
                        <i class="fas fa-times mr-2"></i>
                        Cancelar
                    </button>
                    <button type="button" onclick="processImport()" id="import-btn"
                            class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg disabled:opacity-50 disabled:cursor-not-allowed" disabled>
                        <i class="fas fa-upload mr-2"></i>
                        Importar Dados
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Funções do Modal de Importação
function showImportModal() {
    document.getElementById('importModal').classList.remove('hidden');
}

function hideImportModal() {
    document.getElementById('importModal').classList.add('hidden');
    clearFileSelection();
}

function clearFileSelection() {
    document.getElementById('arquivo_importacao').value = '';
    document.getElementById('selected-file').classList.add('hidden');
    document.getElementById('dropzone').classList.remove('hidden');
    document.getElementById('preview-container').classList.add('hidden');
    document.getElementById('import-stats').classList.add('hidden');
    document.getElementById('import-btn').disabled = true;
}

function handleFileSelect(input) {
    const file = input.files[0];
    if (!file) return;

    // Validar tamanho (10MB)
    if (file.size > 10 * 1024 * 1024) {
        alert('Arquivo muito grande. Máximo permitido: 10MB');
        clearFileSelection();
        return;
    }

    // Validar extensão
    const allowedExtensions = ['.xlsx', '.xls', '.csv'];
    const fileExtension = '.' + file.name.split('.').pop().toLowerCase();
    if (!allowedExtensions.includes(fileExtension)) {
        alert('Formato de arquivo não suportado. Use: .xlsx, .xls ou .csv');
        clearFileSelection();
        return;
    }

    // Mostrar arquivo selecionado
    document.getElementById('dropzone').classList.add('hidden');
    document.getElementById('selected-file').classList.remove('hidden');
    document.getElementById('file-name').textContent = file.name;
    document.getElementById('file-size').textContent = formatFileSize(file.size);
    document.getElementById('import-btn').disabled = false;

    // Processar preview
    generatePreview(file);
}

function formatFileSize(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}

function generatePreview(file) {
    const reader = new FileReader();

    reader.onload = function(e) {
        try {
            let data;

            if (file.name.endsWith('.csv')) {
                data = parseCSV(e.target.result);
            } else {
                // Para Excel, você precisaria de uma biblioteca como SheetJS
                // Por agora, vamos simular
                data = simulateExcelData();
            }

            displayPreview(data);
            updateStats(data);

        } catch (error) {
            console.error('Erro ao processar arquivo:', error);
            alert('Erro ao processar arquivo: ' + error.message);
        }
    };

    if (file.name.endsWith('.csv')) {
        reader.readAsText(file);
    } else {
        reader.readAsArrayBuffer(file);
    }
}

function parseCSV(csvText) {
    const lines = csvText.split('\n');
    const headers = lines[0].split(',').map(h => h.trim());

    const data = [];
    for (let i = 1; i < lines.length && i < 6; i++) { // Preview apenas 5 linhas
        if (lines[i].trim()) {
            const values = lines[i].split(',');
            const row = {};
            headers.forEach((header, index) => {
                row[header] = values[index]?.trim() || '';
            });
            data.push(row);
        }
    }

    return { headers, rows: data, total: lines.length - 1 };
}

function simulateExcelData() {
    // Simular dados Excel para preview
    return {
        headers: ['data', 'nivel_6h', 'nivel_12h', 'nivel_18h', 'precipitacao'],
        rows: [
            { data: '01/01/2024', nivel_6h: '2.45', nivel_12h: '2.47', nivel_18h: '2.43', precipitacao: '0.0' },
            { data: '02/01/2024', nivel_6h: '2.50', nivel_12h: '2.52', nivel_18h: '2.48', precipitacao: '15.2' }
        ],
        total: 2
    };
}

function displayPreview(data) {
    const container = document.getElementById('preview-content');

    let html = '<table class="min-w-full divide-y divide-gray-200 text-sm">';
    html += '<thead class="bg-gray-100"><tr>';

    data.headers.forEach(header => {
        html += `<th class="px-3 py-2 text-left font-medium text-gray-700">${header}</th>`;
    });

    html += '</tr></thead><tbody class="divide-y divide-gray-200">';

    data.rows.forEach(row => {
        html += '<tr>';
        data.headers.forEach(header => {
            html += `<td class="px-3 py-2 text-gray-900">${row[header] || '-'}</td>`;
        });
        html += '</tr>';
    });

    html += '</tbody></table>';

    if (data.total > data.rows.length) {
        html += `<p class="text-sm text-gray-500 mt-2">... e mais ${data.total - data.rows.length} registros</p>`;
    }

    container.innerHTML = html;
    document.getElementById('preview-container').classList.remove('hidden');
}

function updateStats(data) {
    document.getElementById('total-registros').textContent = data.total;
    document.getElementById('registros-validos').textContent = data.rows.length;
    document.getElementById('duplicatas').textContent = '0';
    document.getElementById('erros').textContent = '0';

    document.getElementById('import-stats').classList.remove('hidden');
}

async function processImport() {
    const fileInput = document.getElementById('arquivo_importacao');
    const file = fileInput.files[0];

    if (!file) {
        alert('Selecione um arquivo primeiro');
        return;
    }

    const formData = new FormData();
    formData.append('arquivo_importacao', file);
    formData.append('acao_duplicatas', document.querySelector('[name="acao_duplicatas"]').value);
    formData.append('nivel_validacao', document.querySelector('[name="nivel_validacao"]').value);
    formData.append('_token', document.querySelector('[name="_token"]').value);

    // Mostrar progresso
    document.getElementById('progress-container').classList.remove('hidden');
    document.getElementById('import-btn').disabled = true;

    try {
        const response = await fetch(`/api/estacoes/${window.estacaoId}/leituras/importar`, {
            method: 'POST',
            body: formData
        });

        const result = await response.json();

        if (result.success) {
            document.getElementById('import-result').classList.remove('hidden');
            document.getElementById('import-success-message').textContent = result.message;

            if (result.erros && result.erros.length > 0) {
                showErrorReport(result.erros);
            }

            // Recarregar página após 3 segundos
            setTimeout(() => {
                location.reload();
            }, 3000);

        } else {
            alert('Erro na importação: ' + result.message);
        }

    } catch (error) {
        console.error('Erro:', error);
        alert('Erro ao processar importação: ' + error.message);
    } finally {
        document.getElementById('progress-container').classList.add('hidden');
        document.getElementById('import-btn').disabled = false;
    }
}

function showErrorReport(errors) {
    const errorList = document.getElementById('error-list');
    errorList.innerHTML = '';

    errors.forEach(error => {
        const li = document.createElement('li');
        li.textContent = error;
        errorList.appendChild(li);
    });

    document.getElementById('error-report').classList.remove('hidden');
}

function toggleTemplatesDropdown() {
    const dropdown = document.getElementById('templates-dropdown');
    dropdown.classList.toggle('hidden');
}

function mostrarExemplosFormato() {
    const modal = document.createElement('div');
    modal.className = 'fixed inset-0 bg-gray-600 bg-opacity-50 z-50 flex items-center justify-center p-4';
    modal.innerHTML = `
        <div class="bg-white rounded-lg shadow-xl max-w-2xl w-full max-h-[80vh] overflow-y-auto">
            <div class="bg-blue-600 px-6 py-4 text-white">
                <div class="flex justify-between items-center">
                    <h3 class="text-lg font-bold">Formatos Aceitos para Importação</h3>
                    <button onclick="this.closest('.fixed').remove()" class="text-white hover:text-gray-200">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>

            <div class="p-6 space-y-6">
                <div>
                    <h4 class="font-semibold text-gray-900 mb-3">📅 Formatos de Data Aceitos:</h4>
                    <div class="grid grid-cols-2 gap-2 text-sm">
                        <div class="bg-gray-50 p-2 rounded">dd/mm/aaaa (01/12/2024)</div>
                        <div class="bg-gray-50 p-2 rounded">dd-mm-aaaa (01-12-2024)</div>
                        <div class="bg-gray-50 p-2 rounded">aaaa-mm-dd (2024-12-01)</div>
                        <div class="bg-gray-50 p-2 rounded">dd.mm.aaaa (01.12.2024)</div>
                        <div class="bg-gray-50 p-2 rounded">mm/dd/aaaa (12/01/2024)</div>
                        <div class="bg-gray-50 p-2 rounded">d/m/aaaa (1/12/2024)</div>
                    </div>
                </div>

                <div>
                    <h4 class="font-semibold text-gray-900 mb-3">🔢 Formatos Numéricos:</h4>
                    <div class="text-sm space-y-1">
                        <div>• Use vírgula (,) ou ponto (.) para decimais</div>
                        <div>• Exemplos: 2,45 ou 2.45 para níveis</div>
                        <div>• Deixe células vazias se não houver dados</div>
                    </div>
                </div>

                <div>
                    <h4 class="font-semibold text-gray-900 mb-3">📊 Colunas Reconhecidas Automaticamente:</h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div>
                            <strong>Estações Hidrométricas:</strong>
                            <ul class="list-disc list-inside mt-1 space-y-1">
                                <li>Data, Data da Leitura</li>
                                <li>Nível 6h, Nivel_6h, Manhã</li>
                                <li>Nível 12h, Nivel_12h, Meio-dia</li>
                                <li>Nível 18h, Nivel_18h, Tarde</li>
                                <li>Altura, Cota, Leitura</li>
                            </ul>
                        </div>
                        <div>
                            <strong>Estações Meteorológicas:</strong>
                            <ul class="list-disc list-inside mt-1 space-y-1">
                                <li>Precipitação, Chuva, PP</li>
                                <li>Temp Max, Temperatura Máxima</li>
                                <li>Temp Min, Temperatura Mínima</li>
                                <li>Humidade, HR, Umidade</li>
                                <li>Pressão, Pressão Atmosférica</li>
                                <li>Vento, Velocidade Vento</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                    <h4 class="font-semibold text-yellow-800 mb-2">💡 Dicas Importantes:</h4>
                    <ul class="text-sm text-yellow-700 space-y-1">
                        <li>• Mantenha a primeira linha com os nomes das colunas</li>
                        <li>• O sistema reconhece automaticamente variações dos nomes</li>
                        <li>• Pode misturar templates novos e existentes</li>
                        <li>• Dados duplicados podem ser sobrescritos ou ignorados</li>
                        <li>• Arquivos grandes (>10MB) podem demorar para processar</li>
                    </ul>
                </div>
            </div>

            <div class="bg-gray-50 px-6 py-4 border-t">
                <button onclick="this.closest('.fixed').remove()"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                    Entendi
                </button>
            </div>
        </div>
    `;

    document.body.appendChild(modal);

    // Fechar ao clicar fora
    modal.addEventListener('click', function(e) {
        if (e.target === this) {
            this.remove();
        }
    });
}

// Drag and Drop
const dropzone = document.getElementById('importModal');
if (dropzone) {
    ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
        dropzone.addEventListener(eventName, preventDefaults, false);
    });

    function preventDefaults(e) {
        e.preventDefault();
        e.stopPropagation();
    }

    dropzone.addEventListener('drop', handleDrop, false);

    function handleDrop(e) {
        const dt = e.dataTransfer;
        const files = dt.files;

        if (files.length > 0) {
            document.getElementById('arquivo_importacao').files = files;
            handleFileSelect(document.getElementById('arquivo_importacao'));
        }
    }
}

// Fechar modal ao clicar fora
document.getElementById('importModal')?.addEventListener('click', function(e) {
    if (e.target === this) {
        hideImportModal();
    }
});
</script>