@extends('layouts.app')

@section('title', 'Editar Estação')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-edit mr-3 text-green-600"></i>
                    Editar Estação
                </h1>
                <p class="text-gray-600 mt-2">Atualizar dados da estação {{ $estacao->nome }}</p>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('estacoes.show', $estacao) }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg flex items-center">
                    <i class="fas fa-eye mr-2"></i>
                    Ver Estação
                </a>
                <a href="{{ route('estacoes.index') }}" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar
                </a>
            </div>
        </div>
    </div>

    <!-- Form -->
    <div class="bg-white rounded-lg shadow">
        <form action="{{ route('estacoes.update', $estacao) }}" method="POST" class="p-6 space-y-6">
            @csrf
            @method('PUT')
            
            <!-- Informações Básicas -->
            <div>
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informações Básicas</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="nome" class="block text-sm font-medium text-gray-700 mb-2">Nome da Estação *</label>
                        <input type="text" id="nome" name="nome" value="{{ old('nome', $estacao->nome) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('nome') border-red-500 @enderror">
                        @error('nome')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="codigo" class="block text-sm font-medium text-gray-700 mb-2">Código *</label>
                        <input type="text" id="codigo" name="codigo" value="{{ old('codigo', $estacao->codigo) }}" required
                               placeholder="EST-001"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('codigo') border-red-500 @enderror">
                        @error('codigo')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="tipo" class="block text-sm font-medium text-gray-700 mb-2">Tipo *</label>
                        <select id="tipo" name="tipo" required class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500 @error('tipo') border-red-500 @enderror">
                            <option value="">Selecione o tipo</option>
                            <option value="hidrometrica" {{ old('tipo', $estacao->tipo) == 'hidrometrica' ? 'selected' : '' }}>Hidrométrica - Mede níveis de água</option>
                            <option value="pluviometrica" {{ old('tipo', $estacao->tipo) == 'pluviometrica' ? 'selected' : '' }}>Pluviométrica - Mede chuva</option>
                            <option value="evaporimetrica" {{ old('tipo', $estacao->tipo) == 'evaporimetrica' ? 'selected' : '' }}>Evaporimétrica - Mede evaporação</option>
                            <option value="meteorologica" {{ old('tipo', $estacao->tipo) == 'meteorologica' ? 'selected' : '' }}>Meteorológica - Dados climáticos</option>
                            <option value="climatologica" {{ old('tipo', $estacao->tipo) == 'climatologica' ? 'selected' : '' }}>Climatológica - Dados de clima</option>
                        </select>
                        @error('tipo')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="bacia_hidrografica_id" class="block text-sm font-medium text-gray-700 mb-2">Bacia Hidrográfica</label>
                        <select id="bacia_hidrografica_id" name="bacia_hidrografica_id" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                            <option value="">Selecione a bacia</option>
                            @foreach($bacias as $bacia)
                                <option value="{{ $bacia->id }}" {{ old('bacia_hidrografica_id', $estacao->bacia_hidrografica_id) == $bacia->id ? 'selected' : '' }}>
                                    {{ $bacia->nome }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <!-- Localização -->
            <div>
                <h3 class="text-lg font-medium text-gray-900 mb-4">Localização</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label for="provincia" class="block text-sm font-medium text-gray-700 mb-2">Província</label>
                        <input type="text" id="provincia" name="provincia" value="{{ old('provincia', $estacao->provincia) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label for="distrito" class="block text-sm font-medium text-gray-700 mb-2">Distrito</label>
                        <input type="text" id="distrito" name="distrito" value="{{ old('distrito', $estacao->distrito) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label for="rio" class="block text-sm font-medium text-gray-700 mb-2">Rio</label>
                        <input type="text" id="rio" name="rio" value="{{ old('rio', $estacao->rio) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label for="latitude" class="block text-sm font-medium text-gray-700 mb-2">Latitude</label>
                        <input type="number" id="latitude" name="latitude" value="{{ old('latitude', $estacao->latitude) }}" step="0.00000001"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label for="longitude" class="block text-sm font-medium text-gray-700 mb-2">Longitude</label>
                        <input type="number" id="longitude" name="longitude" value="{{ old('longitude', $estacao->longitude) }}" step="0.00000001"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label for="altitude" class="block text-sm font-medium text-gray-700 mb-2">Altitude (m)</label>
                        <input type="number" id="altitude" name="altitude" value="{{ old('altitude', $estacao->altitude) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    </div>
                </div>
            </div>

            <!-- Configuração Operacional -->
            <div>
                <h3 class="text-lg font-medium text-gray-900 mb-4">Configuração Operacional</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="data_instalacao" class="block text-sm font-medium text-gray-700 mb-2">Data de Instalação</label>
                        <input type="date" id="data_instalacao" name="data_instalacao" value="{{ old('data_instalacao', $estacao->data_instalacao) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label for="equipamento" class="block text-sm font-medium text-gray-700 mb-2">Equipamento</label>
                        <input type="text" id="equipamento" name="equipamento" value="{{ old('equipamento', $estacao->equipamento) }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label for="frequencia_leitura" class="block text-sm font-medium text-gray-700 mb-2">Frequência de Leitura *</label>
                        <select id="frequencia_leitura" name="frequencia_leitura" required class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                            <option value="">Selecione a frequência</option>
                            <option value="horaria" {{ old('frequencia_leitura', $estacao->frequencia_leitura) == 'horaria' ? 'selected' : '' }}>Horária</option>
                            <option value="6_horas" {{ old('frequencia_leitura', $estacao->frequencia_leitura) == '6_horas' ? 'selected' : '' }}>6 em 6 horas</option>
                            <option value="12_horas" {{ old('frequencia_leitura', $estacao->frequencia_leitura) == '12_horas' ? 'selected' : '' }}>12 em 12 horas</option>
                            <option value="diaria" {{ old('frequencia_leitura', $estacao->frequencia_leitura) == 'diaria' ? 'selected' : '' }}>Diária</option>
                        </select>
                        @error('frequencia_leitura')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="estado" class="block text-sm font-medium text-gray-700 mb-2">Estado *</label>
                        <select id="estado" name="estado" required class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                            <option value="activa" {{ old('estado', $estacao->estado) == 'activa' ? 'selected' : '' }}>Ativa</option>
                            <option value="inactiva" {{ old('estado', $estacao->estado) == 'inactiva' ? 'selected' : '' }}>Inativa</option>
                            <option value="manutencao" {{ old('estado', $estacao->estado) == 'manutencao' ? 'selected' : '' }}>Manutenção</option>
                        </select>
                        @error('estado')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="nivel_alerta" class="block text-sm font-medium text-gray-700 mb-2">Nível de Alerta (m)</label>
                        <input type="number" id="nivel_alerta" name="nivel_alerta" value="{{ old('nivel_alerta', $estacao->nivel_alerta) }}" step="0.01"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    </div>
                </div>
            </div>

            <!-- Configuração de Cotas -->
            <div id="configuracao-cotas" class="border-t pt-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-medium text-gray-900">Configuração de Cotas</h3>
                    <div class="flex items-center">
                        <input type="checkbox" id="trabalha_com_cotas" name="trabalha_com_cotas" value="1"
                               {{ old('trabalha_com_cotas', $estacao->trabalha_com_cotas) ? 'checked' : '' }}
                               class="h-4 w-4 text-green-600 rounded border-gray-300 focus:ring-green-500">
                        <label for="trabalha_com_cotas" class="ml-2 text-sm text-gray-700">Esta estação trabalha com cotas</label>
                    </div>
                </div>

                <div id="campos-cotas" class="space-y-6" style="display: none;">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="tipo_entrada_cotas" class="block text-sm font-medium text-gray-700 mb-2">Tipo de Entrada</label>
                            <select id="tipo_entrada_cotas" name="tipo_entrada_cotas" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                                <option value="automatica" {{ old('tipo_entrada_cotas', $estacao->tipo_entrada_cotas) == 'automatica' ? 'selected' : '' }}>Automática (calcula a partir dos níveis)</option>
                                <option value="manual" {{ old('tipo_entrada_cotas', $estacao->tipo_entrada_cotas) == 'manual' ? 'selected' : '' }}>Manual (inserção direta de cotas)</option>
                            </select>
                            <p class="text-xs text-gray-500 mt-1">Para estações sem escala, use entrada manual</p>
                        </div>

                        <div>
                            <label for="cota_alerta" class="block text-sm font-medium text-gray-700 mb-2">Cota de Alerta (m)</label>
                            <input type="number" id="cota_alerta" name="cota_alerta" value="{{ old('cota_alerta', $estacao->cota_alerta) }}" step="0.001"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                        </div>
                    </div>

                    <div id="configuracao-formula" class="bg-gray-50 p-4 rounded-lg">
                        <h4 class="text-md font-medium text-gray-800 mb-3">Configuração da Fórmula</h4>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                            <div>
                                <label for="formula_cota_tipo" class="block text-sm font-medium text-gray-700 mb-2">Tipo de Fórmula</label>
                                <select id="formula_cota_tipo" name="formula_cota_tipo" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                                    <option value="simples" {{ old('formula_cota_tipo', $estacao->formula_cota_tipo) == 'simples' ? 'selected' : '' }}>Simples: Cota = Nível + Referência</option>
                                    <option value="linear" {{ old('formula_cota_tipo', $estacao->formula_cota_tipo) == 'linear' ? 'selected' : '' }}>Linear: Cota = (a × Nível) + b</option>
                                    <option value="completa" {{ old('formula_cota_tipo', $estacao->formula_cota_tipo) == 'completa' ? 'selected' : '' }}>Completa: Cota = (a × Nível²) + (b × Nível) + c</option>
                                    <option value="personalizada" {{ old('formula_cota_tipo', $estacao->formula_cota_tipo) == 'personalizada' ? 'selected' : '' }}>Personalizada</option>
                                </select>
                            </div>

                            <div>
                                <label for="cota_referencia" class="block text-sm font-medium text-gray-700 mb-2">Cota de Referência (m)</label>
                                <input type="number" id="cota_referencia" name="cota_referencia" value="{{ old('cota_referencia', $estacao->cota_referencia) }}" step="0.001"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                                <p class="text-xs text-gray-500 mt-1">Usada na fórmula simples</p>
                            </div>
                        </div>

                        <div id="parametros-formula" class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label for="formula_cota_a" class="block text-sm font-medium text-gray-700 mb-2">Parâmetro A</label>
                                <input type="number" id="formula_cota_a" name="formula_cota_a" value="{{ old('formula_cota_a', $estacao->formula_cota_a ?? 1.0) }}" step="0.000001"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                            </div>

                            <div>
                                <label for="formula_cota_b" class="block text-sm font-medium text-gray-700 mb-2">Parâmetro B</label>
                                <input type="number" id="formula_cota_b" name="formula_cota_b" value="{{ old('formula_cota_b', $estacao->formula_cota_b ?? 0.0) }}" step="0.000001"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                            </div>

                            <div>
                                <label for="formula_cota_c" class="block text-sm font-medium text-gray-700 mb-2">Parâmetro C</label>
                                <input type="number" id="formula_cota_c" name="formula_cota_c" value="{{ old('formula_cota_c', $estacao->formula_cota_c ?? 0.0) }}" step="0.001"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                            </div>
                        </div>

                        <div id="formula-personalizada" class="mt-4" style="display: none;">
                            <label for="formula_personalizada" class="block text-sm font-medium text-gray-700 mb-2">Fórmula Personalizada</label>
                            <input type="text" id="formula_personalizada" name="formula_personalizada" value="{{ old('formula_personalizada', $estacao->formula_personalizada) }}"
                                   placeholder="Ex: N * 0.95 + A + B"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                            <p class="text-xs text-gray-500 mt-1">Use N para nível, A, B, C para parâmetros. Ex: N * 0.95 + A</p>
                        </div>

                        <div class="mt-4 p-3 bg-blue-50 rounded border-l-4 border-blue-400">
                            <p class="text-sm text-blue-700">
                                <strong>Visualização da Fórmula:</strong>
                                <span id="preview-formula" class="font-mono">Cota = Nível + Referência</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Observações -->
            <div>
                <label for="observacoes" class="block text-sm font-medium text-gray-700 mb-2">Observações</label>
                <textarea id="observacoes" name="observacoes" rows="3"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">{{ old('observacoes', $estacao->observacoes) }}</textarea>
            </div>

            <!-- Submit Button -->
            <div class="flex justify-end space-x-4 pt-6 border-t border-gray-200">
                <a href="{{ route('estacoes.show', $estacao) }}" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 rounded-lg">
                    Cancelar
                </a>
                <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg">
                    <i class="fas fa-save mr-2"></i>
                    Atualizar Estação
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const trabalhaComCotas = document.getElementById('trabalha_com_cotas');
    const camposCotas = document.getElementById('campos-cotas');
    const tipoEntradaCotas = document.getElementById('tipo_entrada_cotas');
    const configuracaoFormula = document.getElementById('configuracao-formula');
    const formulaTipo = document.getElementById('formula_cota_tipo');
    const formulaPersonalizada = document.getElementById('formula-personalizada');
    const previewFormula = document.getElementById('preview-formula');

    // Mostrar/ocultar campos de cotas
    trabalhaComCotas.addEventListener('change', function() {
        camposCotas.style.display = this.checked ? 'block' : 'none';
        configuracaoFormula.style.display = (this.checked && tipoEntradaCotas.value === 'automatica') ? 'block' : 'none';
    });

    // Mostrar/ocultar configuração de fórmula baseado no tipo de entrada
    tipoEntradaCotas.addEventListener('change', function() {
        configuracaoFormula.style.display = (this.value === 'automatica' && trabalhaComCotas.checked) ? 'block' : 'none';
    });

    // Mostrar/ocultar campo de fórmula personalizada
    formulaTipo.addEventListener('change', function() {
        formulaPersonalizada.style.display = this.value === 'personalizada' ? 'block' : 'none';
        atualizarPreviewFormula();
    });

    // Atualizar preview da fórmula
    function atualizarPreviewFormula() {
        const tipo = formulaTipo.value;
        let preview = '';

        switch(tipo) {
            case 'simples':
                preview = 'Cota = Nível + Referência';
                break;
            case 'linear':
                preview = 'Cota = (A × Nível) + B';
                break;
            case 'completa':
                preview = 'Cota = (A × Nível²) + (B × Nível) + C';
                break;
            case 'personalizada':
                preview = 'Fórmula personalizada definida abaixo';
                break;
            default:
                preview = 'Selecione o tipo de fórmula';
        }

        previewFormula.textContent = preview;
    }

    // Event listeners para atualizar preview
    ['formula_cota_a', 'formula_cota_b', 'formula_cota_c'].forEach(id => {
        const elem = document.getElementById(id);
        if (elem) {
            elem.addEventListener('input', atualizarPreviewFormula);
        }
    });

    // Inicializar estado dos campos
    camposCotas.style.display = trabalhaComCotas.checked ? 'block' : 'none';
    configuracaoFormula.style.display = (trabalhaComCotas.checked && tipoEntradaCotas.value === 'automatica') ? 'block' : 'none';
    formulaPersonalizada.style.display = formulaTipo.value === 'personalizada' ? 'block' : 'none';
    atualizarPreviewFormula();
});
</script>
@endsection