@extends('layouts.app')

@section('title', 'Fórmulas de Caudal - ' . $estacao->nome)

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-calculator mr-3 text-blue-600"></i>
                    Fórmulas de Caudal - {{ $estacao->nome }}
                </h1>
                <p class="text-gray-600 mt-2">Gerencie as fórmulas para calcular caudal: Q = A × (H - C)^B</p>
            </div>
            <div class="flex space-x-3">
                <button onclick="showNovaFormulaModal()" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg">
                    <i class="fas fa-plus mr-2"></i>
                    Nova Fórmula
                </button>
                <a href="{{ route('estacoes.show', $estacao) }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar
                </a>
            </div>
        </div>
    </div>

    <!-- Explicação Simples -->
    <div class="bg-blue-50 rounded-lg p-4">
        <div class="flex items-start">
            <i class="fas fa-info-circle text-blue-600 mt-1 mr-3"></i>
            <div>
                <h3 class="font-medium text-blue-900">Como Funciona</h3>
                <p class="text-sm text-blue-800 mt-1">
                    A fórmula <strong>Q = A × (H - C)^B</strong> calcula o caudal (Q) baseado no nível da água (H).
                    <br>• <strong>A</strong> = Coeficiente de escala
                    <br>• <strong>B</strong> = Expoente (geralmente entre 1 e 3)
                    <br>• <strong>C</strong> = Altura de referência (offset)
                </p>
            </div>
        </div>
    </div>

    <!-- Fórmula Ativa Atual -->
    @if($formulaAtiva)
    <div class="bg-green-50 rounded-lg p-4">
        <div class="flex items-center justify-between">
            <div>
                <h3 class="font-medium text-green-900">Fórmula Ativa Atual</h3>
                <p class="text-lg font-mono text-green-800 mt-1">{{ $formulaAtiva->getFormulaTexto() }}</p>
                <p class="text-sm text-green-700 mt-1">{{ $formulaAtiva->nome }} - Válida desde {{ $formulaAtiva->data_inicio->format('d/m/Y') }}</p>
            </div>
            <div class="text-right">
                @php $qualidade = $formulaAtiva->getQualidadeAjuste(); @endphp
                <span class="px-3 py-1 rounded-full text-sm" style="background-color: {{ $qualidade['cor'] }}20; color: {{ $qualidade['cor'] }}">
                    {{ $qualidade['texto'] }}
                </span>
            </div>
        </div>
    </div>
    @else
    <div class="bg-yellow-50 rounded-lg p-4">
        <div class="flex items-center">
            <i class="fas fa-exclamation-triangle text-yellow-600 mr-3"></i>
            <div>
                <h3 class="font-medium text-yellow-900">Nenhuma Fórmula Ativa</h3>
                <p class="text-sm text-yellow-800 mt-1">Esta estação não possui fórmula de caudal configurada.</p>
            </div>
        </div>
    </div>
    @endif

    <!-- Lista de Fórmulas -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
            <h3 class="text-lg font-medium text-gray-900">Histórico de Fórmulas</h3>
        </div>

        @if($formulas->count() > 0)
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Nome</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Fórmula</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Período</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Qualidade</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Ações</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($formulas as $formula)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900">{{ $formula->nome }}</div>
                            <div class="text-xs text-gray-500">{{ Str::limit($formula->descricao, 50) }}</div>
                        </td>
                        <td class="px-6 py-4">
                            <code class="text-sm bg-gray-100 px-2 py-1 rounded">{{ $formula->getFormulaTexto() }}</code>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-900">
                            {{ $formula->data_inicio->format('d/m/Y') }}
                            @if($formula->data_fim)
                                até {{ $formula->data_fim->format('d/m/Y') }}
                            @else
                                <span class="text-blue-600">(indefinido)</span>
                            @endif
                        </td>
                        <td class="px-6 py-4">
                            @php $qualidade = $formula->getQualidadeAjuste(); @endphp
                            <span class="px-2 py-1 rounded-full text-xs" style="background-color: {{ $qualidade['cor'] }}20; color: {{ $qualidade['cor'] }}">
                                {{ $qualidade['texto'] }}
                            </span>
                        </td>
                        <td class="px-6 py-4">
                            @php $status = $formula->getStatus(); @endphp
                            <span class="px-2 py-1 rounded-full text-xs" style="background-color: {{ $status['cor'] }}20; color: {{ $status['cor'] }}">
                                {{ $status['texto'] }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-center">
                            <div class="flex justify-center space-x-2">
                                <button onclick="editarFormula({{ $formula->id }})" class="text-blue-600 hover:text-blue-900">
                                    <i class="fas fa-edit"></i>
                                </button>
                                @if($formula->ativa)
                                <button onclick="desativarFormula({{ $formula->id }})" class="text-red-600 hover:text-red-900">
                                    <i class="fas fa-power-off"></i>
                                </button>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="text-center py-12">
            <i class="fas fa-calculator text-4xl text-gray-400 mb-4"></i>
            <h3 class="text-lg font-medium text-gray-900 mb-2">Nenhuma fórmula cadastrada</h3>
            <p class="text-gray-500 mb-6">Crie a primeira fórmula para calcular caudal desta estação.</p>
            <button onclick="showNovaFormulaModal()" class="bg-green-600 hover:bg-green-700 text-white px-6 py-3 rounded-lg">
                <i class="fas fa-plus mr-2"></i>
                Criar Primeira Fórmula
            </button>
        </div>
        @endif
    </div>
</div>

<!-- Modal Nova Fórmula -->
<div id="novaFormulaModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-2xl">
            <form method="POST" action="{{ route('estacoes.formulas-caudal.store', $estacao) }}">
                @csrf

                <div class="bg-gradient-to-r from-green-600 to-green-700 px-6 py-4 text-white rounded-t-xl">
                    <div class="flex justify-between items-center">
                        <h3 class="text-xl font-bold">Nova Fórmula de Caudal</h3>
                        <button type="button" onclick="hideNovaFormulaModal()" class="text-white hover:text-gray-200">
                            <i class="fas fa-times text-xl"></i>
                        </button>
                    </div>
                </div>

                <div class="p-6 space-y-6">
                    <!-- Nome e Descrição -->
                    <div class="grid grid-cols-1 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Nome da Fórmula *</label>
                            <input type="text" name="nome" required placeholder="Ex: Fórmula pós-cheia 2024"
                                   class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500">
                            <p class="text-xs text-gray-500 mt-1">Nome descritivo para identificar esta fórmula</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Motivo da Mudança</label>
                            <textarea name="motivo_mudanca" rows="2" placeholder="Ex: Cheia de janeiro alterou o leito do rio"
                                      class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500"></textarea>
                        </div>
                    </div>

                    <!-- Coeficientes da Fórmula -->
                    <div class="bg-blue-50 rounded-lg p-4">
                        <h4 class="font-medium text-blue-900 mb-4">Coeficientes da Fórmula: Q = A × (H - C)^B</h4>
                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Coeficiente A *</label>
                                <input type="number" name="coeficiente_a" step="0.000001" required placeholder="Ex: 2.5"
                                       class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500">
                                <p class="text-xs text-gray-500 mt-1">Fator de escala</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Expoente B *</label>
                                <input type="number" name="coeficiente_b" step="0.000001" required placeholder="Ex: 1.5"
                                       class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500">
                                <p class="text-xs text-gray-500 mt-1">Geralmente 1-3</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Offset C</label>
                                <input type="number" name="coeficiente_c" step="0.000001" placeholder="Ex: 0.5"
                                       class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500">
                                <p class="text-xs text-gray-500 mt-1">Altura de referência</p>
                            </div>
                        </div>
                    </div>

                    <!-- Período de Validade -->
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Válida a partir de *</label>
                            <input type="date" name="data_inicio" required value="{{ date('Y-m-d') }}"
                                   class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Válida até</label>
                            <input type="date" name="data_fim"
                                   class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500">
                            <p class="text-xs text-gray-500 mt-1">Deixe vazio para indefinido</p>
                        </div>
                    </div>

                    <!-- Faixa de Níveis -->
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Nível Mínimo (m)</label>
                            <input type="number" name="nivel_min" step="0.001" placeholder="Ex: 0.5"
                                   class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Nível Máximo (m)</label>
                            <input type="number" name="nivel_max" step="0.001" placeholder="Ex: 10.0"
                                   class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500">
                        </div>
                    </div>

                    <!-- Qualidade do Ajuste -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">R² (Qualidade do Ajuste)</label>
                        <input type="number" name="r_quadrado" step="0.0001" min="0" max="1" placeholder="Ex: 0.95"
                               class="w-full border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500">
                        <p class="text-xs text-gray-500 mt-1">Valor entre 0 e 1. Quanto mais próximo de 1, melhor o ajuste</p>
                    </div>
                </div>

                <div class="bg-gray-50 px-6 py-4 border-t flex justify-end space-x-3 rounded-b-xl">
                    <button type="button" onclick="hideNovaFormulaModal()" class="bg-gray-300 hover:bg-gray-400 text-gray-700 px-6 py-2 rounded-lg">
                        Cancelar
                    </button>
                    <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg">
                        <i class="fas fa-save mr-2"></i>
                        Salvar Fórmula
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showNovaFormulaModal() {
    document.getElementById('novaFormulaModal').classList.remove('hidden');
}

function hideNovaFormulaModal() {
    document.getElementById('novaFormulaModal').classList.add('hidden');
}

function editarFormula(id) {
    // TODO: Implementar modal de edição
    alert('Funcionalidade de edição em desenvolvimento');
}

function desativarFormula(id) {
    if (confirm('Tem certeza que deseja desativar esta fórmula?')) {
        // TODO: Implementar desativação
        alert('Funcionalidade em desenvolvimento');
    }
}

// Fechar modal ao clicar fora
document.getElementById('novaFormulaModal')?.addEventListener('click', function(e) {
    if (e.target === this) {
        hideNovaFormulaModal();
    }
});
</script>
@endsection