@extends('layouts.app')

@section('title', 'Configurações de Notificação')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-bell mr-3 text-blue-600"></i>
                    Configurações de Notificação
                </h1>
                <p class="text-gray-600 mt-2">Configure como e quando receber notificações de alertas</p>
            </div>
            <div class="flex items-center space-x-2">
                @if($user->temTelefoneValido())
                    <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                    <span class="text-sm text-green-600">SMS configurado</span>
                @else
                    <div class="w-3 h-3 bg-yellow-500 rounded-full"></div>
                    <span class="text-sm text-yellow-600">Configure o telefone</span>
                @endif
            </div>
        </div>
    </div>

    <!-- Estatísticas do Usuário -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Notificações (30 dias)</p>
                    <p class="text-3xl font-bold text-blue-600">{{ $userStats['total'] }}</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-bell text-2xl text-blue-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">SMS Enviados</p>
                    <p class="text-3xl font-bold text-green-600">{{ $userStats['sms'] }}</p>
                </div>
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-sms text-2xl text-green-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Emails Enviados</p>
                    <p class="text-3xl font-bold text-purple-600">{{ $userStats['email'] }}</p>
                </div>
                <div class="bg-purple-100 p-3 rounded-lg">
                    <i class="fas fa-envelope text-2xl text-purple-600"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 mb-2">Taxa de Entrega</p>
                    @php
                        $taxaEntrega = $userStats['total'] > 0 ? round(($userStats['entregues'] / $userStats['total']) * 100, 1) : 0;
                    @endphp
                    <p class="text-3xl font-bold text-{{ $taxaEntrega >= 90 ? 'green' : ($taxaEntrega >= 70 ? 'yellow' : 'red') }}-600">{{ $taxaEntrega }}%</p>
                </div>
                <div class="bg-{{ $taxaEntrega >= 90 ? 'green' : ($taxaEntrega >= 70 ? 'yellow' : 'red') }}-100 p-3 rounded-lg">
                    <i class="fas fa-chart-line text-2xl text-{{ $taxaEntrega >= 90 ? 'green' : ($taxaEntrega >= 70 ? 'yellow' : 'red') }}-600"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Formulário de Configuração -->
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">
                <i class="fas fa-cog mr-2 text-gray-600"></i>
                Preferências de Notificação
            </h3>
        </div>
        
        <form method="POST" action="{{ route('notifications.update') }}" class="p-6">
            @csrf
            @method('PUT')

            <div class="space-y-8">
                <!-- Configurações de Contato -->
                <div class="border-l-4 border-blue-500 pl-6">
                    <h4 class="text-lg font-semibold text-gray-900 mb-4">
                        <i class="fas fa-address-book mr-2 text-blue-600"></i>
                        Informações de Contato
                    </h4>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Número de Telefone
                                <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="telefone" value="{{ old('telefone', $user->telefone) }}" 
                                   placeholder="+258XXXXXXXXX ou 8XXXXXXXX"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 @error('telefone') border-red-500 @enderror">
                            @error('telefone')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                            <p class="text-xs text-gray-500 mt-1">
                                Formato: +258XXXXXXXXX (internacional) ou 8XXXXXXXX (nacional)
                            </p>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                            <input type="email" value="{{ $user->email }}" disabled
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md bg-gray-50 text-gray-500">
                            <p class="text-xs text-gray-500 mt-1">
                                Email não pode ser alterado aqui. Use o perfil do usuário.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Tipos de Notificação -->
                <div class="border-l-4 border-green-500 pl-6">
                    <h4 class="text-lg font-semibold text-gray-900 mb-4">
                        <i class="fas fa-toggle-on mr-2 text-green-600"></i>
                        Tipos de Notificação
                    </h4>
                    
                    <div class="space-y-4">
                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                            <div>
                                <label class="text-sm font-medium text-gray-900">Notificações por SMS</label>
                                <p class="text-xs text-gray-500">Receber alertas via mensagem de texto</p>
                            </div>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="notificacao_sms" value="1" 
                                       {{ old('notificacao_sms', $user->notificacao_sms) ? 'checked' : '' }}
                                       class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                            </label>
                        </div>

                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                            <div>
                                <label class="text-sm font-medium text-gray-900">Notificações por Email</label>
                                <p class="text-xs text-gray-500">Receber alertas via email</p>
                            </div>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="notificacao_email" value="1" 
                                       {{ old('notificacao_email', $user->notificacao_email) ? 'checked' : '' }}
                                       class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                            </label>
                        </div>

                        <div class="flex items-center justify-between p-4 bg-red-50 rounded-lg border border-red-200">
                            <div>
                                <label class="text-sm font-medium text-red-900">Alertas de Emergência</label>
                                <p class="text-xs text-red-600">Sempre receber notificações de emergência (recomendado)</p>
                            </div>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="notificacao_emergencia" value="1" 
                                       {{ old('notificacao_emergencia', $user->notificacao_emergencia) ? 'checked' : '' }}
                                       class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-red-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-red-600"></div>
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Níveis de Alerta -->
                <div class="border-l-4 border-yellow-500 pl-6">
                    <h4 class="text-lg font-semibold text-gray-900 mb-4">
                        <i class="fas fa-layer-group mr-2 text-yellow-600"></i>
                        Níveis de Alerta
                    </h4>
                    <p class="text-sm text-gray-600 mb-4">Selecione quais níveis de alerta deseja receber:</p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @php
                            $niveis = [
                                'informacao' => ['label' => 'Informação', 'color' => 'blue', 'icon' => 'info-circle'],
                                'atencao' => ['label' => 'Atenção', 'color' => 'yellow', 'icon' => 'exclamation-circle'],
                                'alerta' => ['label' => 'Alerta', 'color' => 'orange', 'icon' => 'exclamation-triangle'],
                                'emergencia' => ['label' => 'Emergência', 'color' => 'red', 'icon' => 'skull-crossbones']
                            ];
                            $niveisUsuario = old('niveis_notificacao', $user->niveis_notificacao ?? ['alerta', 'emergencia']);
                        @endphp
                        
                        @foreach($niveis as $nivel => $config)
                            <label class="flex items-center p-3 border border-{{ $config['color'] }}-200 bg-{{ $config['color'] }}-50 rounded-lg cursor-pointer hover:bg-{{ $config['color'] }}-100 transition-colors">
                                <input type="checkbox" name="niveis_notificacao[]" value="{{ $nivel }}" 
                                       {{ in_array($nivel, $niveisUsuario) ? 'checked' : '' }}
                                       class="mr-3 text-{{ $config['color'] }}-600 focus:ring-{{ $config['color'] }}-500">
                                <i class="fas fa-{{ $config['icon'] }} mr-2 text-{{ $config['color'] }}-600"></i>
                                <span class="text-sm font-medium text-{{ $config['color'] }}-800">{{ $config['label'] }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>

                <!-- Relatórios -->
                <div class="border-l-4 border-purple-500 pl-6">
                    <h4 class="text-lg font-semibold text-gray-900 mb-4">
                        <i class="fas fa-chart-bar mr-2 text-purple-600"></i>
                        Relatórios Automáticos
                    </h4>
                    
                    <div class="space-y-4">
                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                            <div>
                                <label class="text-sm font-medium text-gray-900">Relatório Diário</label>
                                <p class="text-xs text-gray-500">Receber resumo diário de alertas por SMS</p>
                            </div>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" name="receber_relatorio_diario" value="1" 
                                       {{ old('receber_relatorio_diario', $user->receber_relatorio_diario) ? 'checked' : '' }}
                                       class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-purple-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-purple-600"></div>
                            </label>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">
                                Horário do Relatório
                            </label>
                            <input type="time" name="horario_relatorio" 
                                   value="{{ old('horario_relatorio', $user->horario_relatorio ? $user->horario_relatorio->format('H:i') : '08:00') }}"
                                   class="w-40 px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-purple-500">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Botões de Ação -->
            <div class="flex items-center justify-between pt-8 border-t border-gray-200 mt-8">
                <div class="flex space-x-3">
                    @if($user->temTelefoneValido())
                        <form method="POST" action="{{ route('notifications.test-sms') }}" style="display: inline;">
                            @csrf
                            <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors">
                                <i class="fas fa-paper-plane mr-2"></i>
                                Testar SMS
                            </button>
                        </form>
                    @endif
                    
                    <a href="{{ route('notifications.historico') }}" class="bg-gray-600 px-4 py-2 rounded-md hover:bg-gray-700 transition-colors">
                        <i class="fas fa-history mr-2"></i>
                        Ver Histórico
                    </a>
                </div>

                <div class="flex space-x-3">
                    <button type="button" onclick="window.location.reload()" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-md hover:bg-gray-400 transition-colors">
                        Cancelar
                    </button>
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors">
                        <i class="fas fa-save mr-2"></i>
                        Salvar Configurações
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection