@extends('layouts.app')

@section('title', 'Configurações do Sistema')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-cogs mr-3 text-blue-600"></i>
                    Configurações do Sistema
                </h1>
                <p class="text-gray-600 mt-2">Gerencie as informações da organização e configurações gerais</p>
            </div>
        </div>
    </div>

    <!-- Messages -->
    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
            {{ session('error') }}
        </div>
    @endif

    @if($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
            <ul class="list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Settings Form -->
    <form method="POST" action="{{ route('settings.update') }}" class="space-y-6">
        @csrf
        @method('PUT')

        @foreach($settings_by_category as $category_key => $category_data)
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-xl font-semibold text-gray-800 mb-6 border-b border-gray-200 pb-3">
                @if($category_key === 'general')
                    <i class="fas fa-sliders-h mr-2 text-blue-600"></i>
                @elseif($category_key === 'organization')
                    <i class="fas fa-building mr-2 text-green-600"></i>
                @elseif($category_key === 'contact')
                    <i class="fas fa-address-book mr-2 text-purple-600"></i>
                @elseif($category_key === 'bulletin')
                    <i class="fas fa-file-alt mr-2 text-orange-600"></i>
                @endif
                {{ $category_data['label'] }}
            </h2>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                @foreach($category_data['settings'] as $setting)
                <div>
                    <label for="setting_{{ $setting->key }}" class="block text-sm font-medium text-gray-700 mb-2">
                        {{ $setting->label }}
                        @if($setting->description)
                            <span class="text-xs text-gray-500 block font-normal">{{ $setting->description }}</span>
                        @endif
                    </label>

                    @if($setting->type === 'textarea')
                        <textarea
                            id="setting_{{ $setting->key }}"
                            name="settings[{{ $setting->key }}]"
                            rows="3"
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="{{ $setting->label }}"
                        >{{ old("settings.{$setting->key}", $setting->value) }}</textarea>
                    @elseif($setting->type === 'email')
                        <input
                            type="email"
                            id="setting_{{ $setting->key }}"
                            name="settings[{{ $setting->key }}]"
                            value="{{ old("settings.{$setting->key}", $setting->value) }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="{{ $setting->label }}"
                        >
                    @elseif($setting->type === 'phone')
                        <input
                            type="tel"
                            id="setting_{{ $setting->key }}"
                            name="settings[{{ $setting->key }}]"
                            value="{{ old("settings.{$setting->key}", $setting->value) }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="{{ $setting->label }}"
                        >
                    @elseif($setting->type === 'url')
                        <input
                            type="url"
                            id="setting_{{ $setting->key }}"
                            name="settings[{{ $setting->key }}]"
                            value="{{ old("settings.{$setting->key}", $setting->value) }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="{{ $setting->label }}"
                        >
                    @elseif($setting->type === 'number')
                        <input
                            type="number"
                            id="setting_{{ $setting->key }}"
                            name="settings[{{ $setting->key }}]"
                            value="{{ old("settings.{$setting->key}", $setting->value) }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="{{ $setting->label }}"
                        >
                    @else
                        <input
                            type="text"
                            id="setting_{{ $setting->key }}"
                            name="settings[{{ $setting->key }}]"
                            value="{{ old("settings.{$setting->key}", $setting->value) }}"
                            class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                            placeholder="{{ $setting->label }}"
                        >
                    @endif
                </div>
                @endforeach
            </div>
        </div>
        @endforeach

        <!-- Save Button -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex justify-end">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg font-medium">
                    <i class="fas fa-save mr-2"></i>
                    Salvar Configurações
                </button>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-resize textareas
    const textareas = document.querySelectorAll('textarea');
    textareas.forEach(textarea => {
        textarea.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = this.scrollHeight + 'px';
        });
    });
});
</script>
@endpush
@endsection