# Log de Alterações Diárias

## 25 de Setembro de 2025

### 📊 Implementação Sistema de Cotas para Estações Hidrométricas

#### **Problema Identificado:**
- Sistema trabalhava apenas com níveis hidroméricos
- Faltava suporte para cotas (referência absoluta)
- Barragens privadas não têm escala, só fornecem cotas diretamente
- Necessidade de fórmulas customizáveis para conversão nível → cota

#### **Solução Implementada:**

##### **1. Modelo Estacao.php - Novos Campos:**
```php
// Campos adicionados no $fillable:
'cota_alerta',              // Nível de alerta baseado em cota
'trabalha_com_cotas',       // Boolean - define se estação usa cotas
'tipo_entrada_cotas',       // 'automatica' ou 'manual'
'cota_referencia',          // Cota de referência para fórmulas
'formula_cota_tipo',        // Tipo: simples, linear, completa, personalizada
'formula_cota_a',           // Parâmetro A da fórmula
'formula_cota_b',           // Parâmetro B da fórmula
'formula_cota_c',           // Parâmetro C da fórmula
'formula_personalizada',    // Fórmula matemática customizada
'seba_station_id',          // ID para integração SEBA
'ativa',                    // Status da estação

// Novos casts:
'cota_alerta' => 'decimal:2',
'trabalha_com_cotas' => 'boolean',
'cota_referencia' => 'decimal:3',
'formula_cota_a' => 'decimal:6',
'formula_cota_b' => 'decimal:6',
'formula_cota_c' => 'decimal:3',
'ativa' => 'boolean',
```

##### **2. Modelo Estacao.php - Novos Métodos:**
- `trabalhaComCotas()` - Verifica se estação usa cotas
- `calculaCotasAutomaticamente()` - Se calcula cotas automaticamente
- `recebeCotasManualmente()` - Se recebe cotas por inserção manual
- `calcularCotaDeNivel($nivel)` - Converte nível em cota usando fórmulas:
  - **Simples**: `Cota = Nível + Referência`
  - **Linear**: `Cota = (a × Nível) + b`
  - **Completa**: `Cota = (a × Nível²) + (b × Nível) + c`
  - **Personalizada**: Avalia fórmula matemática customizada
- `getStatusCota($cota)` - Status de alerta baseado em cota

##### **3. Modelo LeituraEstacao.php - Novos Campos:**
```php
// Campos adicionados no $fillable:
'cota_6h',                  // Cota às 6h
'cota_12h',                 // Cota às 12h
'cota_18h',                 // Cota às 18h
'cota_hidrometrica',        // Cota média calculada
'origem',                   // Origem dos dados
'importado_automaticamente', // Se foi importação automática
'hora_leitura',             // Hora da leitura (para SEBA)
'precipitacao',             // Precipitação (compatibilidade SEBA)
'temperatura',              // Temperatura (compatibilidade SEBA)

// Novos casts:
'cota_6h' => 'decimal:3',
'cota_12h' => 'decimal:3',
'cota_18h' => 'decimal:3',
'cota_hidrometrica' => 'decimal:3',
'precipitacao' => 'decimal:2',
'temperatura' => 'decimal:2',
'importado_automaticamente' => 'boolean',
```

##### **4. Modelo LeituraEstacao.php - Novos Métodos:**
- `calcularCotas()` - Calcula cotas a partir dos níveis
- `calcularCotaHidrometrica()` - Calcula cota média
- `getCotasArray()` - Retorna array com cotas por horário
- `temCotas()` - Verifica se tem dados de cotas
- `definirCotasManualmente(array $cotas)` - Define cotas manualmente
- `temDadosCompletos()` - Atualizado para considerar cotas

##### **5. Lógica de Funcionamento:**

**Cenário 1 - Estação Normal (Cálculo Automático):**
1. Operador insere níveis: `2.50m, 2.75m, 3.00m`
2. Sistema aplica fórmula: `Cota = Nível + 1200`
3. Resultado: `1202.50m, 1202.75m, 1203.00m`

**Cenário 2 - Barragem Privada (Entrada Manual):**
1. Operador insere cotas diretamente: `1067.80m`
2. Sistema usa valores sem conversão

**Cenário 3 - Fórmula Personalizada:**
1. Admin configura: `N * 0.95 + A + B`
2. Sistema substitui variáveis e calcula

#### **Compatibilidade:**
- ✅ Sistema existente mantido (retrocompatibilidade)
- ✅ Barragens continuam funcionando normalmente
- ✅ Estações antigas continuam com níveis apenas
- ✅ Novas estações podem usar cotas ou híbrido

#### **Benefícios:**
- 🎯 **Flexibilidade Total**: Qualquer tipo de fórmula configurável
- 🔧 **Customizável**: Admin define parâmetros por estação
- 📊 **Híbrido**: Suporta níveis, cotas ou ambos
- 🏭 **Integração**: Pronto para SEBA (níveis + cotas)
- 🛡️ **Segurança**: Validações e tratamento de erros

#### **Arquivos Modificados:**
- `/app/Models/Estacao.php` - Adicionados campos e métodos para cotas
- `/app/Models/LeituraEstacao.php` - Adicionados campos e lógica de cotas
- `/app/Http/Controllers/EstacaoController.php` - Validação e salvamento de cotas
- `/database/migrations/2025_09_25_000001_add_cotas_fields_to_estacoes_table.php` - Migration campos estações
- `/database/migrations/2025_09_25_000002_add_cotas_fields_to_leituras_estacoes_table.php` - Migration campos leituras
- `/resources/views/estacoes/create.blade.php` - Interface para configuração de cotas
- `/resources/views/estacoes/leituras.blade.php` - Tabela com colunas de cotas
- `/resources/views/components/modal-leitura-simples.blade.php` - Formulário com suporte a cotas

---

### 🎨 Interface de Configuração de Cotas Implementada

#### **Funcionalidades da Interface:**

##### **1. Checkbox "Trabalha com Cotas":**
- Ativa/desativa o sistema de cotas para a estação
- Interface dinâmica - mostra campos apenas quando necessário

##### **2. Configuração de Entrada:**
- **Automática**: Sistema calcula cotas a partir dos níveis usando fórmulas
- **Manual**: Operador insere cotas diretamente (para estações sem escala)

##### **3. Configuração de Fórmulas:**
- **Simples**: `Cota = Nível + Referência`
- **Linear**: `Cota = (A × Nível) + B`
- **Completa**: `Cota = (A × Nível²) + (B × Nível) + C`
- **Personalizada**: Fórmula matemática customizada

##### **4. Recursos Visuais:**
- Preview da fórmula em tempo real
- Campos condicionais (mostram apenas quando relevantes)
- Validação e ajuda contextual
- Interface responsiva

##### **5. JavaScript Dinâmico:**
- Controle inteligente de exibição de campos
- Preview da fórmula baseado na seleção
- Inicialização correta dos estados

---

---

### 📱 Interface de Leituras com Suporte a Cotas Implementada

#### **Funcionalidades da Interface de Leituras:**

##### **1. Formulário Inteligente:**
- **Detecção automática**: Interface adapta-se baseado na configuração da estação
- **Modo Manual**: Para estações sem escala - inserção direta de cotas
- **Modo Automático**: Calcula cotas em tempo real a partir dos níveis inseridos

##### **2. Cálculo em Tempo Real:**
- **JavaScript integrado** para calcular cotas instantaneamente
- **Preview da fórmula** mostra configuração atual da estação
- **Cota média** calculada automaticamente
- **Suporte a todas as fórmulas**: Simples, Linear, Completa, Personalizada

##### **3. Interface Adaptativa:**
- **Checkbox "Mostrar campos de cotas"** para visualizar cálculos
- **Campos readonly** para cotas calculadas automaticamente
- **Validação diferenciada** conforme tipo de entrada
- **Feedback visual** com cores distintas (níveis vs cotas)

##### **4. Tabela de Leituras Expandida:**
- **Colunas de cotas** aparecem automaticamente quando estação trabalha com cotas
- **Formatação específica** para cotas (3 casas decimais)
- **Cores distintas**: Níveis em cinza, cotas em verde
- **Compatibilidade** com leituras antigas (sem cotas)

##### **5. Validação no Backend:**
- **Controller atualizado** para validar campos de cotas
- **Suporte a criação e edição** de leituras com cotas
- **Processamento automático** via modelo LeituraEstacao

#### **Fluxo de Trabalho:**

**Para Estações com Cálculo Automático:**
1. Operador insere níveis (2.50m, 2.75m, 3.00m)
2. JavaScript calcula cotas em tempo real
3. Mostra preview: "Cota média: 1202.75m"
4. Sistema salva níveis + cotas calculadas

**Para Estações com Entrada Manual:**
1. Operador insere cotas diretamente (1067.80m)
2. Sistema salva cotas sem conversão
3. Campos de níveis ficam opcionais

### 📝 Próximas Alterações:
- [✅] Migração do banco de dados para os novos campos
- [✅] Interface de configuração das fórmulas
- [✅] Telas de inserção de leituras com suporte a cotas
- [✅] Validação e salvamento de cotas no backend
- [ ] Atualizar formulário de edição de estações
- [ ] Adaptação do SebaHydrometrieService

---

### 🔍 Para Revisão:
Quando necessário revisar estas alterações, verificar:
1. Modelos: `Estacao.php` e `LeituraEstacao.php`
2. Campos adicionados no `$fillable` e `$casts`
3. Métodos de cálculo de cotas
4. Lógica híbrida níveis/cotas no `calcularValoresAutomaticos()`