<?php

namespace App\Helpers;

class ProvinciaHelper
{
    /**
     * Lista oficial completa das 11 províncias de Moçambique
     * Ordenadas alfabeticamente para melhor usabilidade
     */
    public static function getProvincias()
    {
        return [
            'Cabo Delgado',
            'Gaza',
            'Inhambane',
            'Manica',
            'Maputo Província',
            'Maputo Cidade',
            'Nampula',
            'Niassa',
            'Sofala',
            'Tete',
            'Zambézia'
        ];
    }

    /**
     * Retorna as províncias organizadas por região
     */
    public static function getProvinciasPorRegiao()
    {
        return [
            'Norte' => [
                'Cabo Delgado',
                'Nampula',
                'Niassa'
            ],
            'Centro' => [
                'Manica',
                'Sofala',
                'Tete',
                'Zambézia'
            ],
            'Sul' => [
                'Gaza',
                'Inhambane',
                'Maputo Província',
                'Maputo Cidade'
            ]
        ];
    }

    /**
     * Retorna array para uso em selects HTML
     */
    public static function getProvinciasForSelect()
    {
        $provincias = self::getProvincias();
        return array_combine($provincias, $provincias);
    }

    /**
     * Retorna as províncias da ARA Norte especificamente
     */
    public static function getProvinciasARANorte()
    {
        return [
            'Cabo Delgado',
            'Nampula',
            'Niassa',
            'Zambézia' // Parte norte da Zambézia
        ];
    }

    /**
     * Verifica se uma província existe na lista oficial
     */
    public static function existeProvincia($provincia)
    {
        return in_array($provincia, self::getProvincias());
    }

    /**
     * Retorna informações sobre uma província específica
     */
    public static function getInfoProvincia($provincia)
    {
        $info = [
            'Cabo Delgado' => [
                'capital' => 'Pemba',
                'regiao' => 'Norte',
                'area_km2' => 82625,
                'costa' => true
            ],
            'Gaza' => [
                'capital' => 'Xai-Xai',
                'regiao' => 'Sul',
                'area_km2' => 75709,
                'costa' => true
            ],
            'Inhambane' => [
                'capital' => 'Inhambane',
                'regiao' => 'Sul',
                'area_km2' => 68615,
                'costa' => true
            ],
            'Manica' => [
                'capital' => 'Chimoio',
                'regiao' => 'Centro',
                'area_km2' => 61661,
                'costa' => false
            ],
            'Maputo Província' => [
                'capital' => 'Matola',
                'regiao' => 'Sul',
                'area_km2' => 26058,
                'costa' => true
            ],
            'Maputo Cidade' => [
                'capital' => 'Maputo',
                'regiao' => 'Sul',
                'area_km2' => 347,
                'costa' => true
            ],
            'Nampula' => [
                'capital' => 'Nampula',
                'regiao' => 'Norte',
                'area_km2' => 81606,
                'costa' => true
            ],
            'Niassa' => [
                'capital' => 'Lichinga',
                'regiao' => 'Norte',
                'area_km2' => 122827,
                'costa' => false
            ],
            'Sofala' => [
                'capital' => 'Beira',
                'regiao' => 'Centro',
                'area_km2' => 68018,
                'costa' => true
            ],
            'Tete' => [
                'capital' => 'Tete',
                'regiao' => 'Centro',
                'area_km2' => 100724,
                'costa' => false
            ],
            'Zambézia' => [
                'capital' => 'Quelimane',
                'regiao' => 'Centro',
                'area_km2' => 105008,
                'costa' => true
            ]
        ];

        return $info[$provincia] ?? null;
    }
}