<?php
namespace App\Http\Controllers;

use App\Services\ExcelImportService;
use Illuminate\Http\Request;

class ImportacaoController extends Controller
{
    protected $importService;

    public function __construct(ExcelImportService $importService)
    {
        $this->importService = $importService;
    }

    public function index()
    {
        return view('importacao.index');
    }

    public function importBarragens(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:xls,xlsx|max:10240', // 10MB max
        ]);

        try {
            $result = $this->importService->importBarragens($request->file('file'));
            
            return redirect()->back()
                ->with('success', "Importação concluída! {$result['success']} registros importados com sucesso.")
                ->with('import_result', $result)
                ->with('import_type', 'Barragens');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Erro na importação: ' . $e->getMessage());
        }
    }

    public function importEstacoes(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:xls,xlsx|max:10240',
        ]);

        try {
            $result = $this->importService->importEstacoes($request->file('file'));
            
            return redirect()->back()
                ->with('success', "Importação concluída! {$result['success']} registros importados com sucesso.")
                ->with('import_result', $result)
                ->with('import_type', 'Estações');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Erro na importação: ' . $e->getMessage());
        }
    }

    public function importLeituras(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:xls,xlsx|max:10240',
            'tipo' => 'required|in:auto,barragem,estacao,pluviometrica',
        ]);

        try {
            $result = $this->importService->importLeituras(
                $request->file('file'), 
                $request->input('tipo')
            );
            
            return redirect()->back()
                ->with('success', "Importação concluída! {$result['success']} leituras importadas com sucesso.")
                ->with('import_result', $result)
                ->with('import_type', 'Leituras');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Erro na importação: ' . $e->getMessage());
        }
    }

    public function importBarragensCompleto(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:xls,xlsx,xlsm|max:50240', // 50MB max para arquivo grande
        ]);

        try {
            $result = $this->importService->importBarragensCompleto($request->file('file'));

            return redirect()->back()
                ->with('success', "Importação do Excel completo concluída! {$result['success']} leituras importadas com sucesso.")
                ->with('import_result', $result)
                ->with('import_type', 'Barragens Completo');
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Erro na importação do Excel completo: ' . $e->getMessage());
        }
    }
}