<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AreaJurisdicao extends Model
{
    use HasFactory;

    protected $table = 'areas_jurisdicao';

    protected $fillable = [
        'nome',
        'codigo',
        'descricao',
        'limites_geograficos',
        'area_total_km2',
        'coordenadas_centro',
        'responsavel',
        'contato',
        'email',
        'ativo'
    ];

    protected $casts = [
        'limites_geograficos' => 'array',
        'coordenadas_centro' => 'array',
        'area_total_km2' => 'decimal:2',
        'ativo' => 'boolean'
    ];

    /**
     * Bacias nesta área de jurisdição
     */
    public function bacias()
    {
        return $this->hasMany(BaciaHidrografica::class, 'area_jurisdicao_id');
    }

    /**
     * Scopes
     */
    public function scopeAtivo($query)
    {
        return $query->where('ativo', true);
    }

    /**
     * Estatísticas da área
     */
    public function getEstatisticasAttribute()
    {
        return [
            'total_bacias' => $this->bacias()->count(),
            'total_estacoes' => Estacao::whereHas('bacia', function($q) {
                $q->where('area_jurisdicao_id', $this->id);
            })->count(),
            'total_barragens' => Barragem::whereHas('bacia', function($q) {
                $q->where('area_jurisdicao_id', $this->id);
            })->count(),
        ];
    }
}
