<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class IQACalculado extends Model
{
    use HasFactory;

    protected $table = 'iqa_calculado';

    protected $fillable = [
        'coleta_id',
        'iqa_valor',
        'iqa_classificacao',
        'metodo_calculo',
        'detalhes_calculo',
    ];

    protected $casts = [
        'iqa_valor' => 'decimal:2',
        'detalhes_calculo' => 'array',
    ];

    public function coleta(): BelongsTo
    {
        return $this->belongsTo(ColetaQA::class, 'coleta_id');
    }

    public function getCorClassificacao()
    {
        $cores = [
            'Excelente' => '#0066CC',
            'Boa' => '#00CC66',
            'Moderada' => '#FFCC00',
            'Má' => '#FF6600',
            'Muito Má' => '#CC0000',
        ];

        return $cores[$this->iqa_classificacao] ?? '#999999';
    }
}
