<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ParametrosFisicoQuimicos extends Model
{
    use HasFactory;

    protected $table = 'parametros_fisico_quimicos';

    protected $fillable = [
        'coleta_id',
        'temperatura',
        'ph',
        'condutividade_eletrica',
        'tds',
        'oxigenio_dissolvido',
        'turbidez',
        'nitrato',
        'nitrogenio_total',
        'fosfato',
        'fosfato_total',
        'dbo',
        'coliformes_fecais',
        'solidos_totais',
        'cloretos',
    ];

    protected $casts = [
        'temperatura' => 'decimal:2',
        'ph' => 'decimal:2',
        'condutividade_eletrica' => 'integer',
        'tds' => 'integer',
        'oxigenio_dissolvido' => 'decimal:2',
        'turbidez' => 'decimal:2',
        'nitrato' => 'decimal:4',
        'nitrogenio_total' => 'decimal:4',
        'fosfato' => 'decimal:4',
        'fosfato_total' => 'decimal:4',
        'dbo' => 'decimal:2',
        'coliformes_fecais' => 'integer',
        'solidos_totais' => 'integer',
        'cloretos' => 'decimal:4',
    ];

    public function coleta(): BelongsTo
    {
        return $this->belongsTo(ColetaQA::class, 'coleta_id');
    }
}
