<?php

namespace App\Providers;

use App\Models\Barragem;
use App\Models\Estacao;
use App\Policies\BarragemPolicy;
use App\Policies\EstacaoPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        Barragem::class => BarragemPolicy::class,
        Estacao::class => EstacaoPolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        // Super admin gate - utilizadores com acesso global podem tudo
        Gate::before(function ($user, $ability) {
            // Permitir tudo para admin, excepto abilities marcadas como restritas
            if ($user->temAcessoGlobal() && $ability !== 'regional-restricted') {
                return true;
            }
        });

        // Gate para verificar acesso a divisao
        Gate::define('access-divisao', function ($user, $divisaoId) {
            return $user->podeAcessarDivisao($divisaoId);
        });

        // Gate para verificar permissao numa divisao
        Gate::define('permission-in-divisao', function ($user, $permission, $divisaoId) {
            return $user->temPermissaoNaDivisao($permission, $divisaoId);
        });
    }
}
