<?php
// app/Models/BaciaHidrografica.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BaciaHidrografica extends Model
{
    use HasFactory;

    protected $table = 'bacias_hidrograficas';

    protected $fillable = [
        'nome',
        'codigo',
        'area_km2',
        'comprimento_rio_principal',
        'provincias_abrangidas',
        'descricao',
    ];

    protected $casts = [
        'area_km2' => 'decimal:2',
        'comprimento_rio_principal' => 'decimal:2',
    ];

    public function barragens()
    {
        return $this->hasMany(Barragem::class);
    }

    public function estacoes()
    {
        return $this->hasMany(Estacao::class);
    }

    public function getProvinciasList()
    {
        return explode(',', $this->provincias_abrangidas);
    }
}
