<?php
// app/Models/CurvaCotaVolume.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CurvaCotaVolume extends Model
{
    use HasFactory;

    protected $table = 'curvas_cota_volume';

    protected $fillable = [
        'barragem_id',
        'cota',
        'volume',
        'area_espelho_agua',
    ];

    protected $casts = [
        'cota' => 'decimal:2',
        'volume' => 'decimal:2',
        'area_espelho_agua' => 'decimal:2',
    ];

    public function barragem(): BelongsTo
    {
        return $this->belongsTo(Barragem::class);
    }
}