<?php
// database/migrations/2024_01_01_100001_create_bacias_hidrograficas_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('bacias_hidrograficas', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('codigo', 50)->unique();
            $table->decimal('area_km2', 15, 2)->nullable();
            $table->decimal('comprimento_rio_principal', 10, 2)->nullable();
            $table->text('provincias_abrangidas')->nullable();
            $table->text('descricao')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('bacias_hidrograficas');
    }
};