<?php
// database/migrations/2024_01_01_100002_create_barragens_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration
{
    public function up()
    {
        Schema::create('barragens', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('codigo', 50)->unique();
            $table->foreignId('bacia_hidrografica_id')->nullable()->constrained('bacias_hidrograficas');
            $table->string('provincia', 100)->nullable();
            $table->string('distrito', 100)->nullable();
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->decimal('cota_maxima', 10, 2)->nullable();
            $table->decimal('cota_minima', 10, 2)->nullable();
            $table->decimal('cota_npa', 10, 2)->nullable();
            $table->decimal('volume_maximo', 15, 2)->nullable();
            $table->decimal('volume_morto', 15, 2)->nullable();
            $table->decimal('area_bacia_hidraulica', 15, 2)->nullable();
            $table->year('ano_construcao')->nullable();
            $table->decimal('nivel_alerta', 10, 2)->nullable();
            $table->decimal('nivel_emergencia', 10, 2)->nullable();
            $table->enum('estado', ['activa', 'inactiva', 'manutencao'])->default('activa');
            $table->text('observacoes')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('barragens');
    }
};