<?php
// database/migrations/2024_01_01_100005_create_leituras_estacoes_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('leituras_estacoes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('estacao_id')->constrained('estacoes');
            $table->date('data_leitura');
            $table->time('hora_6h')->nullable();
            $table->time('hora_12h')->nullable();
            $table->time('hora_18h')->nullable();
            $table->decimal('nivel_6h', 10, 2)->nullable();
            $table->decimal('nivel_12h', 10, 2)->nullable();
            $table->decimal('nivel_18h', 10, 2)->nullable();
            $table->decimal('nivel_hidrometrico', 10, 2)->nullable();
            $table->decimal('caudal', 15, 3)->nullable();
            $table->decimal('precipitacao_mm', 10, 2)->nullable();
            $table->decimal('temperatura_max', 5, 2)->nullable();
            $table->decimal('temperatura_min', 5, 2)->nullable();
            $table->decimal('humidade_relativa', 5, 2)->nullable();
            $table->decimal('evaporacao', 10, 2)->nullable();
            $table->foreignId('operador_id')->nullable()->constrained('users');
            $table->text('observacoes')->nullable();
            $table->boolean('validado')->default(false);
            $table->timestamps();
            
            $table->index(['estacao_id', 'data_leitura']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('leituras_estacoes');
    }
};