<?php
// database/migrations/2024_01_01_100008_create_curvas_cota_volume_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('curvas_cota_volume', function (Blueprint $table) {
            $table->id();
            $table->foreignId('barragem_id')->constrained('barragens');
            $table->decimal('cota', 10, 2);
            $table->decimal('volume', 15, 2);
            $table->decimal('area_espelho_agua', 15, 2)->nullable();
            $table->timestamps();
            
            $table->unique(['barragem_id', 'cota']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('curvas_cota_volume');
    }
};
