<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('text'); // text, email, phone, url, number, textarea
            $table->string('category')->default('general'); // general, organization, contact, bulletin
            $table->string('label');
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Insert default settings
        DB::table('system_settings')->insert([
            [
                'key' => 'organization_name',
                'value' => 'MINISTÉRIO DAS OBRAS PÚBLICAS, HABITAÇÃO E RECURSOS HÍDRICOS',
                'type' => 'text',
                'category' => 'organization',
                'label' => 'Nome da Organização',
                'description' => 'Nome completo da organização que aparecerá nos boletins',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'department_name',
                'value' => 'DIRECÇÃO NACIONAL DE GESTÃO DE RECURSOS HÍDRICOS',
                'type' => 'text',
                'category' => 'organization',
                'label' => 'Nome do Departamento',
                'description' => 'Nome do departamento responsável',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'system_name',
                'value' => 'Sistema de Gestão de Recursos Hídricos',
                'type' => 'text',
                'category' => 'general',
                'label' => 'Nome do Sistema',
                'description' => 'Nome do sistema que aparecerá na interface',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'contact_phone',
                'value' => '+258 21 430 906',
                'type' => 'phone',
                'category' => 'contact',
                'label' => 'Telefone',
                'description' => 'Número de telefone principal',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'contact_email',
                'value' => 'dngrh@mophrh.gov.mz',
                'type' => 'email',
                'category' => 'contact',
                'label' => 'Email',
                'description' => 'Email principal para contacto',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'contact_address',
                'value' => 'Av. 25 de Setembro, 1218, Maputo - Moçambique',
                'type' => 'textarea',
                'category' => 'contact',
                'label' => 'Endereço',
                'description' => 'Endereço físico da organização',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'website_url',
                'value' => 'https://www.mophrh.gov.mz',
                'type' => 'url',
                'category' => 'contact',
                'label' => 'Website',
                'description' => 'URL do website oficial',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'responsible_person_name',
                'value' => 'João Alberto Miguel Sitoe',
                'type' => 'text',
                'category' => 'bulletin',
                'label' => 'Nome do Responsável',
                'description' => 'Nome da pessoa responsável pelos boletins',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'responsible_person_title',
                'value' => 'Técnico Superior N1',
                'type' => 'text',
                'category' => 'bulletin',
                'label' => 'Cargo do Responsável',
                'description' => 'Cargo da pessoa responsável pelos boletins',
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_settings');
    }
};
