<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seba_integracao_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('estacao_id')->nullable()->constrained('estacoes')->onDelete('set null');
            $table->enum('tipo', ['importacao_estacao', 'importacao_massa', 'teste_conectividade', 'sincronizacao'])->default('importacao_estacao');
            $table->enum('status', ['executando', 'sucesso', 'erro', 'parcial'])->default('executando');
            $table->text('mensagem')->nullable();
            $table->integer('registros_importados')->default(0);
            $table->integer('registros_erro')->default(0);
            $table->integer('registros_duplicados')->default(0);
            $table->json('detalhes')->nullable(); // Para armazenar dados adicionais
            $table->timestamp('iniciado_em')->nullable();
            $table->timestamp('finalizado_em')->nullable();
            $table->integer('tempo_execucao')->nullable(); // em segundos
            $table->timestamps();

            $table->index(['estacao_id', 'created_at']);
            $table->index(['status', 'created_at']);
            $table->index('tipo');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seba_integracao_logs');
    }
};
