<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('formulas_caudal', function (Blueprint $table) {
            $table->id();
            $table->foreignId('estacao_id')->constrained('estacoes')->onDelete('cascade');

            // Informações da fórmula
            $table->string('nome')->comment('Nome descritivo da fórmula (ex: "Fórmula pós-cheia 2024")');
            $table->text('descricao')->nullable()->comment('Descrição dos motivos da mudança');

            // Coeficientes da fórmula A(H-C)^B
            $table->decimal('coeficiente_a', 15, 6)->comment('Coeficiente A da fórmula');
            $table->decimal('coeficiente_b', 15, 6)->comment('Expoente B da fórmula');
            $table->decimal('coeficiente_c', 15, 6)->default(0)->comment('Offset C da fórmula');

            // Validade da fórmula
            $table->date('data_inicio')->comment('Data de início de validade');
            $table->date('data_fim')->nullable()->comment('Data de fim de validade (null = indefinido)');
            $table->boolean('ativa')->default(true)->comment('Se a fórmula está ativa');

            // Faixa de validade (níveis mínimo e máximo para aplicar a fórmula)
            $table->decimal('nivel_min', 10, 3)->nullable()->comment('Nível mínimo para aplicar a fórmula (m)');
            $table->decimal('nivel_max', 10, 3)->nullable()->comment('Nível máximo para aplicar a fórmula (m)');

            // Metadados
            $table->foreignId('criado_por')->constrained('users')->comment('Usuário que criou a fórmula');
            $table->text('motivo_mudanca')->nullable()->comment('Motivo da mudança (cheia, alteração do leito, etc.)');
            $table->decimal('r_quadrado', 5, 4)->nullable()->comment('Coeficiente de correlação R² (qualidade do ajuste)');

            $table->timestamps();

            // Índices para performance
            $table->index(['estacao_id', 'ativa', 'data_inicio']);
            $table->index(['data_inicio', 'data_fim']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('formulas_caudal');
    }
};