<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('barragens', function (Blueprint $table) {
            // Remover apenas campos que existem com terminologia incorreta para barragens
            if (Schema::hasColumn('barragens', 'cota_seguranca')) {
                $table->dropColumn('cota_seguranca');
            }
            if (Schema::hasColumn('barragens', 'nivel_alerta')) {
                $table->dropColumn('nivel_alerta');
            }
            if (Schema::hasColumn('barragens', 'nivel_emergencia')) {
                $table->dropColumn('nivel_emergencia');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('barragens', function (Blueprint $table) {
            // Restaurar campos obsoletos caso seja necessário rollback
            $table->decimal('cota_seguranca', 8, 2)->nullable()->comment('OBSOLETO - usar NPA/NME/NMC');
            $table->decimal('nivel_alerta', 8, 2)->nullable()->comment('OBSOLETO - usar NPA/NME/NMC');
            $table->decimal('nivel_emergencia', 8, 2)->nullable()->comment('OBSOLETO - usar NPA/NME/NMC');
        });
    }
};
