<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('qualidade_agua', function (Blueprint $table) {
            $table->id();
            $table->foreignId('barragem_id')->nullable()->constrained('barragens')->onDelete('cascade');
            $table->foreignId('estacao_id')->nullable()->constrained('estacoes')->onDelete('cascade');
            $table->date('data_coleta');
            $table->time('hora_coleta');

            // Parâmetros físico-químicos para cálculo do IQA
            $table->decimal('oxigenio_dissolvido', 8, 2)->nullable()->comment('OD - mg/L');
            $table->decimal('coliformes_fecais', 15, 2)->nullable()->comment('NMP/100mL');
            $table->decimal('ph', 4, 2)->nullable()->comment('pH');
            $table->decimal('dbo5', 8, 2)->nullable()->comment('DBO5 - mg/L');
            $table->decimal('nitrogenio_total', 8, 2)->nullable()->comment('Nitrogênio Total - mg/L');
            $table->decimal('fosforo_total', 8, 2)->nullable()->comment('Fósforo Total - mg/L');
            $table->decimal('temperatura', 5, 2)->nullable()->comment('Temperatura - °C');
            $table->decimal('turbidez', 8, 2)->nullable()->comment('Turbidez - UNT');
            $table->decimal('solidos_totais', 10, 2)->nullable()->comment('Sólidos Totais - mg/L');

            // Parâmetros adicionais opcionais
            $table->decimal('condutividade', 10, 2)->nullable()->comment('µS/cm');
            $table->decimal('salinidade', 8, 2)->nullable()->comment('ppt');
            $table->decimal('clorofila_a', 8, 2)->nullable()->comment('µg/L');
            $table->decimal('transparencia', 5, 2)->nullable()->comment('metros');

            // Cálculo do IQA
            $table->decimal('iqa', 5, 2)->nullable()->comment('Índice de Qualidade de Água (0-100)');
            $table->enum('classificacao_iqa', [
                'excelente',    // 91-100
                'boa',          // 71-90
                'media',        // 51-70
                'ruim',         // 26-50
                'pessima'       // 0-25
            ])->nullable();

            // Informações de coleta
            $table->string('local_coleta')->nullable();
            $table->decimal('profundidade_coleta', 8, 2)->nullable()->comment('metros');
            $table->string('responsavel_coleta')->nullable();
            $table->string('laboratorio')->nullable();
            $table->date('data_analise')->nullable();

            // Controle e validação
            $table->text('observacoes')->nullable();
            $table->boolean('validado')->default(false);
            $table->foreignId('validado_por')->nullable()->constrained('users');
            $table->timestamp('data_validacao')->nullable();
            $table->timestamps();

            // Índices
            $table->index(['barragem_id', 'data_coleta']);
            $table->index(['estacao_id', 'data_coleta']);
            $table->index('iqa');
            $table->index('classificacao_iqa');
        });
    }

    public function down()
    {
        Schema::dropIfExists('qualidade_agua');
    }
};
