<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Primeiro, renomear campo existente para P1
        if (Schema::hasColumn('leituras_barragens', 'precipitacao')) {
            Schema::table('leituras_barragens', function (Blueprint $table) {
                $table->renameColumn('precipitacao', 'precipitacao_p1');
            });
        }

        // Depois, adicionar campos que faltam
        Schema::table('leituras_barragens', function (Blueprint $table) {
            if (!Schema::hasColumn('leituras_barragens', 'precipitacao_p1')) {
                $table->decimal('precipitacao_p1', 5, 2)->nullable()->after('descarga_total')->comment('Precipitação estação P1 (mm)');
            }

            if (!Schema::hasColumn('leituras_barragens', 'precipitacao_p2')) {
                $table->decimal('precipitacao_p2', 5, 2)->nullable()->after('precipitacao_p1')->comment('Precipitação estação P2 (mm)');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            if (Schema::hasColumn('leituras_barragens', 'precipitacao_p2')) {
                $table->dropColumn('precipitacao_p2');
            }
        });

        if (Schema::hasColumn('leituras_barragens', 'precipitacao_p1')) {
            Schema::table('leituras_barragens', function (Blueprint $table) {
                $table->renameColumn('precipitacao_p1', 'precipitacao');
            });
        }
    }
};
