<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            if (!Schema::hasColumn('leituras_barragens', 'precipitacao_p3')) {
                $table->decimal('precipitacao_p3', 5, 2)->nullable()->after('precipitacao_p2')->comment('Precipitação estação P3 (mm)');
            }
            if (!Schema::hasColumn('leituras_barragens', 'precipitacao_p4')) {
                $table->decimal('precipitacao_p4', 5, 2)->nullable()->after('precipitacao_p3')->comment('Precipitação estação P4 (mm)');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            if (Schema::hasColumn('leituras_barragens', 'precipitacao_p4')) {
                $table->dropColumn('precipitacao_p4');
            }
            if (Schema::hasColumn('leituras_barragens', 'precipitacao_p3')) {
                $table->dropColumn('precipitacao_p3');
            }
        });
    }
};
