<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            // Campo JSON para armazenar precipitações de múltiplas estações
            // Formato: {"P-423": 0.0, "P-609": 2.5, "P-110": 1.2, ...}
            if (!Schema::hasColumn('leituras_barragens', 'precipitacoes')) {
                $table->json('precipitacoes')->nullable()->after('precipitacao_p4')->comment('Precipitações por estação (JSON)');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            if (Schema::hasColumn('leituras_barragens', 'precipitacoes')) {
                $table->dropColumn('precipitacoes');
            }
        });
    }
};
