<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * Baseado no Excel BARRAGENS ACT 8.8:
     * - escala_npa: Valor na escala/régua que corresponde ao NPA
     * - Fórmula: Cota = NPA - (escala_npa - nivel_hidrometrico)
     *
     * Exemplos do Excel:
     * - NAMPULA: NPA=336, escala_npa=9.86 → Cota = 336-(9.86-Nivel)
     * - NACALA: NPA=78.5, escala_npa=14.31 → Cota = 78.5-(14.31-Nivel)
     */
    public function up(): void
    {
        // Adicionar campo na tabela barragens
        Schema::table('barragens', function (Blueprint $table) {
            if (!Schema::hasColumn('barragens', 'escala_npa')) {
                $table->decimal('escala_npa', 8, 2)->nullable()
                    ->after('cota_npa')
                    ->comment('Valor na escala/régua correspondente ao NPA (para cálculo da cota)');
            }
        });

        // Adicionar campo nivel_hidrometrico na tabela leituras_barragens
        Schema::table('leituras_barragens', function (Blueprint $table) {
            if (!Schema::hasColumn('leituras_barragens', 'nivel_hidrometrico')) {
                $table->decimal('nivel_hidrometrico', 8, 2)->nullable()
                    ->after('hora_leitura')
                    ->comment('Leitura na escala/régua (valor de entrada principal)');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leituras_barragens', function (Blueprint $table) {
            if (Schema::hasColumn('leituras_barragens', 'nivel_hidrometrico')) {
                $table->dropColumn('nivel_hidrometrico');
            }
        });

        Schema::table('barragens', function (Blueprint $table) {
            if (Schema::hasColumn('barragens', 'escala_npa')) {
                $table->dropColumn('escala_npa');
            }
        });
    }
};
