<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * Adiciona campos de controle de acesso ao modelo User
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Divisao principal do utilizador (substitui gradualmente o campo provincia string)
            $table->foreignId('divisao_principal_id')
                  ->nullable()
                  ->after('provincia')
                  ->constrained('divisoes_administrativas')
                  ->nullOnDelete();

            // Flag de acesso global (para administradores que podem ver tudo)
            $table->boolean('acesso_global')
                  ->default(false)
                  ->after('divisao_principal_id');

            // Indice para performance
            $table->index('divisao_principal_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['divisao_principal_id']);
            $table->dropColumn(['divisao_principal_id', 'acesso_global']);
        });
    }
};
