<?php
// database/seeders/BaciaHidrograficaSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\BaciaHidrografica;

class BaciaHidrograficaSeeder extends Seeder
{
    public function run()
    {
        $bacias = [
            ['nome' => 'Bacia do Licungo', 'codigo' => 'LIC-001', 'area_km2' => 12500.00, 'comprimento_rio_principal' => 385.0, 'provincias_abrangidas' => 'Zambézia, Nampula', 'descricao' => 'Bacia hidrográfica do rio Licungo.'],
            ['nome' => 'Bacia de Ligonha', 'codigo' => 'LIG-001', 'area_km2' => 8750.00, 'comprimento_rio_principal' => 280.0, 'provincias_abrangidas' => 'Nampula', 'descricao' => 'Bacia hidrográfica do rio Ligonha.'],
            ['nome' => 'Bacia do Meluli', 'codigo' => 'MEL-001', 'area_km2' => 5420.00, 'comprimento_rio_principal' => 195.0, 'provincias_abrangidas' => 'Nampula', 'descricao' => 'Bacia hidrográfica do rio Meluli.'],
            ['nome' => 'Bacia do Lúrio', 'codigo' => 'LUR-001', 'area_km2' => 15800.00, 'comprimento_rio_principal' => 465.0, 'provincias_abrangidas' => 'Nampula, Cabo Delgado', 'descricao' => 'Bacia hidrográfica do rio Lúrio.'],
            ['nome' => 'Bacia do Rovuma', 'codigo' => 'ROV-001', 'area_km2' => 18650.00, 'comprimento_rio_principal' => 520.0, 'provincias_abrangidas' => 'Cabo Delgado, Niassa', 'descricao' => 'Bacia hidrográfica do rio Rovuma.'],
            ['nome' => 'Bacia de Messalo', 'codigo' => 'MES-001', 'area_km2' => 6890.00, 'comprimento_rio_principal' => 230.0, 'provincias_abrangidas' => 'Cabo Delgado', 'descricao' => 'Bacia hidrográfica do rio Messalo.']
        ];

        foreach ($bacias as $bacia) {
            BaciaHidrografica::create($bacia);
        }
    }
}