<?php
// database/seeders/BarragemSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Barragem;
use App\Models\BaciaHidrografica;

class BarragemSeeder extends Seeder
{
    public function run()
    {
        $bacia_licungo = BaciaHidrografica::where('codigo', 'LIC-001')->first();
        $bacia_ligonha = BaciaHidrografica::where('codigo', 'LIG-001')->first();
        $bacia_meluli = BaciaHidrografica::where('codigo', 'MEL-001')->first();
        $bacia_lurio = BaciaHidrografica::where('codigo', 'LUR-001')->first();

        $barragens = [
            ['nome' => 'Barragem de Nampula', 'codigo' => 'BAR-001', 'bacia_hidrografica_id' => $bacia_licungo?->id, 'provincia' => 'Nampula', 'distrito' => 'Nampula', 'latitude' => -15.1165, 'longitude' => 39.2666, 'cota_maxima' => 3800.00, 'cota_minima' => 3700.00, 'cota_npa' => 3775.00, 'volume_maximo' => 180.50, 'volume_morto' => 12.30, 'nivel_alerta' => 3770.00, 'nivel_emergencia' => 3795.00, 'estado' => 'activa'],
            ['nome' => 'Barragem de Nacala', 'codigo' => 'BAR-002', 'bacia_hidrografica_id' => $bacia_ligonha?->id, 'provincia' => 'Nampula', 'distrito' => 'Nacala', 'latitude' => -14.5428, 'longitude' => 40.6764, 'cota_maxima' => 80.00, 'cota_minima' => 65.00, 'cota_npa' => 78.50, 'volume_maximo' => 95.80, 'volume_morto' => 8.50, 'nivel_alerta' => 78.00, 'nivel_emergencia' => 79.50, 'estado' => 'activa'],
            ['nome' => 'Barragem de Mugica', 'codigo' => 'BAR-003', 'bacia_hidrografica_id' => $bacia_meluli?->id, 'provincia' => 'Nampula', 'distrito' => 'Ribaué', 'latitude' => -14.9234, 'longitude' => 38.3145, 'cota_maxima' => 98.00, 'cota_minima' => 85.00, 'cota_npa' => 96.50, 'volume_maximo' => 125.40, 'volume_morto' => 15.20, 'nivel_alerta' => 96.00, 'nivel_emergencia' => 97.50, 'estado' => 'activa'],
            ['nome' => 'Barragem de Chipembe', 'codigo' => 'BAR-004', 'bacia_hidrografica_id' => $bacia_lurio?->id, 'provincia' => 'Nampula', 'distrito' => 'Muecate', 'latitude' => -14.7856, 'longitude' => 38.9234, 'cota_maxima' => 502.00, 'cota_minima' => 485.00, 'cota_npa' => 500.00, 'volume_maximo' => 285.70, 'volume_morto' => 25.80, 'nivel_alerta' => 499.00, 'nivel_emergencia' => 501.50, 'estado' => 'activa'],
            ['nome' => 'Barragem de Locomue', 'codigo' => 'BAR-005', 'bacia_hidrografica_id' => $bacia_lurio?->id, 'provincia' => 'Cabo Delgado', 'distrito' => 'Montepuez', 'latitude' => -13.1256, 'longitude' => 38.9987, 'cota_maxima' => 1320.00, 'cota_minima' => 1300.00, 'cota_npa' => 1315.00, 'volume_maximo' => 68.90, 'volume_morto' => 5.60, 'nivel_alerta' => 1314.00, 'nivel_emergencia' => 1318.00, 'estado' => 'activa'],
            ['nome' => 'Barragem de Mitucue', 'codigo' => 'BAR-006', 'bacia_hidrografica_id' => $bacia_lurio?->id, 'provincia' => 'Nampula', 'distrito' => 'Lalaua', 'latitude' => -14.3567, 'longitude' => 38.7234, 'cota_maxima' => 1000.00, 'cota_minima' => 990.00, 'cota_npa' => 998.00, 'volume_maximo' => 142.30, 'volume_morto' => 18.50, 'nivel_alerta' => 997.00, 'nivel_emergencia' => 999.00, 'estado' => 'activa']
        ];

        foreach ($barragens as $barragem) {
            Barragem::create($barragem);
        }
    }
}
