<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\DivisaoAdministrativa;

class DivisaoAdministrativaSeeder extends Seeder
{
    /**
     * Seed das Divisoes Administrativas de Mocambique
     * Estrutura: Provincia > Distrito
     */
    public function run(): void
    {
        $this->command->info('Criando divisoes administrativas...');

        // Provincias e seus distritos
        $provincias = [
            'Cabo Delgado' => [
                'codigo' => 'CD',
                'distritos' => [
                    'Pemba Cidade' => 'CD-PMB',
                    'Ancuabe' => 'CD-ANC',
                    'Balama' => 'CD-BAL',
                    'Chiure' => 'CD-CHI',
                    'Ibo' => 'CD-IBO',
                    'Macomia' => 'CD-MAC',
                    'Mecufi' => 'CD-MEC',
                    'Meluco' => 'CD-MEL',
                    'Metuge' => 'CD-MET',
                    'Mocimboa da Praia' => 'CD-MCP',
                    'Montepuez' => 'CD-MTP',
                    'Mueda' => 'CD-MUE',
                    'Muidumbe' => 'CD-MUI',
                    'Namuno' => 'CD-NAM',
                    'Nangade' => 'CD-NAN',
                    'Palma' => 'CD-PAL',
                    'Pemba Metuge' => 'CD-PMM',
                    'Quissanga' => 'CD-QUI',
                ]
            ],
            'Niassa' => [
                'codigo' => 'NS',
                'distritos' => [
                    'Lichinga Cidade' => 'NS-LIC',
                    'Cuamba' => 'NS-CUA',
                    'Lago' => 'NS-LAG',
                    'Lichinga' => 'NS-LCH',
                    'Majune' => 'NS-MAJ',
                    'Mandimba' => 'NS-MAN',
                    'Marrupa' => 'NS-MAR',
                    'Maua' => 'NS-MAU',
                    'Mavago' => 'NS-MAV',
                    'Mecanhelas' => 'NS-MEC',
                    'Mecula' => 'NS-MCL',
                    'Metarica' => 'NS-MET',
                    'Muembe' => 'NS-MUE',
                    'Ngauma' => 'NS-NGA',
                    'Nipepe' => 'NS-NIP',
                    'Sanga' => 'NS-SAN',
                ]
            ],
            'Nampula' => [
                'codigo' => 'NP',
                'distritos' => [
                    'Nampula Cidade' => 'NP-NPC',
                    'Nacala Porto' => 'NP-NCP',
                    'Angoche' => 'NP-ANG',
                    'Erati' => 'NP-ERA',
                    'Ilha de Mocambique' => 'NP-ILM',
                    'Lalaua' => 'NP-LAL',
                    'Larde' => 'NP-LAR',
                    'Liupo' => 'NP-LIU',
                    'Malema' => 'NP-MAL',
                    'Meconta' => 'NP-MEC',
                    'Mecuburi' => 'NP-MCB',
                    'Memba' => 'NP-MEM',
                    'Mogincual' => 'NP-MOG',
                    'Mogovolas' => 'NP-MGV',
                    'Moma' => 'NP-MOM',
                    'Monapo' => 'NP-MON',
                    'Mossuril' => 'NP-MOS',
                    'Muecate' => 'NP-MUE',
                    'Murrupula' => 'NP-MUR',
                    'Nacala-a-Velha' => 'NP-NAV',
                    'Nacaroa' => 'NP-NAC',
                    'Rapale' => 'NP-RAP',
                    'Ribaue' => 'NP-RIB',
                ]
            ],
            'Zambezia' => [
                'codigo' => 'ZB',
                'distritos' => [
                    'Quelimane' => 'ZB-QUE',
                    'Alto Molocue' => 'ZB-ALM',
                    'Chinde' => 'ZB-CHI',
                    'Gile' => 'ZB-GIL',
                    'Gurue' => 'ZB-GUR',
                    'Ile' => 'ZB-ILE',
                    'Inhassunge' => 'ZB-INH',
                    'Lugela' => 'ZB-LUG',
                    'Maganja da Costa' => 'ZB-MAC',
                    'Milange' => 'ZB-MIL',
                    'Mocuba' => 'ZB-MOC',
                    'Mopeia' => 'ZB-MOP',
                    'Morrumbala' => 'ZB-MOR',
                    'Namacurra' => 'ZB-NAM',
                    'Namarroi' => 'ZB-NMR',
                    'Nicoadala' => 'ZB-NIC',
                    'Pebane' => 'ZB-PEB',
                ]
            ],
            'Tete' => [
                'codigo' => 'TT',
                'distritos' => [
                    'Tete Cidade' => 'TT-TET',
                    'Angonia' => 'TT-ANG',
                    'Cahora-Bassa' => 'TT-CAH',
                    'Changara' => 'TT-CHA',
                    'Chifunde' => 'TT-CHI',
                    'Chiuta' => 'TT-CHU',
                    'Macanga' => 'TT-MAC',
                    'Magoe' => 'TT-MAG',
                    'Marara' => 'TT-MAR',
                    'Maravia' => 'TT-MRV',
                    'Moatize' => 'TT-MOA',
                    'Mutarara' => 'TT-MUT',
                    'Tsangano' => 'TT-TSA',
                    'Zumbo' => 'TT-ZUM',
                ]
            ],
            'Manica' => [
                'codigo' => 'MN',
                'distritos' => [
                    'Chimoio' => 'MN-CHI',
                    'Barue' => 'MN-BAR',
                    'Gondola' => 'MN-GON',
                    'Guro' => 'MN-GUR',
                    'Macate' => 'MN-MAC',
                    'Machaze' => 'MN-MCH',
                    'Macossa' => 'MN-MCS',
                    'Manica' => 'MN-MAN',
                    'Mossurize' => 'MN-MOS',
                    'Sussundenga' => 'MN-SUS',
                    'Tambara' => 'MN-TAM',
                    'Vanduzi' => 'MN-VAN',
                ]
            ],
            'Sofala' => [
                'codigo' => 'SF',
                'distritos' => [
                    'Beira' => 'SF-BEI',
                    'Buzi' => 'SF-BUZ',
                    'Caia' => 'SF-CAI',
                    'Chemba' => 'SF-CHE',
                    'Cheringoma' => 'SF-CHR',
                    'Chibabava' => 'SF-CHB',
                    'Dondo' => 'SF-DON',
                    'Gorongosa' => 'SF-GOR',
                    'Machanga' => 'SF-MAC',
                    'Maringue' => 'SF-MAR',
                    'Marromeu' => 'SF-MRR',
                    'Muanza' => 'SF-MUA',
                    'Nhamatanda' => 'SF-NHA',
                ]
            ],
            'Inhambane' => [
                'codigo' => 'IB',
                'distritos' => [
                    'Inhambane Cidade' => 'IB-INH',
                    'Funhalouro' => 'IB-FUN',
                    'Govuro' => 'IB-GOV',
                    'Homoíne' => 'IB-HOM',
                    'Inharrime' => 'IB-INR',
                    'Inhassoro' => 'IB-INS',
                    'Jangamo' => 'IB-JAN',
                    'Mabote' => 'IB-MAB',
                    'Massinga' => 'IB-MAS',
                    'Maxixe' => 'IB-MAX',
                    'Morrumbene' => 'IB-MOR',
                    'Panda' => 'IB-PAN',
                    'Vilankulo' => 'IB-VIL',
                    'Zavala' => 'IB-ZAV',
                ]
            ],
            'Gaza' => [
                'codigo' => 'GZ',
                'distritos' => [
                    'Xai-Xai' => 'GZ-XAI',
                    'Bilene' => 'GZ-BIL',
                    'Chibuto' => 'GZ-CHI',
                    'Chicualacuala' => 'GZ-CHC',
                    'Chigubo' => 'GZ-CHG',
                    'Chokwe' => 'GZ-CHO',
                    'Guija' => 'GZ-GUI',
                    'Limpopo' => 'GZ-LIM',
                    'Mabalane' => 'GZ-MAB',
                    'Mandlakazi' => 'GZ-MAN',
                    'Massangena' => 'GZ-MSS',
                    'Massingir' => 'GZ-MSG',
                ]
            ],
            'Maputo Provincia' => [
                'codigo' => 'MP',
                'distritos' => [
                    'Matola' => 'MP-MAT',
                    'Boane' => 'MP-BOA',
                    'Magude' => 'MP-MAG',
                    'Manhica' => 'MP-MAN',
                    'Marracuene' => 'MP-MAR',
                    'Matutuine' => 'MP-MTT',
                    'Moamba' => 'MP-MOA',
                    'Namaacha' => 'MP-NAM',
                ]
            ],
            'Maputo Cidade' => [
                'codigo' => 'MC',
                'distritos' => [
                    'KaMpfumo' => 'MC-KPF',
                    'Nlhamankulu' => 'MC-NLH',
                    'KaMaxaquene' => 'MC-KMX',
                    'KaMavota' => 'MC-KMV',
                    'KaMubukwana' => 'MC-KMB',
                    'KaTembe' => 'MC-KTB',
                    'KaNyaka' => 'MC-KNY',
                ]
            ],
        ];

        foreach ($provincias as $nomeProvincia => $dados) {
            // Criar provincia
            $provincia = DivisaoAdministrativa::create([
                'nome' => $nomeProvincia,
                'codigo' => $dados['codigo'],
                'tipo' => 'provincia',
                'parent_id' => null,
                'ativo' => true,
            ]);

            $this->command->info("  Provincia: {$nomeProvincia}");

            // Criar distritos
            foreach ($dados['distritos'] as $nomeDistrito => $codigoDistrito) {
                DivisaoAdministrativa::create([
                    'nome' => $nomeDistrito,
                    'codigo' => $codigoDistrito,
                    'tipo' => 'distrito',
                    'parent_id' => $provincia->id,
                    'ativo' => true,
                ]);
            }
        }

        $total = DivisaoAdministrativa::count();
        $this->command->info("Total de divisoes criadas: {$total}");
    }
}
