<?php
// database/seeders/EstacaoSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Estacao;
use App\Models\BaciaHidrografica;

class EstacaoSeeder extends Seeder
{
    public function run()
    {
        $bacia_licungo = BaciaHidrografica::where('codigo', 'LIC-001')->first();
        $bacia_ligonha = BaciaHidrografica::where('codigo', 'LIG-001')->first();
        $bacia_meluli = BaciaHidrografica::where('codigo', 'MEL-001')->first();
        $bacia_lurio = BaciaHidrografica::where('codigo', 'LUR-001')->first();

        $estacoes = [
            // Bacia do Licungo
            ['nome' => 'Gurué', 'codigo' => 'E-90', 'tipo' => 'hidrometrica', 'bacia_hidrografica_id' => $bacia_licungo?->id, 'provincia' => 'Zambézia', 'distrito' => 'Gurué', 'rio' => 'Licungo', 'latitude' => -15.4567, 'longitude' => 36.9876, 'nivel_alerta' => 3.5, 'estado' => 'activa'],
            ['nome' => 'Mocuba', 'codigo' => 'E-91', 'tipo' => 'hidrometrica', 'bacia_hidrografica_id' => $bacia_licungo?->id, 'provincia' => 'Zambézia', 'distrito' => 'Mocuba', 'rio' => 'Licungo', 'latitude' => -16.8234, 'longitude' => 36.9854, 'nivel_alerta' => 6.0, 'estado' => 'activa'],
            ['nome' => 'Tacuane', 'codigo' => 'E-92', 'tipo' => 'hidrometrica', 'bacia_hidrografica_id' => $bacia_licungo?->id, 'provincia' => 'Zambézia', 'distrito' => 'Quelimane', 'rio' => 'Licungo', 'latitude' => -17.8765, 'longitude' => 36.8943, 'estado' => 'activa'],
            
            // Bacia de Ligonha
            ['nome' => 'Murrupula', 'codigo' => 'E-132', 'tipo' => 'hidrometrica', 'bacia_hidrografica_id' => $bacia_ligonha?->id, 'provincia' => 'Nampula', 'distrito' => 'Murrupula', 'rio' => 'Ligonha', 'latitude' => -14.9543, 'longitude' => 38.3456, 'nivel_alerta' => 5.5, 'estado' => 'activa'],
            ['nome' => 'Moma', 'codigo' => 'E-506', 'tipo' => 'hidrometrica', 'bacia_hidrografica_id' => $bacia_ligonha?->id, 'provincia' => 'Nampula', 'distrito' => 'Moma', 'rio' => 'Ligonha', 'latitude' => -16.6789, 'longitude' => 39.7654, 'nivel_alerta' => 6.0, 'estado' => 'activa'],
            
            // Bacia do Meluli
            ['nome' => 'Rapale', 'codigo' => 'E-126', 'tipo' => 'hidrometrica', 'bacia_hidrografica_id' => $bacia_meluli?->id, 'provincia' => 'Nampula', 'distrito' => 'Ribaué', 'rio' => 'Meluli', 'latitude' => -14.9876, 'longitude' => 38.2543, 'nivel_alerta' => 4.0, 'estado' => 'activa'],
            ['nome' => 'Namaita', 'codigo' => 'E-138', 'tipo' => 'hidrometrica', 'bacia_hidrografica_id' => $bacia_meluli?->id, 'provincia' => 'Nampula', 'distrito' => 'Meconta', 'rio' => 'Meluli', 'latitude' => -15.1234, 'longitude' => 38.4567, 'nivel_alerta' => 4.0, 'estado' => 'activa'],
            
            // Bacia do Lúrio
            ['nome' => 'Namapa', 'codigo' => 'E-128', 'tipo' => 'hidrometrica', 'bacia_hidrografica_id' => $bacia_lurio?->id, 'provincia' => 'Nampula', 'distrito' => 'Meconta', 'rio' => 'Lúrio', 'latitude' => -14.8765, 'longitude' => 38.9876, 'nivel_alerta' => 5.5, 'estado' => 'activa'],
            
            // Estações Pluviométricas
            ['nome' => 'Pluviométrica Gurué', 'codigo' => 'P-129', 'tipo' => 'pluviometrica', 'bacia_hidrografica_id' => $bacia_licungo?->id, 'provincia' => 'Zambézia', 'distrito' => 'Gurué', 'latitude' => -15.4600, 'longitude' => 36.9900, 'estado' => 'activa'],
            ['nome' => 'Pluviométrica Nampula', 'codigo' => 'P-332', 'tipo' => 'pluviometrica', 'bacia_hidrografica_id' => $bacia_licungo?->id, 'provincia' => 'Nampula', 'distrito' => 'Nampula', 'latitude' => -15.1190, 'longitude' => 39.2690, 'estado' => 'activa'],
            ['nome' => 'Pluviométrica Tacuane', 'codigo' => 'P-377', 'tipo' => 'pluviometrica', 'bacia_hidrografica_id' => $bacia_licungo?->id, 'provincia' => 'Zambézia', 'distrito' => 'Quelimane', 'latitude' => -17.8780, 'longitude' => 36.8960, 'estado' => 'activa'],
            ['nome' => 'Pluviométrica Mocuba', 'codigo' => 'P-1137', 'tipo' => 'pluviometrica', 'bacia_hidrografica_id' => $bacia_licungo?->id, 'provincia' => 'Zambézia', 'distrito' => 'Mocuba', 'latitude' => -16.8250, 'longitude' => 36.9870, 'estado' => 'activa']
        ];

        foreach ($estacoes as $estacao) {
            Estacao::create($estacao);
        }
    }
}