<?php
// database/seeders/PermissionSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    public function run()
    {
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        $permissions = [
            'ver-dashboard', 'gerir-barragens', 'criar-barragens', 'editar-barragens',
            'eliminar-barragens', 'gerir-leituras-barragens', 'validar-leituras-barragens',
            'gerir-estacoes', 'criar-estacoes', 'editar-estacoes', 'eliminar-estacoes',
            'gerir-leituras-estacoes', 'validar-leituras-estacoes', 'gerir-boletins',
            'criar-boletins', 'aprovar-boletins', 'publicar-boletins', 'gerir-alertas',
            'resolver-alertas', 'importar-dados', 'gerir-usuarios', 'ver-relatorios',
            'configurar-sistema'
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        $admin = Role::create(['name' => 'Administrador']);
        $admin->givePermissionTo(Permission::all());

        $tecnico_senior = Role::create(['name' => 'Técnico Sénior']);
        $tecnico_senior->givePermissionTo([
            'ver-dashboard', 'gerir-barragens', 'criar-barragens', 'editar-barragens',
            'gerir-leituras-barragens', 'validar-leituras-barragens', 'gerir-estacoes',
            'criar-estacoes', 'editar-estacoes', 'gerir-leituras-estacoes',
            'validar-leituras-estacoes', 'gerir-boletins', 'criar-boletins',
            'aprovar-boletins', 'publicar-boletins', 'gerir-alertas', 'resolver-alertas',
            'importar-dados', 'ver-relatorios'
        ]);

        $tecnico = Role::create(['name' => 'Técnico']);
        $tecnico->givePermissionTo([
            'ver-dashboard', 'gerir-leituras-barragens', 'gerir-leituras-estacoes',
            'criar-boletins', 'gerir-alertas', 'importar-dados'
        ]);

        $operador = Role::create(['name' => 'Operador']);
        $operador->givePermissionTo(['ver-dashboard', 'gerir-leituras-barragens', 'gerir-leituras-estacoes']);

        $visualizador = Role::create(['name' => 'Visualizador']);
        $visualizador->givePermissionTo(['ver-dashboard', 'ver-relatorios']);
    }
}