<?php
// database/seeders/UserSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run()
    {
        $admin = User::create([
            'name' => 'Administrador Sistema',
            'email' => 'admin@aranorteip.gov.mz',
            'password' => Hash::make('admin123'),
            'telefone' => '+258 21 123456',
            'cargo' => 'Administrador do Sistema',
            'departamento' => 'Tecnologias de Informação',
            'provincia' => 'Maputo',
            'ativo' => true,
            'email_verified_at' => now(),
        ]);
        $admin->assignRole('Administrador');

        $tecnico_senior = User::create([
            'name' => 'João A. M. Sitoe',
            'email' => 'joao.sitoe@aranorteip.gov.mz',
            'password' => Hash::make('tecnico123'),
            'telefone' => '+258 26 212345',
            'cargo' => 'Inspector Superior',
            'departamento' => 'Recursos Hídricos',
            'provincia' => 'Nampula',
            'ativo' => true,
            'email_verified_at' => now(),
        ]);
        $tecnico_senior->assignRole('Técnico Sénior');

        $tecnico = User::create([
            'name' => 'Maria Santos Silva',
            'email' => 'maria.santos@aranorteip.gov.mz',
            'password' => Hash::make('tecnico123'),
            'cargo' => 'Técnica Hidrologia',
            'departamento' => 'Monitoramento Hidrológico',
            'provincia' => 'Nampula',
            'ativo' => true,
            'email_verified_at' => now(),
        ]);
        $tecnico->assignRole('Técnico');

        $operador = User::create([
            'name' => 'Carlos Manuel Joaquim',
            'email' => 'carlos.joaquim@aranorteip.gov.mz',
            'password' => Hash::make('operador123'),
            'cargo' => 'Operador de Barragem',
            'departamento' => 'Operações',
            'provincia' => 'Nampula',
            'ativo' => true,
            'email_verified_at' => now(),
        ]);
        $operador->assignRole('Operador');
    }
}