@extends('layouts.app')

@section('title', 'Nova Divisao')

@section('content')
<div class="py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Nova Divisao Administrativa</h1>
                <p class="text-sm text-gray-600 mt-1">Criar nova provincia, distrito ou municipio</p>
            </div>
            <a href="{{ route('admin.admin.divisoes-admin.index') }}" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-arrow-left mr-1"></i> Voltar
            </a>
        </div>

        <form action="{{ route('admin.admin.divisoes-admin.store') }}" method="POST" class="space-y-6">
            @csrf

            <!-- Informacoes Basicas -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informacoes Basicas</h3>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Nome *</label>
                        <input type="text" name="nome" value="{{ old('nome') }}" required
                               placeholder="Ex: Maputo, Pemba, Metuge..."
                               class="w-full border-gray-300 rounded-md shadow-sm @error('nome') border-red-500 @enderror">
                        @error('nome')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Codigo *</label>
                        <input type="text" name="codigo" value="{{ old('codigo') }}" required
                               placeholder="Ex: MPT, PMB, MTG..."
                               class="w-full border-gray-300 rounded-md shadow-sm uppercase @error('codigo') border-red-500 @enderror">
                        @error('codigo')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                        <p class="text-xs text-gray-500 mt-1">Codigo unico de identificacao</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Tipo *</label>
                        <select name="tipo" id="tipo" required onchange="toggleParentField()"
                                class="w-full border-gray-300 rounded-md shadow-sm @error('tipo') border-red-500 @enderror">
                            <option value="">Seleccione...</option>
                            <option value="provincia" {{ old('tipo') == 'provincia' ? 'selected' : '' }}>Provincia</option>
                            <option value="distrito" {{ old('tipo') == 'distrito' ? 'selected' : '' }}>Distrito</option>
                            <option value="municipio" {{ old('tipo') == 'municipio' ? 'selected' : '' }}>Municipio</option>
                            <option value="setor" {{ old('tipo') == 'setor' ? 'selected' : '' }}>Setor</option>
                            <option value="zona" {{ old('tipo') == 'zona' ? 'selected' : '' }}>Zona</option>
                        </select>
                        @error('tipo')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div id="parent-field" class="{{ old('tipo') == 'provincia' ? 'hidden' : '' }}">
                        <label class="block text-sm font-medium text-gray-700 mb-1">Pertence a (Pai)</label>
                        <select name="parent_id"
                                class="w-full border-gray-300 rounded-md shadow-sm @error('parent_id') border-red-500 @enderror">
                            <option value="">Nenhum (Nivel Superior)</option>
                            @foreach($provincias as $prov)
                            <option value="{{ $prov->id }}" {{ old('parent_id', request('parent_id')) == $prov->id ? 'selected' : '' }}>
                                {{ $prov->nome }}
                            </option>
                            @endforeach
                        </select>
                        @error('parent_id')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Informacoes Geograficas -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informacoes Geograficas</h3>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Area (km2)</label>
                        <input type="number" name="area_km2" value="{{ old('area_km2') }}" step="0.01" min="0"
                               placeholder="0.00"
                               class="w-full border-gray-300 rounded-md shadow-sm @error('area_km2') border-red-500 @enderror">
                        @error('area_km2')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Populacao</label>
                        <input type="number" name="populacao" value="{{ old('populacao') }}" min="0"
                               placeholder="0"
                               class="w-full border-gray-300 rounded-md shadow-sm @error('populacao') border-red-500 @enderror">
                        @error('populacao')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Latitude</label>
                        <input type="number" name="latitude" value="{{ old('latitude') }}" step="0.000001"
                               placeholder="-15.000000"
                               class="w-full border-gray-300 rounded-md shadow-sm @error('latitude') border-red-500 @enderror">
                        @error('latitude')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Longitude</label>
                        <input type="number" name="longitude" value="{{ old('longitude') }}" step="0.000001"
                               placeholder="40.000000"
                               class="w-full border-gray-300 rounded-md shadow-sm @error('longitude') border-red-500 @enderror">
                        @error('longitude')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Informacoes Adicionais -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informacoes Adicionais</h3>

                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Descricao</label>
                        <textarea name="descricao" rows="3"
                                  placeholder="Descricao opcional da divisao..."
                                  class="w-full border-gray-300 rounded-md shadow-sm @error('descricao') border-red-500 @enderror">{{ old('descricao') }}</textarea>
                        @error('descricao')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="ativo" id="ativo" value="1"
                               {{ old('ativo', true) ? 'checked' : '' }}
                               class="rounded border-gray-300 text-blue-600">
                        <label for="ativo" class="ml-2 text-sm text-gray-700">Divisao activa</label>
                    </div>
                </div>
            </div>

            <!-- Botoes -->
            <div class="flex justify-end gap-3">
                <a href="{{ route('admin.admin.divisoes-admin.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 py-2 px-4 rounded-md">
                    Cancelar
                </a>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-6 rounded-md">
                    <i class="fas fa-save mr-1"></i> Criar Divisao
                </button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
function toggleParentField() {
    const tipo = document.getElementById('tipo').value;
    const parentField = document.getElementById('parent-field');

    if (tipo === 'provincia') {
        parentField.classList.add('hidden');
    } else {
        parentField.classList.remove('hidden');
    }
}
</script>
@endpush
@endsection
