@extends('layouts.app')

@section('title', 'Editar Divisao')

@section('content')
<div class="py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Editar Divisao</h1>
                <p class="text-sm text-gray-600 mt-1">{{ $divisao->nome }} ({{ $divisao->codigo }})</p>
            </div>
            <a href="{{ route('admin.admin.divisoes-admin.index') }}" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-arrow-left mr-1"></i> Voltar
            </a>
        </div>

        @if(session('error'))
        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
            {{ session('error') }}
        </div>
        @endif

        <form action="{{ route('admin.admin.divisoes-admin.update', $divisao) }}" method="POST" class="space-y-6">
            @csrf
            @method('PUT')

            <!-- Informacoes Basicas -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informacoes Basicas</h3>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Nome *</label>
                        <input type="text" name="nome" value="{{ old('nome', $divisao->nome) }}" required
                               class="w-full border-gray-300 rounded-md shadow-sm @error('nome') border-red-500 @enderror">
                        @error('nome')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Codigo *</label>
                        <input type="text" name="codigo" value="{{ old('codigo', $divisao->codigo) }}" required
                               class="w-full border-gray-300 rounded-md shadow-sm uppercase @error('codigo') border-red-500 @enderror">
                        @error('codigo')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Tipo *</label>
                        <select name="tipo" id="tipo" required onchange="toggleParentField()"
                                class="w-full border-gray-300 rounded-md shadow-sm @error('tipo') border-red-500 @enderror">
                            <option value="provincia" {{ old('tipo', $divisao->tipo) == 'provincia' ? 'selected' : '' }}>Provincia</option>
                            <option value="distrito" {{ old('tipo', $divisao->tipo) == 'distrito' ? 'selected' : '' }}>Distrito</option>
                            <option value="municipio" {{ old('tipo', $divisao->tipo) == 'municipio' ? 'selected' : '' }}>Municipio</option>
                            <option value="setor" {{ old('tipo', $divisao->tipo) == 'setor' ? 'selected' : '' }}>Setor</option>
                            <option value="zona" {{ old('tipo', $divisao->tipo) == 'zona' ? 'selected' : '' }}>Zona</option>
                        </select>
                        @error('tipo')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div id="parent-field" class="{{ old('tipo', $divisao->tipo) == 'provincia' ? 'hidden' : '' }}">
                        <label class="block text-sm font-medium text-gray-700 mb-1">Pertence a (Pai)</label>
                        <select name="parent_id"
                                class="w-full border-gray-300 rounded-md shadow-sm @error('parent_id') border-red-500 @enderror">
                            <option value="">Nenhum (Nivel Superior)</option>
                            @foreach($provincias as $prov)
                            <option value="{{ $prov->id }}" {{ old('parent_id', $divisao->parent_id) == $prov->id ? 'selected' : '' }}>
                                {{ $prov->nome }}
                            </option>
                            @endforeach
                        </select>
                        @error('parent_id')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Informacoes Geograficas -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informacoes Geograficas</h3>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Area (km2)</label>
                        <input type="number" name="area_km2" value="{{ old('area_km2', $divisao->area_km2) }}" step="0.01" min="0"
                               class="w-full border-gray-300 rounded-md shadow-sm @error('area_km2') border-red-500 @enderror">
                        @error('area_km2')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Populacao</label>
                        <input type="number" name="populacao" value="{{ old('populacao', $divisao->populacao) }}" min="0"
                               class="w-full border-gray-300 rounded-md shadow-sm @error('populacao') border-red-500 @enderror">
                        @error('populacao')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Latitude</label>
                        <input type="number" name="latitude" value="{{ old('latitude', $divisao->latitude) }}" step="0.000001"
                               class="w-full border-gray-300 rounded-md shadow-sm @error('latitude') border-red-500 @enderror">
                        @error('latitude')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Longitude</label>
                        <input type="number" name="longitude" value="{{ old('longitude', $divisao->longitude) }}" step="0.000001"
                               class="w-full border-gray-300 rounded-md shadow-sm @error('longitude') border-red-500 @enderror">
                        @error('longitude')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Informacoes Adicionais -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informacoes Adicionais</h3>

                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Descricao</label>
                        <textarea name="descricao" rows="3"
                                  class="w-full border-gray-300 rounded-md shadow-sm @error('descricao') border-red-500 @enderror">{{ old('descricao', $divisao->descricao) }}</textarea>
                        @error('descricao')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="ativo" id="ativo" value="1"
                               {{ old('ativo', $divisao->ativo) ? 'checked' : '' }}
                               class="rounded border-gray-300 text-blue-600">
                        <label for="ativo" class="ml-2 text-sm text-gray-700">Divisao activa</label>
                    </div>
                </div>
            </div>

            <!-- Estatisticas -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Estatisticas</h3>

                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                    <div class="text-center p-3 bg-gray-50 rounded-lg">
                        <div class="text-2xl font-bold text-purple-600">{{ $divisao->children_count ?? 0 }}</div>
                        <div class="text-xs text-gray-500">Subdivisoes</div>
                    </div>
                    <div class="text-center p-3 bg-gray-50 rounded-lg">
                        <div class="text-2xl font-bold text-blue-600">{{ $divisao->users_count ?? 0 }}</div>
                        <div class="text-xs text-gray-500">Utilizadores</div>
                    </div>
                    <div class="text-center p-3 bg-gray-50 rounded-lg">
                        <div class="text-2xl font-bold text-green-600">{{ $divisao->barragens_count ?? 0 }}</div>
                        <div class="text-xs text-gray-500">Barragens</div>
                    </div>
                    <div class="text-center p-3 bg-gray-50 rounded-lg">
                        <div class="text-2xl font-bold text-orange-600">{{ $divisao->estacoes_count ?? 0 }}</div>
                        <div class="text-xs text-gray-500">Estacoes</div>
                    </div>
                </div>
            </div>

            <!-- Botoes -->
            <div class="flex justify-between">
                @if($divisao->children()->count() == 0 && $divisao->users()->count() == 0 && $divisao->barragens()->count() == 0)
                <form action="{{ route('admin.admin.divisoes-admin.destroy', $divisao) }}" method="POST"
                      onsubmit="return confirm('Tem certeza que deseja eliminar esta divisao?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white py-2 px-4 rounded-md">
                        <i class="fas fa-trash mr-1"></i> Eliminar
                    </button>
                </form>
                @else
                <div></div>
                @endif

                <div class="flex gap-3">
                    <a href="{{ route('admin.admin.divisoes-admin.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 py-2 px-4 rounded-md">
                        Cancelar
                    </a>
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-6 rounded-md">
                        <i class="fas fa-save mr-1"></i> Guardar Alteracoes
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
function toggleParentField() {
    const tipo = document.getElementById('tipo').value;
    const parentField = document.getElementById('parent-field');

    if (tipo === 'provincia') {
        parentField.classList.add('hidden');
    } else {
        parentField.classList.remove('hidden');
    }
}
</script>
@endpush
@endsection
