@extends('layouts.app')

@section('title', 'Gestao de Divisoes')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Divisões Administrativas</h1>
                <p class="text-sm text-gray-600 mt-1">Gerir províncias, distritos e subdivisões</p>
            </div>
            <a href="{{ route('admin.admin.divisoes-admin.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded-lg flex items-center gap-2">
                <i class="fas fa-plus"></i>
                Nova Divisão
            </a>
        </div>

        @if(session('success'))
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
            {{ session('success') }}
        </div>
        @endif

        @if(session('error'))
        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
            {{ session('error') }}
        </div>
        @endif

        <!-- Filtros -->
        <div class="bg-white rounded-lg shadow mb-6 p-4">
            <form action="{{ route('admin.admin.divisoes-admin.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Pesquisar</label>
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Nome ou codigo..."
                           class="w-full border-gray-300 rounded-md shadow-sm">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Tipo</label>
                    <select name="tipo" class="w-full border-gray-300 rounded-md shadow-sm">
                        <option value="">Todos</option>
                        <option value="provincia" {{ request('tipo') == 'provincia' ? 'selected' : '' }}>Provincia</option>
                        <option value="distrito" {{ request('tipo') == 'distrito' ? 'selected' : '' }}>Distrito</option>
                        <option value="municipio" {{ request('tipo') == 'municipio' ? 'selected' : '' }}>Municipio</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Provincia</label>
                    <select name="provincia_id" class="w-full border-gray-300 rounded-md shadow-sm">
                        <option value="">Todas</option>
                        @foreach($provincias as $prov)
                        <option value="{{ $prov->id }}" {{ request('provincia_id') == $prov->id ? 'selected' : '' }}>
                            {{ $prov->nome }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="flex items-end gap-2">
                    <button type="submit" class="bg-gray-600 hover:bg-gray-700 text-white py-2 px-4 rounded-md">
                        <i class="fas fa-search mr-1"></i> Filtrar
                    </button>
                    <a href="{{ route('admin.admin.divisoes-admin.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 py-2 px-4 rounded-md">
                        Limpar
                    </a>
                </div>
            </form>
        </div>

        <!-- Tabela -->
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Divisao</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tipo</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Pai</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Subdivisoes</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Utilizadores</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Accoes</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($divisoes as $divisao)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <div class="flex-shrink-0 h-10 w-10">
                                    <div class="h-10 w-10 rounded-lg flex items-center justify-center text-white font-bold
                                        {{ $divisao->tipo == 'provincia' ? 'bg-purple-500' : ($divisao->tipo == 'distrito' ? 'bg-blue-500' : 'bg-green-500') }}">
                                        <i class="fas {{ $divisao->tipo == 'provincia' ? 'fa-map' : 'fa-map-marker-alt' }}"></i>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900">{{ $divisao->nome }}</div>
                                    <div class="text-xs text-gray-500">{{ $divisao->codigo }}</div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium capitalize
                                {{ $divisao->tipo == 'provincia' ? 'bg-purple-100 text-purple-800' : ($divisao->tipo == 'distrito' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800') }}">
                                {{ $divisao->tipo }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-500">
                            {{ $divisao->parent?->nome ?? '-' }}
                        </td>
                        <td class="px-6 py-4 text-center">
                            @if($divisao->children_count > 0)
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                {{ $divisao->children_count }}
                            </span>
                            @else
                            <span class="text-gray-400">-</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-center">
                            @if($divisao->users_count > 0)
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                {{ $divisao->users_count }}
                            </span>
                            @else
                            <span class="text-gray-400">-</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-center">
                            @if($divisao->ativo)
                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-green-100 text-green-800">
                                Activo
                            </span>
                            @else
                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800">
                                Inactivo
                            </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-right">
                            <div class="flex justify-end gap-2">
                                <a href="{{ route('admin.admin.divisoes-admin.show', $divisao) }}" class="text-blue-600 hover:text-blue-900" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.admin.divisoes-admin.edit', $divisao) }}" class="text-yellow-600 hover:text-yellow-900" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="px-6 py-12 text-center text-gray-500">
                            <i class="fas fa-map-marked-alt text-4xl mb-4"></i>
                            <p>Nenhuma divisao encontrada</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>

            @if($divisoes->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $divisoes->withQueryString()->links() }}
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
