@extends('layouts.app')

@section('title', 'Permissoes por Divisao')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Permissoes por Divisao</h1>
                <p class="text-sm text-gray-600 mt-1">Configurar permissoes customizadas para cada divisao administrativa</p>
            </div>
            <a href="{{ route('admin.roles.index') }}" class="bg-gray-600 hover:bg-gray-700 text-white font-medium py-2 px-4 rounded-lg flex items-center gap-2">
                <i class="fas fa-arrow-left"></i>
                Voltar
            </a>
        </div>

        <!-- Info -->
        <div class="mb-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
            <div class="flex items-start">
                <i class="fas fa-info-circle text-blue-500 mr-3 mt-0.5"></i>
                <div class="text-sm text-blue-800">
                    <p class="font-medium mb-1">Como funciona?</p>
                    <p>Cada divisao pode ter permissoes customizadas que sobrepoe as permissoes globais dos roles. Por exemplo, um Operador pode ter permissao para "criar-barragem" apenas na sua divisao, mesmo que o role global nao tenha essa permissao.</p>
                </div>
            </div>
        </div>

        <!-- Lista de Divisoes -->
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Divisao</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tipo</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Overrides</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Accoes</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($divisoes as $divisao)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <div class="flex-shrink-0 h-10 w-10">
                                    <div class="h-10 w-10 rounded-lg flex items-center justify-center text-white font-bold
                                        {{ $divisao->tipo == 'provincia' ? 'bg-purple-500' : ($divisao->tipo == 'distrito' ? 'bg-blue-500' : 'bg-green-500') }}">
                                        <i class="fas {{ $divisao->tipo == 'provincia' ? 'fa-map' : 'fa-map-marker-alt' }}"></i>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900">{{ $divisao->nome }}</div>
                                    <div class="text-xs text-gray-500">{{ $divisao->codigo }}</div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium capitalize
                                {{ $divisao->tipo == 'provincia' ? 'bg-purple-100 text-purple-800' : ($divisao->tipo == 'distrito' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800') }}">
                                {{ $divisao->tipo }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-center">
                            @if($divisao->role_permissions_count > 0)
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                {{ $divisao->role_permissions_count }} override(s)
                            </span>
                            @else
                            <span class="text-gray-400 text-sm">Nenhum</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-right">
                            <a href="{{ route('admin.divisoes.permissions.show', $divisao) }}"
                               class="text-blue-600 hover:text-blue-900 font-medium text-sm">
                                <i class="fas fa-cog mr-1"></i> Configurar
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="px-6 py-12 text-center text-gray-500">
                            <i class="fas fa-map-marked-alt text-4xl mb-4"></i>
                            <p>Nenhuma divisao encontrada</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>

            @if($divisoes->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $divisoes->links() }}
            </div>
            @endif
        </div>

        <!-- Legenda -->
        <div class="mt-6 bg-gray-50 rounded-lg p-4">
            <h4 class="text-sm font-medium text-gray-700 mb-2">Legenda</h4>
            <div class="flex gap-6 text-sm text-gray-600">
                <span class="flex items-center gap-2">
                    <span class="w-4 h-4 rounded bg-green-500"></span>
                    Grant - Concede permissao extra
                </span>
                <span class="flex items-center gap-2">
                    <span class="w-4 h-4 rounded bg-red-500"></span>
                    Revoke - Remove permissao nesta divisao
                </span>
            </div>
        </div>
    </div>
</div>
@endsection
