@extends('layouts.app')

@section('title', 'Novo Perfil')

@section('content')
<div class="py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Novo Perfil</h1>
                <p class="text-sm text-gray-600 mt-1">Criar novo perfil com permissões personalizadas</p>
            </div>
            <a href="{{ route('admin.roles.index') }}" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-arrow-left mr-1"></i> Voltar
            </a>
        </div>

        <form action="{{ route('admin.roles.store') }}" method="POST" class="space-y-6">
            @csrf

            <!-- Nome do Perfil -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informações do Perfil</h3>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Nome do Perfil *</label>
                    <input type="text" name="name" value="{{ old('name') }}" required
                           placeholder="Ex: Supervisor Regional"
                           class="w-full border-gray-300 rounded-md shadow-sm @error('name') border-red-500 @enderror">
                    @error('name')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Permissões -->
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-medium text-gray-900">Permissões</h3>
                    <div class="text-sm text-gray-500">
                        <button type="button" onclick="selectAll()" class="text-blue-600 hover:underline mr-4">Seleccionar Todas</button>
                        <button type="button" onclick="deselectAll()" class="text-gray-600 hover:underline">Desmarcar Todas</button>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($permissoesPorCategoria as $categoria => $perms)
                    <div class="border rounded-lg p-4">
                        <div class="flex items-center justify-between mb-3">
                            <h4 class="font-medium text-gray-700 capitalize">
                                <i class="fas fa-folder mr-2 text-blue-500"></i>
                                {{ $categoria }}
                            </h4>
                            <button type="button" onclick="toggleCategoria('{{ $categoria }}')" class="text-xs text-blue-600 hover:underline">
                                Toggle
                            </button>
                        </div>
                        <div class="space-y-2" data-categoria="{{ $categoria }}">
                            @foreach($perms as $permission)
                            <label class="flex items-center cursor-pointer hover:bg-gray-50 p-1 rounded">
                                <input type="checkbox" name="permissions[]" value="{{ $permission->id }}"
                                       class="permission-checkbox rounded border-gray-300 text-blue-600"
                                       {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                <span class="ml-2 text-sm text-gray-600">{{ $permission->name }}</span>
                            </label>
                            @endforeach
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Botoes -->
            <div class="flex justify-end gap-3">
                <a href="{{ route('admin.roles.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 py-2 px-4 rounded-md">
                    Cancelar
                </a>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-6 rounded-md">
                    <i class="fas fa-save mr-1"></i> Criar Perfil
                </button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
function selectAll() {
    document.querySelectorAll('.permission-checkbox').forEach(cb => cb.checked = true);
}

function deselectAll() {
    document.querySelectorAll('.permission-checkbox').forEach(cb => cb.checked = false);
}

function toggleCategoria(categoria) {
    const container = document.querySelector(`[data-categoria="${categoria}"]`);
    const checkboxes = container.querySelectorAll('.permission-checkbox');
    const allChecked = Array.from(checkboxes).every(cb => cb.checked);

    checkboxes.forEach(cb => cb.checked = !allChecked);
}
</script>
@endpush
@endsection
