@extends('layouts.app')

@section('title', 'Editar Perfil')

@section('content')
<div class="py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Editar Perfil</h1>
                <p class="text-sm text-gray-600 mt-1">{{ $role->name }}</p>
            </div>
            <a href="{{ route('admin.roles.index') }}" class="text-gray-600 hover:text-gray-900">
                <i class="fas fa-arrow-left mr-1"></i> Voltar
            </a>
        </div>

        @if($role->name === 'Administrador')
        <div class="mb-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
            <i class="fas fa-exclamation-triangle mr-2"></i>
            O perfil Administrador não pode ser editado.
        </div>
        @endif

        <form action="{{ route('admin.roles.update', $role) }}" method="POST" class="space-y-6">
            @csrf
            @method('PUT')

            <!-- Nome do Perfil -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Informações do Perfil</h3>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Nome do Perfil *</label>
                    <input type="text" name="name" value="{{ old('name', $role->name) }}" required
                           {{ $role->name === 'Administrador' ? 'disabled' : '' }}
                           class="w-full border-gray-300 rounded-md shadow-sm @error('name') border-red-500 @enderror {{ $role->name === 'Administrador' ? 'bg-gray-100' : '' }}">
                    @error('name')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mt-4 text-sm text-gray-500">
                    <i class="fas fa-users mr-1"></i>
                    {{ $role->users()->count() }} utilizador(es) com este perfil
                </div>
            </div>

            <!-- Permissões -->
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-medium text-gray-900">Permissões</h3>
                    @if($role->name !== 'Administrador')
                    <div class="text-sm text-gray-500">
                        <button type="button" onclick="selectAll()" class="text-blue-600 hover:underline mr-4">Seleccionar Todas</button>
                        <button type="button" onclick="deselectAll()" class="text-gray-600 hover:underline">Desmarcar Todas</button>
                    </div>
                    @endif
                </div>

                @if($role->name === 'Administrador')
                <p class="text-gray-600 italic">
                    <i class="fas fa-shield-alt text-red-500 mr-2"></i>
                    O perfil Administrador tem automaticamente todas as permissões.
                </p>
                @else
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($permissoesPorCategoria as $categoria => $perms)
                    <div class="border rounded-lg p-4">
                        <div class="flex items-center justify-between mb-3">
                            <h4 class="font-medium text-gray-700 capitalize">
                                <i class="fas fa-folder mr-2 text-blue-500"></i>
                                {{ $categoria }}
                            </h4>
                            <button type="button" onclick="toggleCategoria('{{ $categoria }}')" class="text-xs text-blue-600 hover:underline">
                                Toggle
                            </button>
                        </div>
                        <div class="space-y-2" data-categoria="{{ $categoria }}">
                            @foreach($perms as $permission)
                            <label class="flex items-center cursor-pointer hover:bg-gray-50 p-1 rounded">
                                <input type="checkbox" name="permissions[]" value="{{ $permission->id }}"
                                       class="permission-checkbox rounded border-gray-300 text-blue-600"
                                       {{ $role->hasPermissionTo($permission->name) ? 'checked' : '' }}>
                                <span class="ml-2 text-sm text-gray-600">{{ $permission->name }}</span>
                            </label>
                            @endforeach
                        </div>
                    </div>
                    @endforeach
                </div>
                @endif
            </div>

            <!-- Botões -->
            @if($role->name !== 'Administrador')
            <div class="flex justify-between">
                <form action="{{ route('admin.roles.destroy', $role) }}" method="POST"
                      onsubmit="return confirm('Tem certeza que deseja eliminar este perfil?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white py-2 px-4 rounded-md">
                        <i class="fas fa-trash mr-1"></i> Eliminar Perfil
                    </button>
                </form>

                <div class="flex gap-3">
                    <a href="{{ route('admin.roles.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 py-2 px-4 rounded-md">
                        Cancelar
                    </a>
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white py-2 px-6 rounded-md">
                        <i class="fas fa-save mr-1"></i> Guardar Alterações
                    </button>
                </div>
            </div>
            @else
            <div class="flex justify-end">
                <a href="{{ route('admin.roles.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 py-2 px-4 rounded-md">
                    Voltar
                </a>
            </div>
            @endif
        </form>
    </div>
</div>

@push('scripts')
<script>
function selectAll() {
    document.querySelectorAll('.permission-checkbox').forEach(cb => cb.checked = true);
}

function deselectAll() {
    document.querySelectorAll('.permission-checkbox').forEach(cb => cb.checked = false);
}

function toggleCategoria(categoria) {
    const container = document.querySelector(`[data-categoria="${categoria}"]`);
    const checkboxes = container.querySelectorAll('.permission-checkbox');
    const allChecked = Array.from(checkboxes).every(cb => cb.checked);

    checkboxes.forEach(cb => cb.checked = !allChecked);
}
</script>
@endpush
@endsection
