@extends('layouts.app')

@section('title', 'Gestão de Permissões')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Gestão de Permissões</h1>
                <p class="text-sm text-gray-600 mt-1">Criar e gerir perfis com as suas permissões</p>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('admin.roles.matrix') }}" class="bg-purple-600 hover:bg-purple-700 text-white font-medium py-2 px-4 rounded-lg flex items-center gap-2">
                    <i class="fas fa-th"></i>
                    Matriz Visual
                </a>
                <a href="{{ route('admin.roles.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded-lg flex items-center gap-2">
                    <i class="fas fa-plus"></i>
                    Novo Perfil
                </a>
            </div>
        </div>

        @if(session('success'))
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
            {{ session('success') }}
        </div>
        @endif

        @if(session('error'))
        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
            {{ session('error') }}
        </div>
        @endif

        <!-- Lista de Roles -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($roles as $role)
            <div class="bg-white rounded-lg shadow overflow-hidden">
                <div class="p-4 border-b {{ $role->name == 'Administrador' ? 'bg-red-50' : 'bg-gray-50' }}">
                    <div class="flex items-center justify-between">
                        <h3 class="text-lg font-semibold text-gray-900">{{ $role->name }}</h3>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                            @if($role->name == 'Administrador') bg-red-100 text-red-800
                            @elseif($role->name == 'Tecnico Senior') bg-purple-100 text-purple-800
                            @elseif($role->name == 'Tecnico') bg-blue-100 text-blue-800
                            @elseif($role->name == 'Operador') bg-green-100 text-green-800
                            @else bg-gray-100 text-gray-800
                            @endif">
                            {{ $role->permissions->count() }} permissões
                        </span>
                    </div>
                    <p class="text-sm text-gray-500 mt-1">
                        {{ $role->users()->count() }} utilizador(es)
                    </p>
                </div>

                <div class="p-4">
                    @if($role->name == 'Administrador')
                    <p class="text-sm text-gray-600 italic mb-3">
                        <i class="fas fa-shield-alt text-red-500 mr-1"></i>
                        Acesso total ao sistema
                    </p>
                    @else
                    <div class="space-y-1 max-h-32 overflow-y-auto">
                        @forelse($role->permissions->take(8) as $permission)
                        <span class="inline-flex items-center px-2 py-0.5 rounded text-xs bg-gray-100 text-gray-700 mr-1 mb-1">
                            {{ $permission->name }}
                        </span>
                        @empty
                        <p class="text-sm text-gray-400 italic">Sem permissões atribuídas</p>
                        @endforelse
                        @if($role->permissions->count() > 8)
                        <span class="text-xs text-gray-500">+{{ $role->permissions->count() - 8 }} mais...</span>
                        @endif
                    </div>
                    @endif
                </div>

                <div class="px-4 py-3 bg-gray-50 border-t flex justify-end gap-2">
                    <a href="{{ route('admin.roles.show', $role) }}" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                        <i class="fas fa-eye mr-1"></i> Ver
                    </a>
                    @if($role->name !== 'Administrador')
                    <a href="{{ route('admin.roles.edit', $role) }}" class="text-yellow-600 hover:text-yellow-800 text-sm font-medium">
                        <i class="fas fa-edit mr-1"></i> Editar
                    </a>
                    @endif
                </div>
            </div>
            @endforeach
        </div>

        <!-- Resumo de Permissões -->
        <div class="mt-8 bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Todas as Permissões Disponíveis</h3>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($permissoesPorCategoria as $categoria => $perms)
                <div class="border rounded-lg p-4">
                    <h4 class="font-medium text-gray-700 capitalize mb-2">
                        <i class="fas fa-folder mr-2 text-blue-500"></i>
                        {{ $categoria }}
                    </h4>
                    <div class="space-y-1">
                        @foreach($perms as $permission)
                        <div class="text-sm text-gray-600 flex items-center">
                            <i class="fas fa-key text-gray-400 mr-2 text-xs"></i>
                            {{ $permission->name }}
                        </div>
                        @endforeach
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection
