@extends('layouts.app')

@section('title', 'Acesso Regional - ' . $user->name)

@section('content')
<div class="py-6">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <div class="flex items-center">
                <div class="h-14 w-14 rounded-full bg-gradient-to-br from-blue-500 to-blue-600 flex items-center justify-center text-white text-2xl font-bold shadow-lg">
                    {{ strtoupper(substr($user->name, 0, 1)) }}
                </div>
                <div class="ml-4">
                    <h1 class="text-2xl font-bold text-gray-900">{{ $user->name }}</h1>
                    <div class="flex items-center gap-2 mt-1">
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                            {{ $user->getRoleNames()->first() ?? 'Sem role' }}
                        </span>
                        <span class="text-sm text-gray-500">{{ $user->email }}</span>
                    </div>
                </div>
            </div>
            <a href="{{ route('admin.usuarios.show', $user) }}" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg">
                <i class="fas fa-arrow-left mr-2"></i>Voltar
            </a>
        </div>

        @if(session('success'))
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        </div>
        @endif

        @if(session('error'))
        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        </div>
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Coluna Principal -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-xl shadow-sm border">
                    <!-- Header -->
                    <div class="p-5 border-b bg-gray-50 rounded-t-xl">
                        <h2 class="text-lg font-semibold text-gray-900">Regiões de Acesso</h2>
                        <p class="text-sm text-gray-500 mt-1">Divisões administrativas atribuídas ao utilizador</p>
                    </div>

                    <!-- Adicionar -->
                    <div class="p-4 border-b bg-blue-50">
                        <form action="{{ route('admin.usuarios.divisoes.store', $user) }}" method="POST" class="flex gap-3">
                            @csrf
                            <input type="hidden" name="nivel_acesso" value="full">
                            <select name="divisao_administrativa_id" required class="flex-1 border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Seleccionar divisão para adicionar...</option>
                                @foreach($divisoes as $tipo => $divs)
                                <optgroup label="{{ ucfirst($tipo) }}s">
                                    @foreach($divs as $div)
                                    <option value="{{ $div->id }}">{{ $div->nome }} ({{ $div->barragens_count ?? 0 }} barragens)</option>
                                    @endforeach
                                </optgroup>
                                @endforeach
                            </select>
                            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded-lg font-medium shadow-sm">
                                <i class="fas fa-plus mr-2"></i>Adicionar
                            </button>
                        </form>
                    </div>

                    <!-- Lista -->
                    @if($user->todasDivisoes->count() > 0)
                    <div class="divide-y divide-gray-100">
                        @foreach($user->todasDivisoes as $userDivisao)
                        @php
                            $div = $userDivisao->divisao;
                            $barragens = $div ? $div->barragens : collect();
                            $estacoes = $div ? $div->estacoes : collect();
                        @endphp
                        <div class="p-5 hover:bg-gray-50 transition-colors">
                            <div class="flex items-start justify-between">
                                <div class="flex items-start flex-1">
                                    <div class="h-12 w-12 rounded-xl flex items-center justify-center text-white shadow-sm
                                        {{ $div?->tipo == 'provincia' ? 'bg-gradient-to-br from-purple-500 to-purple-600' : 'bg-gradient-to-br from-blue-500 to-blue-600' }}">
                                        <i class="fas {{ $div?->tipo == 'provincia' ? 'fa-map' : 'fa-map-marker-alt' }} text-lg"></i>
                                    </div>
                                    <div class="ml-4 flex-1">
                                        <div class="flex items-center gap-2">
                                            <h3 class="font-semibold text-gray-900">{{ $div?->nome ?? 'Removida' }}</h3>
                                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium capitalize
                                                {{ $div?->tipo == 'provincia' ? 'bg-purple-100 text-purple-700' : 'bg-blue-100 text-blue-700' }}">
                                                {{ $div?->tipo ?? '' }}
                                            </span>
                                        </div>

                                        @if($barragens->count() > 0)
                                        <div class="mt-3">
                                            <div class="text-xs font-medium text-gray-500 uppercase mb-2">Barragens ({{ $barragens->count() }})</div>
                                            <div class="flex flex-wrap gap-2">
                                                @foreach($barragens->take(5) as $barragem)
                                                <span class="inline-flex items-center px-2.5 py-1 rounded-lg text-xs bg-blue-50 text-blue-700 border border-blue-200">
                                                    <i class="fas fa-water mr-1.5 text-blue-400"></i>{{ $barragem->nome }}
                                                </span>
                                                @endforeach
                                                @if($barragens->count() > 5)
                                                <span class="inline-flex items-center px-2.5 py-1 rounded-lg text-xs bg-gray-100 text-gray-600">
                                                    +{{ $barragens->count() - 5 }} mais
                                                </span>
                                                @endif
                                            </div>
                                        </div>
                                        @endif

                                        @if($estacoes->count() > 0)
                                        <div class="mt-2">
                                            <div class="text-xs font-medium text-gray-500 uppercase mb-2">Estações ({{ $estacoes->count() }})</div>
                                            <div class="flex flex-wrap gap-2">
                                                @foreach($estacoes->take(3) as $estacao)
                                                <span class="inline-flex items-center px-2.5 py-1 rounded-lg text-xs bg-green-50 text-green-700 border border-green-200">
                                                    <i class="fas fa-broadcast-tower mr-1.5 text-green-400"></i>{{ $estacao->nome }}
                                                </span>
                                                @endforeach
                                                @if($estacoes->count() > 3)
                                                <span class="inline-flex items-center px-2.5 py-1 rounded-lg text-xs bg-gray-100 text-gray-600">
                                                    +{{ $estacoes->count() - 3 }} mais
                                                </span>
                                                @endif
                                            </div>
                                        </div>
                                        @endif

                                        @if($barragens->count() == 0 && $estacoes->count() == 0)
                                        <p class="mt-2 text-sm text-gray-400 italic">Sem barragens ou estações nesta divisão</p>
                                        @endif
                                    </div>
                                </div>
                                <form action="{{ route('admin.usuarios.divisoes.destroy', [$user, $userDivisao]) }}" method="POST"
                                      onsubmit="return confirm('Remover acesso a {{ $div?->nome }}?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="ml-4 p-2 text-gray-400 hover:text-red-500 hover:bg-red-50 rounded-lg transition-colors" title="Remover">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="p-12 text-center">
                        <div class="w-16 h-16 mx-auto bg-gray-100 rounded-full flex items-center justify-center mb-4">
                            <i class="fas fa-map-marker-alt text-2xl text-gray-400"></i>
                        </div>
                        <h3 class="text-lg font-medium text-gray-900 mb-1">Sem divisões atribuídas</h3>
                        <p class="text-sm text-gray-500">Adicione uma divisão para dar acesso regional ao utilizador</p>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1 space-y-6">
                <!-- Resumo -->
                <div class="bg-white rounded-xl shadow-sm border p-5">
                    <h3 class="font-semibold text-gray-900 mb-4">Resumo de Acesso</h3>

                    @php
                        $totalBarragens = 0;
                        $totalEstacoes = 0;
                        foreach($user->todasDivisoes as $ud) {
                            if($ud->divisao) {
                                $totalBarragens += $ud->divisao->barragens->count();
                                $totalEstacoes += $ud->divisao->estacoes->count();
                            }
                        }
                    @endphp

                    <div class="space-y-3">
                        <div class="flex items-center justify-between p-3 bg-purple-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-map-marked-alt text-purple-500 mr-3"></i>
                                <span class="text-sm text-gray-700">Divisões</span>
                            </div>
                            <span class="text-lg font-bold text-purple-600">{{ $user->todasDivisoes->count() }}</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-blue-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-water text-blue-500 mr-3"></i>
                                <span class="text-sm text-gray-700">Barragens</span>
                            </div>
                            <span class="text-lg font-bold text-blue-600">{{ $totalBarragens }}</span>
                        </div>
                        <div class="flex items-center justify-between p-3 bg-green-50 rounded-lg">
                            <div class="flex items-center">
                                <i class="fas fa-broadcast-tower text-green-500 mr-3"></i>
                                <span class="text-sm text-gray-700">Estações</span>
                            </div>
                            <span class="text-lg font-bold text-green-600">{{ $totalEstacoes }}</span>
                        </div>
                    </div>
                </div>

                <!-- Info -->
                <div class="bg-blue-50 border border-blue-200 rounded-xl p-5">
                    <div class="flex items-start">
                        <i class="fas fa-info-circle text-blue-500 mt-0.5 mr-3"></i>
                        <div class="text-sm text-blue-800">
                            <p class="font-medium mb-1">Como funciona?</p>
                            <p>Atribuir uma <strong>província</strong> dá acesso automático a todos os seus distritos e respectivas barragens.</p>
                        </div>
                    </div>
                </div>

                <!-- Acções Rápidas -->
                <div class="bg-white rounded-xl shadow-sm border p-5">
                    <h3 class="font-semibold text-gray-900 mb-4">Acções</h3>
                    <div class="space-y-2">
                        <a href="{{ route('admin.usuarios.edit', $user) }}" class="flex items-center p-3 text-gray-700 hover:bg-gray-50 rounded-lg transition-colors">
                            <i class="fas fa-user-edit text-gray-400 mr-3 w-5"></i>
                            <span class="text-sm">Editar utilizador</span>
                        </a>
                        <a href="{{ route('admin.usuarios.index') }}" class="flex items-center p-3 text-gray-700 hover:bg-gray-50 rounded-lg transition-colors">
                            <i class="fas fa-users text-gray-400 mr-3 w-5"></i>
                            <span class="text-sm">Ver todos utilizadores</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
