@extends('layouts.app')

@section('title', 'Gestao de Utilizadores')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Gestao de Utilizadores</h1>
                <p class="text-sm text-gray-600 mt-1">Gerir utilizadores, roles e divisoes de acesso</p>
            </div>
            <a href="{{ route('admin.usuarios.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white font-medium py-2 px-4 rounded-lg flex items-center gap-2">
                <i class="fas fa-plus"></i>
                Novo Utilizador
            </a>
        </div>

        <!-- Alertas -->
        @if(session('success'))
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
            {{ session('success') }}
        </div>
        @endif

        @if(session('error'))
        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
            {{ session('error') }}
        </div>
        @endif

        <!-- Filtros -->
        <div class="bg-white rounded-lg shadow mb-6 p-4">
            <form action="{{ route('admin.usuarios.index') }}" method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Pesquisar</label>
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Nome, email, cargo..."
                           class="w-full border-gray-300 rounded-md shadow-sm">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Role</label>
                    <select name="role" class="w-full border-gray-300 rounded-md shadow-sm">
                        <option value="">Todos</option>
                        @foreach($roles as $role)
                        <option value="{{ $role->name }}" {{ request('role') == $role->name ? 'selected' : '' }}>
                            {{ $role->name }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                    <select name="ativo" class="w-full border-gray-300 rounded-md shadow-sm">
                        <option value="">Todos</option>
                        <option value="sim" {{ request('ativo') == 'sim' ? 'selected' : '' }}>Activos</option>
                        <option value="nao" {{ request('ativo') == 'nao' ? 'selected' : '' }}>Inactivos</option>
                    </select>
                </div>
                <div class="flex items-end gap-2">
                    <button type="submit" class="bg-gray-600 hover:bg-gray-700 text-white py-2 px-4 rounded-md">
                        <i class="fas fa-search mr-1"></i> Filtrar
                    </button>
                    <a href="{{ route('admin.usuarios.index') }}" class="bg-gray-200 hover:bg-gray-300 text-gray-700 py-2 px-4 rounded-md">
                        Limpar
                    </a>
                </div>
            </form>
        </div>

        <!-- Tabela de Utilizadores -->
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Utilizador</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Roles</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Divisoes</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Accoes</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($users as $user)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="flex-shrink-0 h-10 w-10">
                                    <div class="h-10 w-10 rounded-full bg-blue-500 flex items-center justify-center text-white font-bold">
                                        {{ strtoupper(substr($user->name, 0, 1)) }}
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900">{{ $user->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $user->email }}</div>
                                    @if($user->cargo)
                                    <div class="text-xs text-gray-400">{{ $user->cargo }}</div>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex flex-wrap gap-1">
                                @foreach($user->roles as $role)
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium
                                    @if($role->name == 'Administrador') bg-red-100 text-red-800
                                    @elseif($role->name == 'Tecnico Senior') bg-purple-100 text-purple-800
                                    @elseif($role->name == 'Tecnico') bg-blue-100 text-blue-800
                                    @elseif($role->name == 'Operador') bg-green-100 text-green-800
                                    @else bg-gray-100 text-gray-800
                                    @endif">
                                    {{ $role->name }}
                                </span>
                                @endforeach
                                @if($user->acesso_global)
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-yellow-100 text-yellow-800">
                                    <i class="fas fa-globe mr-1"></i> Global
                                </span>
                                @endif
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            @if($user->acesso_global)
                            <span class="text-yellow-600 text-sm">
                                <i class="fas fa-globe mr-1"></i> Acesso a todas divisoes
                            </span>
                            @elseif($user->divisoesAtivas->count() > 0)
                            <div class="flex flex-wrap gap-1">
                                @foreach($user->divisoesAtivas->take(3) as $userDivisao)
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-blue-100 text-blue-800">
                                    {{ $userDivisao->divisao?->nome ?? 'N/A' }}
                                </span>
                                @endforeach
                                @if($user->divisoesAtivas->count() > 3)
                                <span class="text-gray-500 text-xs">+{{ $user->divisoesAtivas->count() - 3 }} mais</span>
                                @endif
                            </div>
                            @else
                            <span class="text-gray-400 text-sm italic">Sem divisoes</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($user->ativo)
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                <span class="w-2 h-2 mr-1 bg-green-400 rounded-full"></span>
                                Activo
                            </span>
                            @else
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                <span class="w-2 h-2 mr-1 bg-red-400 rounded-full"></span>
                                Inactivo
                            </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <div class="flex justify-end gap-2">
                                <a href="{{ route('admin.usuarios.show', $user) }}" class="text-blue-600 hover:text-blue-900" title="Ver detalhes">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.usuarios.divisoes.show', $user) }}" class="text-green-600 hover:text-green-900" title="Gerir divisoes">
                                    <i class="fas fa-map-marker-alt"></i>
                                </a>
                                <a href="{{ route('admin.usuarios.edit', $user) }}" class="text-yellow-600 hover:text-yellow-900" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @if($user->id !== auth()->id())
                                <form action="{{ route('admin.usuarios.destroy', $user) }}" method="POST" class="inline"
                                      onsubmit="return confirm('Tem certeza que deseja eliminar este utilizador?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-900" title="Eliminar">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center text-gray-500">
                            <i class="fas fa-users text-4xl mb-4"></i>
                            <p>Nenhum utilizador encontrado</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>

            <!-- Paginacao -->
            @if($users->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $users->withQueryString()->links() }}
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
