@extends('layouts.app')

@section('title', 'Bacias Hidrográficas')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-water mr-3 text-cyan-600"></i>
                    Bacias Hidrográficas
                </h1>
                <p class="text-gray-600 mt-2">Gerir todas as bacias hidrográficas do sistema</p>
            </div>
            <div class="flex space-x-4">
                <a href="{{ route('bacias.create') }}" 
                   class="bg-cyan-600 text-white px-4 py-2 rounded-md hover:bg-cyan-700 transition-colors">
                    <i class="fas fa-plus mr-2"></i>
                    Nova Bacia
                </a>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow">
        <div class="p-6">
            <form method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Buscar</label>
                    <input type="text" name="search" value="{{ request('search') }}" 
                           placeholder="Nome ou código da bacia"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Província</label>
                    <input type="text" name="provincia" value="{{ request('provincia') }}" 
                           placeholder="Província"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-cyan-500">
                </div>
                <div class="flex items-end">
                    <button type="submit" class="w-full bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 transition-colors">
                        <i class="fas fa-search mr-2"></i>
                        Filtrar
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Bacias Table -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">
                Lista de Bacias Hidrográficas ({{ $bacias->total() }})
            </h3>
        </div>
        
        @if($bacias->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full table-fixed divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="w-1/4 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Bacia & Código</th>
                            <th class="w-1/5 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Características Físicas</th>
                            <th class="w-1/5 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Abrangência</th>
                            <th class="w-1/5 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Monitoramento</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($bacias as $bacia)
                        <tr class="hover:bg-gray-50">
                            <td class="w-1/4 px-6 py-4 break-words">
                                <div class="flex items-center">
                                    <div class="w-10 h-10 bg-cyan-100 rounded-full flex items-center justify-center">
                                        <i class="fas fa-water text-cyan-600"></i>
                                    </div>
                                    <div class="ml-4 min-w-0 flex-1">
                                        <div class="text-sm font-medium text-gray-900">
                                            <a href="{{ route('bacias.show', $bacia) }}" 
                                               class="hover:text-cyan-600">
                                                {{ $bacia->nome }}
                                            </a>
                                        </div>
                                        <div class="text-sm text-gray-500">{{ $bacia->codigo }}</div>
                                        @if($bacia->descricao)
                                            <div class="text-xs text-gray-600 mt-1 line-clamp-2">
                                                {{ Str::limit($bacia->descricao, 80) }}
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            
                            <td class="w-1/5 px-6 py-4 break-words">
                                <div class="space-y-2">
                                    @if($bacia->area_km2)
                                        <div class="text-xs text-blue-700 bg-blue-100 px-2 py-1 rounded">
                                            <i class="fas fa-expand-arrows-alt mr-1"></i>
                                            {{ number_format($bacia->area_km2, 0) }} km² área
                                        </div>
                                    @endif
                                    @if($bacia->comprimento_rio_principal)
                                        <div class="text-xs text-green-700 bg-green-100 px-2 py-1 rounded">
                                            <i class="fas fa-route mr-1"></i>
                                            {{ number_format($bacia->comprimento_rio_principal, 0) }} km rio principal
                                        </div>
                                    @endif
                                </div>
                            </td>

                            <td class="w-1/5 px-6 py-4 break-words">
                                <div class="space-y-1">
                                    @if($bacia->provincias_abrangidas && count($bacia->provincias_abrangidas) > 0)
                                        @foreach($bacia->provincias_abrangidas as $provincia)
                                            <div class="text-xs text-gray-700 bg-gray-100 px-2 py-1 rounded inline-block mr-1 mb-1">
                                                <i class="fas fa-map-marker-alt mr-1"></i>{{ $provincia }}
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                            </td>
                            
                            <td class="w-1/5 px-6 py-4 break-words">
                                <div class="space-y-2">
                                    <div class="flex items-center space-x-4">
                                        <div class="text-sm text-gray-900">
                                            <i class="fas fa-dam text-blue-500 mr-1"></i>
                                            {{ $bacia->barragens_count }} barragens
                                        </div>
                                    </div>
                                    <div class="flex items-center space-x-4">
                                        <div class="text-sm text-gray-900">
                                            <i class="fas fa-satellite-dish text-green-500 mr-1"></i>
                                            {{ $bacia->estacoes_count }} estações
                                        </div>
                                    </div>
                                    @php
                                        $total = $bacia->barragens_count + $bacia->estacoes_count;
                                        $statusClass = 'bg-gray-100 text-gray-800';
                                        $statusText = 'Sem monitoramento';
                                        if ($total >= 5) {
                                            $statusClass = 'bg-green-100 text-green-800';
                                            $statusText = 'Bem monitorada';
                                        } elseif ($total >= 2) {
                                            $statusClass = 'bg-yellow-100 text-yellow-800';
                                            $statusText = 'Monitoramento básico';
                                        } elseif ($total >= 1) {
                                            $statusClass = 'bg-orange-100 text-orange-800';
                                            $statusText = 'Pouco monitorada';
                                        }
                                    @endphp
                                    <div class="text-xs {{ $statusClass }} px-2 py-1 rounded">
                                        <i class="fas fa-signal mr-1"></i>
                                        {{ $statusText }}
                                    </div>
                                </div>
                            </td>
                            
                            <td class="w-1/6 px-6 py-4 text-sm font-medium break-words">
                                <div class="space-y-2">
                                    <!-- Ações Principais -->
                                    <div class="flex items-center space-x-1">
                                        <a href="{{ route('bacias.show', $bacia) }}"
                                           class="inline-flex items-center px-2 py-1 border border-transparent text-xs leading-4 font-medium rounded text-white bg-blue-600 hover:bg-blue-700 transition-colors"
                                           title="Visualizar detalhes">
                                            <i class="fas fa-eye mr-1"></i>
                                            Ver
                                        </a>
                                        <a href="{{ route('bacias.edit', $bacia) }}"
                                           class="inline-flex items-center px-2 py-1 border border-transparent text-xs leading-4 font-medium rounded text-white bg-green-600 hover:bg-green-700 transition-colors"
                                           title="Editar">
                                            <i class="fas fa-edit mr-1"></i>
                                            Editar
                                        </a>
                                    </div>

                                    <!-- Dropdown para mais ações -->
                                    <div class="relative">
                                        <button onclick="toggleDropdown('actions-{{ $bacia->id }}')"
                                                class="inline-flex items-center px-2 py-1 border border-gray-300 text-xs leading-4 font-medium rounded text-gray-700 bg-white hover:bg-gray-50 transition-colors w-full justify-center">
                                            <i class="fas fa-ellipsis-h mr-1"></i>
                                            Mais
                                        </button>
                                        <div id="actions-{{ $bacia->id }}" class="hidden absolute right-0 mt-1 w-48 bg-white rounded-md shadow-lg z-10 border">
                                            <div class="py-1">
                                                <a href="#" class="block px-4 py-2 text-xs text-gray-700 hover:bg-gray-100">
                                                    <i class="fas fa-chart-bar mr-2"></i>
                                                    Relatório da bacia
                                                </a>
                                                <a href="#" class="block px-4 py-2 text-xs text-gray-700 hover:bg-gray-100">
                                                    <i class="fas fa-map mr-2"></i>
                                                    Ver no mapa
                                                </a>
                                                <div class="border-t border-gray-100">
                                                    <form method="POST" action="{{ route('bacias.destroy', $bacia) }}" 
                                                          class="inline w-full" onsubmit="return confirm('Tem certeza que deseja excluir esta bacia hidrográfica?')">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="block w-full text-left px-4 py-2 text-xs text-red-700 hover:bg-red-50">
                                                            <i class="fas fa-trash mr-2"></i>
                                                            Excluir bacia
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            @if($bacias->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $bacias->withQueryString()->links() }}
            </div>
            @endif
        @else
            <div class="text-center py-12">
                <div class="w-24 h-24 bg-gradient-to-br from-cyan-100 to-cyan-200 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <i class="fas fa-water text-4xl text-cyan-600"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Nenhuma bacia hidrográfica encontrada</h3>
                <p class="text-gray-500 mb-6 max-w-md mx-auto">
                    @if(request()->filled('search') || request()->filled('provincia'))
                        Nenhuma bacia corresponde aos filtros aplicados. Tente ajustar os critérios de busca.
                    @else
                        Comece adicionando sua primeira bacia hidrográfica ao sistema.
                    @endif
                </p>
                <div class="flex flex-col sm:flex-row gap-3 justify-center">
                    @if(request()->filled('search') || request()->filled('provincia'))
                        <a href="{{ route('bacias.index') }}" 
                           class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 transition-colors">
                            <i class="fas fa-times mr-2"></i>
                            Limpar Filtros
                        </a>
                    @endif
                    <a href="{{ route('bacias.create') }}" 
                       class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-cyan-600 hover:bg-cyan-700 transition-colors">
                        <i class="fas fa-plus mr-2"></i>
                        Adicionar Bacia
                    </a>
                </div>
            </div>
        @endif
    </div>
</div>

<script>
function toggleDropdown(dropdownId) {
    const dropdown = document.getElementById(dropdownId);
    const isHidden = dropdown.classList.contains('hidden');
    
    // Fechar todos os outros dropdowns
    document.querySelectorAll('[id^="actions-"]').forEach(el => {
        if (el.id !== dropdownId) {
            el.classList.add('hidden');
        }
    });
    
    // Toggle do dropdown atual
    if (isHidden) {
        dropdown.classList.remove('hidden');
    } else {
        dropdown.classList.add('hidden');
    }
}

// Fechar dropdown ao clicar fora
document.addEventListener('click', function(event) {
    if (!event.target.closest('[onclick*="toggleDropdown"]') && !event.target.closest('[id^="actions-"]')) {
        document.querySelectorAll('[id^="actions-"]').forEach(el => {
            el.classList.add('hidden');
        });
    }
});
</script>
@endsection