@extends('layouts.app')

@section('title', $bacia->nome)

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">
                    <i class="fas fa-water mr-3 text-cyan-600"></i>
                    {{ $bacia->nome }}
                </h1>
                <p class="text-gray-600 mt-2">Código: {{ $bacia->codigo }}</p>
                @if($bacia->provincias_abrangidas && count($bacia->provincias_abrangidas) > 0)
                    <p class="text-sm text-gray-500 mt-1">
                        <i class="fas fa-map-marker-alt mr-1"></i>
                        {{ implode(', ', $bacia->provincias_abrangidas) }}
                    </p>
                @endif
            </div>
            <div class="flex space-x-4">
                <a href="{{ route('bacias.edit', $bacia) }}" 
                   class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors">
                    <i class="fas fa-edit mr-2"></i>
                    Editar
                </a>
                <a href="{{ route('bacias.index') }}" 
                   class="bg-gray-600 text-white px-4 py-2 rounded-md hover:bg-gray-700 transition-colors">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar à Lista
                </a>
            </div>
        </div>
    </div>

    <!-- Características da Bacia -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Características Físicas -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">
                <i class="fas fa-mountain text-green-600 mr-2"></i>
                Características Físicas
            </h3>
            <div class="space-y-4">
                @if($bacia->area_km2)
                    <div class="bg-blue-50 rounded-lg p-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <i class="fas fa-expand-arrows-alt text-blue-500 mr-2"></i>
                                <span class="text-sm text-gray-700">Área Total</span>
                            </div>
                            <span class="text-xl font-bold text-blue-600">{{ number_format($bacia->area_km2, 0) }}</span>
                        </div>
                        <div class="text-xs text-blue-600 mt-1">km²</div>
                    </div>
                @endif
                
                @if($bacia->comprimento_rio_principal)
                    <div class="bg-green-50 rounded-lg p-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <i class="fas fa-route text-green-500 mr-2"></i>
                                <span class="text-sm text-gray-700">Rio Principal</span>
                            </div>
                            <span class="text-xl font-bold text-green-600">{{ number_format($bacia->comprimento_rio_principal, 0) }}</span>
                        </div>
                        <div class="text-xs text-green-600 mt-1">km de extensão</div>
                    </div>
                @endif
                
                @if(!$bacia->area_km2 && !$bacia->comprimento_rio_principal)
                    <div class="text-center py-8">
                        <i class="fas fa-info-circle text-gray-300 text-3xl mb-2"></i>
                        <p class="text-gray-500 text-sm">Características físicas não informadas</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Abrangência Geográfica -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">
                <i class="fas fa-map-marked-alt text-purple-600 mr-2"></i>
                Abrangência Geográfica
            </h3>
            <div class="space-y-4">
                @if($bacia->provincias_abrangidas && count($bacia->provincias_abrangidas) > 0)
                    <div>
                        <p class="text-sm text-gray-600 mb-3">Províncias Abrangidas:</p>
                        <div class="grid grid-cols-1 gap-2">
                            @foreach($bacia->provincias_abrangidas as $provincia)
                                <div class="bg-purple-50 rounded-lg p-3 border border-purple-200">
                                    <div class="flex items-center">
                                        <i class="fas fa-map-marker-alt text-purple-500 mr-2"></i>
                                        <span class="text-sm font-medium text-purple-800">{{ $provincia }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-map text-gray-300 text-3xl mb-2"></i>
                        <p class="text-gray-500 text-sm">Abrangência geográfica não informada</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Monitoramento -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">
                <i class="fas fa-satellite-dish text-blue-600 mr-2"></i>
                Rede de Monitoramento
            </h3>
            <div class="space-y-4">
                <!-- Estatísticas -->
                <div class="grid grid-cols-2 gap-4">
                    <div class="bg-blue-50 rounded-lg p-4 text-center">
                        <div class="text-2xl font-bold text-blue-600 mb-1">-</div>
                        <div class="text-xs text-blue-700">Barragens</div>
                        <i class="fas fa-dam text-blue-500 mt-2"></i>
                    </div>
                    <div class="bg-green-50 rounded-lg p-4 text-center">
                        <div class="text-2xl font-bold text-green-600 mb-1">-</div>
                        <div class="text-xs text-green-700">Estações</div>
                        <i class="fas fa-satellite-dish text-green-500 mt-2"></i>
                    </div>
                </div>
                
                <!-- Status -->
                <div class="bg-gray-50 rounded-lg p-4">
                    <div class="text-center">
                        <i class="fas fa-info-circle text-gray-400 text-2xl mb-2"></i>
                        <div class="text-sm text-gray-600">Dados de monitoramento</div>
                        <div class="text-xs text-gray-500 mt-1">Em desenvolvimento</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Descrição -->
    @if($bacia->descricao)
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">
                <i class="fas fa-file-text text-gray-600 mr-2"></i>
                Descrição
            </h3>
            <div class="prose max-w-none">
                <p class="text-gray-700 leading-relaxed">{{ $bacia->descricao }}</p>
            </div>
        </div>
    @endif

    <!-- Ações Rápidas -->
    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">
            <i class="fas fa-tools text-orange-600 mr-2"></i>
            Ações Rápidas
        </h3>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <a href="{{ route('bacias.edit', $bacia) }}" 
               class="flex items-center justify-center px-4 py-3 bg-green-100 text-green-700 rounded-lg hover:bg-green-200 transition-colors">
                <i class="fas fa-edit mr-2"></i>
                Editar Bacia
            </a>
            <a href="{{ route('barragens.index', ['bacia_id' => $bacia->id]) }}"
               class="flex items-center justify-center px-4 py-3 bg-blue-100 text-blue-700 rounded-lg hover:bg-blue-200 transition-colors">
                <i class="fas fa-dam mr-2"></i>
                Ver Barragens
            </a>
            <a href="{{ route('estacoes.index', ['bacia_id' => $bacia->id]) }}"
               class="flex items-center justify-center px-4 py-3 bg-purple-100 text-purple-700 rounded-lg hover:bg-purple-200 transition-colors">
                <i class="fas fa-satellite-dish mr-2"></i>
                Ver Estações
            </a>
            <a href="{{ route('boletins.index', ['bacia_id' => $bacia->id]) }}"
               class="flex items-center justify-center px-4 py-3 bg-orange-100 text-orange-700 rounded-lg hover:bg-orange-200 transition-colors">
                <i class="fas fa-chart-bar mr-2"></i>
                Relatórios
            </a>
        </div>
    </div>

    <!-- Informações do Sistema -->
    <div class="bg-gray-50 rounded-lg p-4">
        <div class="flex items-center justify-between text-sm text-gray-500">
            <div>
                <i class="fas fa-calendar mr-1"></i>
                Criado em: {{ $bacia->created_at->format('d/m/Y H:i') }}
            </div>
            @if($bacia->updated_at != $bacia->created_at)
                <div>
                    <i class="fas fa-edit mr-1"></i>
                    Última atualização: {{ $bacia->updated_at->format('d/m/Y H:i') }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection