@extends('layouts.app')

@section('title', 'Leituras - ' . $barragem->nome)

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-lg shadow">
        <!-- Breadcrumb -->
        <div class="px-6 py-3 border-b border-gray-200 bg-gray-50">
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-1 md:space-x-3">
                    <li class="inline-flex items-center">
                        <a href="{{ route('dashboard') }}" class="text-gray-500 hover:text-gray-700">
                            <i class="fas fa-home mr-1"></i>
                            Dashboard
                        </a>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('barragens.index') }}" class="text-gray-500 hover:text-gray-700">Barragens</a>
                        </div>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <a href="{{ route('barragens.show', $barragem) }}" class="text-gray-500 hover:text-gray-700">{{ $barragem->nome }}</a>
                        </div>
                    </li>
                    <li aria-current="page">
                        <div class="flex items-center">
                            <i class="fas fa-chevron-right text-gray-400 mx-4"></i>
                            <span class="text-gray-800 font-medium">Leituras</span>
                        </div>
                    </li>
                </ol>
            </nav>
        </div>

        <!-- Header Principal -->
        <div class="px-6 py-6">
            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                <div class="flex-1">
                    <div class="flex items-center mb-2">
                        <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mr-4">
                            <i class="fas fa-chart-line text-white text-xl"></i>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-900">Leituras Diárias</h1>
                            <p class="text-gray-600">{{ $barragem->nome }} ({{ $barragem->codigo }})</p>
                        </div>
                    </div>
                    
                    <div class="flex flex-wrap items-center gap-4 mt-3">
                        @php
                            $anoHidrologico = \App\Helpers\HydrologicalYear::getCurrentHydrologicalYear();
                            $estacaoAtual = \App\Helpers\HydrologicalYear::getCurrentSeason();
                        @endphp
                        
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-{{ $estacaoAtual['color'] }}-100 text-{{ $estacaoAtual['color'] }}-800 border border-{{ $estacaoAtual['color'] }}-200">
                            @if($estacaoAtual['season'] == 'chuvosa')
                                <i class="fas fa-cloud-rain mr-2"></i>
                            @else
                                <i class="fas fa-sun mr-2"></i>
                            @endif
                            {{ $estacaoAtual['label'] }} {{ $anoHidrologico }}/{{ $anoHidrologico + 1 }}
                        </span>
                        
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800 border border-blue-200">
                            <i class="fas fa-database mr-2"></i>
                            {{ $leituras->total() }} Leituras
                        </span>
                    </div>
                </div>

                <!-- Ações -->
                <div class="mt-6 lg:mt-0 lg:ml-6">
                    <div class="flex flex-col sm:flex-row gap-3">
                        <a href="{{ route('barragens.leituras.grid', $barragem) }}"
                           class="inline-flex items-center justify-center px-4 py-2 text-white rounded-lg transition-colors"
                           style="background-color: #7c3aed; border: 1px solid #7c3aed;"
                           onmouseover="this.style.backgroundColor='#6d28d9'"
                           onmouseout="this.style.backgroundColor='#7c3aed'">
                            <i class="fas fa-table mr-2"></i>
                            Modo Grid
                        </a>
                        <a href="#" onclick="toggleNovaLeitura()"
                           class="inline-flex items-center justify-center px-4 py-2 text-white rounded-lg transition-colors"
                           style="background-color: #16a34a; border: 1px solid #16a34a;"
                           onmouseover="this.style.backgroundColor='#15803d'"
                           onmouseout="this.style.backgroundColor='#16a34a'"
                           id="novaLeituraBtn">
                            <i class="fas fa-plus mr-2"></i>
                            Nova Leitura
                        </a>
                        <a href="#"
                           class="inline-flex items-center justify-center px-4 py-2 text-white rounded-lg transition-colors"
                           style="background-color: #2563eb; border: 1px solid #2563eb;"
                           onmouseover="this.style.backgroundColor='#1d4ed8'"
                           onmouseout="this.style.backgroundColor='#2563eb'">
                            <i class="fas fa-upload mr-2"></i>
                            Importar Excel
                        </a>
                        <a href="{{ route('barragens.show', $barragem) }}"
                           class="inline-flex items-center justify-center px-4 py-2 text-white rounded-lg transition-colors"
                           style="background-color: #4b5563; border: 1px solid #4b5563;"
                           onmouseover="this.style.backgroundColor='#374151'"
                           onmouseout="this.style.backgroundColor='#4b5563'">
                            <i class="fas fa-arrow-left mr-2"></i>
                            Voltar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros -->
    <div class="bg-white rounded-lg shadow p-6">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Início</label>
                <input type="date" name="data_inicio" value="{{ request('data_inicio') }}" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Data Fim</label>
                <input type="date" name="data_fim" value="{{ request('data_fim') }}" 
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Método</label>
                <select name="metodo" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-green-500">
                    <option value="">Todos</option>
                    <option value="manual" {{ request('metodo') == 'manual' ? 'selected' : '' }}>Manual</option>
                    <option value="automatico" {{ request('metodo') == 'automatico' ? 'selected' : '' }}>Automático</option>
                    <option value="telemetria" {{ request('metodo') == 'telemetria' ? 'selected' : '' }}>Telemetria</option>
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit"
                        class="w-full text-white px-4 py-2 rounded-md transition-colors flex items-center justify-center"
                        style="background-color: #4b5563; border: 1px solid #4b5563;"
                        onmouseover="this.style.backgroundColor='#374151'"
                        onmouseout="this.style.backgroundColor='#4b5563'">
                    <i class="fas fa-search mr-2"></i>
                    Filtrar
                </button>
            </div>
        </form>
    </div>

    <!-- Tabela de Leituras -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">
                Histórico de Leituras ({{ $leituras->total() }})
            </h3>
        </div>
        
        @if($leituras->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full table-fixed divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Data & Hora</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Níveis</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Volumes</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Caudais</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status & Validação</th>
                            <th class="w-1/6 px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($leituras as $leitura)
                        <tr class="hover:bg-gray-50">
                            <!-- Data & Hora -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="text-sm font-medium text-gray-900">
                                    {{ $leitura->data_leitura->format('d/m/Y') }}
                                </div>
                                <div class="text-sm text-gray-500">
                                    {{ $leitura->hora_leitura ?? '06:00' }}
                                </div>
                                <div class="text-xs text-gray-400">
                                    {{ ucfirst($leitura->metodo_leitura ?? 'Manual') }}
                                </div>
                            </td>

                            <!-- Níveis -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="space-y-1">
                                    <div class="flex items-center">
                                        <span class="text-sm font-medium text-blue-600">{{ number_format($leitura->cota_actual, 2) }}m</span>
                                        <span class="text-xs text-gray-500 ml-2">Cota</span>
                                    </div>
                                    @if($leitura->percentagem_enchimento)
                                        <div class="flex items-center">
                                            <span class="text-sm font-medium text-purple-600">{{ number_format($leitura->percentagem_enchimento, 1) }}%</span>
                                            <span class="text-xs text-gray-500 ml-2">Enchimento</span>
                                        </div>
                                    @endif
                                </div>
                            </td>

                            <!-- Volumes -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="space-y-1">
                                    @if($leitura->volume_actual)
                                        <div class="flex items-center">
                                            <span class="text-sm font-medium text-green-600">{{ number_format($leitura->volume_actual, 2) }}</span>
                                            <span class="text-xs text-gray-500 ml-1">Mm³</span>
                                        </div>
                                    @endif
                                    @if($leitura->variacao_volume)
                                        <div class="flex items-center">
                                            @if($leitura->variacao_volume > 0)
                                                <i class="fas fa-arrow-up text-green-500 mr-1"></i>
                                                <span class="text-xs text-green-600">+{{ number_format($leitura->variacao_volume, 2) }}</span>
                                            @elseif($leitura->variacao_volume < 0)
                                                <i class="fas fa-arrow-down text-red-500 mr-1"></i>
                                                <span class="text-xs text-red-600">{{ number_format($leitura->variacao_volume, 2) }}</span>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            </td>

                            <!-- Caudais -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="space-y-1">
                                    @if($leitura->caudal_afluente)
                                        <div class="text-xs">
                                            <i class="fas fa-arrow-right text-green-500 mr-1"></i>
                                            <span class="text-green-600">{{ number_format($leitura->caudal_afluente, 1) }} m³/s</span>
                                        </div>
                                    @endif
                                    @if($leitura->caudal_efluente)
                                        <div class="text-xs">
                                            <i class="fas fa-arrow-left text-blue-500 mr-1"></i>
                                            <span class="text-blue-600">{{ number_format($leitura->caudal_efluente, 1) }} m³/s</span>
                                        </div>
                                    @endif
                                    @if($leitura->descarga_total)
                                        <div class="text-xs">
                                            <i class="fas fa-water text-gray-500 mr-1"></i>
                                            <span class="text-gray-600">{{ number_format($leitura->descarga_total, 1) }} m³/s total</span>
                                        </div>
                                    @endif
                                </div>
                            </td>

                            <!-- Status & Validação -->
                            <td class="w-1/6 px-6 py-4 break-words">
                                <div class="space-y-2">
                                    @if($leitura->validado)
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs bg-green-100 text-green-800">
                                            <i class="fas fa-check-circle mr-1"></i>
                                            Validado
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs bg-yellow-100 text-yellow-800">
                                            <i class="fas fa-clock mr-1"></i>
                                            Pendente
                                        </span>
                                    @endif

                                    @if($leitura->operador)
                                        <div class="text-xs text-gray-500">
                                            <i class="fas fa-user mr-1"></i>
                                            {{ $leitura->operador->name }}
                                        </div>
                                    @endif
                                </div>
                            </td>

                            <!-- Ações -->
                            <td class="w-1/6 px-6 py-4 break-words text-sm font-medium">
                                <div class="flex items-center space-x-2">
                                    <a href="{{ route('barragens.leituras.edit', [$barragem, $leitura]) }}" class="text-blue-600 hover:text-blue-900" title="Editar">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    @if(!$leitura->validado && auth()->user()->can('validate_readings'))
                                        <form method="POST" action="{{ route('barragens.validateLeitura', [$barragem, $leitura]) }}" class="inline">
                                            @csrf
                                            @method('PUT')
                                            <button type="submit" class="text-green-600 hover:text-green-900" title="Validar">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    @endif
                                    <form method="POST" action="{{ route('barragens.leituras.destroy', [$barragem, $leitura]) }}" class="inline" onsubmit="return confirm('Tem certeza que deseja excluir esta leitura?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-red-600 hover:text-red-900" title="Excluir">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            @if($leituras->hasPages())
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $leituras->withQueryString()->links() }}
            </div>
            @endif
        @else
            <div class="text-center py-12">
                <div class="w-24 h-24 bg-gradient-to-br from-green-100 to-green-200 rounded-full flex items-center justify-center mx-auto mb-4 shadow-lg">
                    <i class="fas fa-chart-line text-4xl text-green-600"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-900 mb-2">Nenhuma leitura encontrada</h3>
                <p class="text-gray-500 mb-6 max-w-md mx-auto">
                    @if(request()->filled('data_inicio') || request()->filled('data_fim') || request()->filled('metodo'))
                        Nenhuma leitura corresponde aos filtros aplicados. Tente ajustar os critérios de busca.
                    @else
                        Comece adicionando a primeira leitura para esta barragem.
                    @endif
                </p>
                <div class="flex flex-col sm:flex-row gap-3 justify-center">
                    @if(request()->filled('data_inicio') || request()->filled('data_fim') || request()->filled('metodo'))
                        <a href="{{ route('barragens.leituras', $barragem) }}" 
                           class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 transition-colors">
                            <i class="fas fa-times mr-2"></i>
                            Limpar Filtros
                        </a>
                    @endif
                    <a href="#" onclick="toggleNovaLeitura()"
                       class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white transition-colors"
                       style="background-color: #16a34a; border: 1px solid #16a34a;"
                       onmouseover="this.style.backgroundColor='#15803d'"
                       onmouseout="this.style.backgroundColor='#16a34a'">
                        <i class="fas fa-plus mr-2"></i>
                        Adicionar Primeira Leitura
                    </a>
                </div>
            </div>
        @endif
    </div>

    @php
        $temEscalaNpa = $barragem->escala_npa && $barragem->cota_npa;
    @endphp

    <!-- Modal Nova Leitura (Centrado) -->
    <div id="novaLeituraModal" class="hidden fixed inset-0 z-50 overflow-y-auto">
        <!-- Overlay -->
        <div class="fixed inset-0 bg-black bg-opacity-50 transition-opacity" onclick="fecharModal()"></div>

        <!-- Modal Content -->
        <div class="flex min-h-full items-center justify-center p-4">
            <div class="relative bg-white rounded-xl shadow-2xl w-full max-w-3xl transform transition-all">
                <!-- Header -->
                <div class="px-6 py-4 bg-gradient-to-r from-green-600 to-green-700 rounded-t-xl">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-white bg-opacity-20 rounded-lg flex items-center justify-center mr-3">
                                <i class="fas fa-plus text-white"></i>
                            </div>
                            <div>
                                <h3 class="text-lg font-semibold text-white">Nova Leitura</h3>
                                <p class="text-sm text-green-100">{{ $barragem->nome }} ({{ $barragem->codigo }})</p>
                            </div>
                        </div>
                        <button onclick="fecharModal()" class="text-white hover:text-green-200 transition-colors">
                            <i class="fas fa-times text-xl"></i>
                        </button>
                    </div>
                </div>

                <div class="p-6">
                    <form method="POST" action="{{ route('barragens.storeLeitura', $barragem) }}" id="leituraForm">
                        @csrf

                        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                            <!-- COLUNA 1: Entrada Principal -->
                            <div class="space-y-4">
                                <h4 class="font-medium text-gray-900 flex items-center border-b pb-2">
                                    <i class="fas fa-edit mr-2 text-green-600"></i>
                                    Dados de Entrada
                                </h4>

                                <div class="grid grid-cols-2 gap-3">
                                    <div>
                                        <label class="block text-xs font-medium text-gray-700 mb-1">Data *</label>
                                        <input type="date" name="data_leitura" required value="{{ date('Y-m-d') }}"
                                               class="w-full px-3 py-2 text-sm border border-gray-300 rounded-md focus:ring-2 focus:ring-green-500">
                                    </div>
                                    <div>
                                        <label class="block text-xs font-medium text-gray-700 mb-1">Hora *</label>
                                        <select name="hora_leitura" required
                                                class="w-full px-3 py-2 text-sm border border-gray-300 rounded-md focus:ring-2 focus:ring-green-500">
                                            <option value="06:00" selected>06:00h</option>
                                            <option value="12:00">12:00h</option>
                                            <option value="18:00">18:00h</option>
                                        </select>
                                    </div>
                                </div>

                                @if($temEscalaNpa)
                                    <!-- Input: Nivel Hidrometrico -->
                                    <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                                        <label class="block text-sm font-bold text-green-800 mb-2">
                                            <i class="fas fa-ruler-vertical mr-1"></i>
                                            Nível Hidrométrico (Escala) *
                                        </label>
                                        <input type="number" step="0.01" name="nivel_hidrometrico" id="nivel_hidrometrico"
                                               placeholder="Leitura na régua"
                                               oninput="calcularValores()"
                                               class="w-full px-4 py-3 text-lg font-semibold border-2 border-green-400 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500">
                                        <p class="text-xs text-green-600 mt-1">
                                            Escala NPA: {{ number_format((float)($barragem->escala_npa ?? 0), 2) }}m
                                        </p>
                                        <input type="hidden" name="cota_actual" id="cota_actual">
                                    </div>
                                @else
                                    <!-- Input: Cota Direta -->
                                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                                        <label class="block text-sm font-bold text-blue-800 mb-2">
                                            <i class="fas fa-water mr-1"></i>
                                            Cota Atual (m) *
                                        </label>
                                        <input type="number" step="0.01" name="cota_actual" id="cota_actual" required
                                               placeholder="Cota absoluta"
                                               oninput="calcularValores()"
                                               class="w-full px-4 py-3 text-lg font-semibold border-2 border-blue-400 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                    </div>
                                @endif

                                <!-- Caudal Ecológico (opcional) -->
                                <div>
                                    <label class="block text-xs font-medium text-gray-700 mb-1">
                                        Caudal Ecológico (m³/s)
                                    </label>
                                    <input type="number" step="0.001" name="caudal_ecologico"
                                           placeholder="Opcional"
                                           class="w-full px-3 py-2 text-sm border border-gray-300 rounded-md focus:ring-2 focus:ring-green-500">
                                </div>
                            </div>

                            <!-- COLUNA 2: Valores Calculados -->
                            <div class="space-y-4">
                                <h4 class="font-medium text-gray-900 flex items-center border-b pb-2">
                                    <i class="fas fa-calculator mr-2 text-blue-600"></i>
                                    Valores Calculados
                                </h4>

                                <div class="bg-gray-50 rounded-lg p-4 space-y-3">
                                    @if($temEscalaNpa)
                                    <div class="flex justify-between items-center py-2 border-b border-gray-200">
                                        <span class="text-sm text-gray-600">Cota Atual</span>
                                        <span id="display_cota" class="text-lg font-bold text-blue-600">-- m</span>
                                    </div>
                                    @endif

                                    <div class="flex justify-between items-center py-2 border-b border-gray-200">
                                        <span class="text-sm text-gray-600">Volume Atual</span>
                                        <span id="display_volume" class="text-lg font-bold text-green-600">-- Mm³</span>
                                    </div>

                                    <div class="flex justify-between items-center py-2 border-b border-gray-200">
                                        <span class="text-sm text-gray-600">% Enchimento</span>
                                        <span id="display_percentagem" class="text-lg font-bold text-purple-600">-- %</span>
                                    </div>

                                    <div class="flex justify-between items-center py-2">
                                        <span class="text-sm text-gray-600">% Total</span>
                                        <span id="display_total" class="text-lg font-bold text-orange-600">-- %</span>
                                    </div>
                                </div>

                                <!-- Referência da Barragem -->
                                <div class="bg-blue-50 rounded-lg p-3 text-xs">
                                    <div class="font-medium text-blue-800 mb-2">Parâmetros da Barragem</div>
                                    <div class="grid grid-cols-2 gap-2 text-blue-700">
                                        <div>NPA: {{ number_format($barragem->cota_npa ?? 0, 2) }}m</div>
                                        <div>Vol. Máx: {{ number_format($barragem->volume_maximo ?? 0, 2) }} Mm³</div>
                                        <div>NME: {{ number_format($barragem->cota_nme ?? 0, 2) }}m</div>
                                        <div>Vol. Morto: {{ number_format($barragem->volume_morto ?? 0, 2) }} Mm³</div>
                                    </div>
                                </div>
                            </div>

                            <!-- COLUNA 3: Caudais Opcionais -->
                            <div class="space-y-4">
                                <h4 class="font-medium text-gray-900 flex items-center border-b pb-2">
                                    <i class="fas fa-tint mr-2 text-cyan-600"></i>
                                    Caudais (Opcionais)
                                </h4>

                                <div class="grid grid-cols-2 gap-2">
                                    <div>
                                        <label class="block text-xs text-gray-600 mb-1">Afluente</label>
                                        <input type="number" step="0.01" name="caudal_afluente"
                                               class="w-full px-2 py-1 text-sm border border-gray-300 rounded">
                                    </div>
                                    <div>
                                        <label class="block text-xs text-gray-600 mb-1">Efluente</label>
                                        <input type="number" step="0.01" name="caudal_efluente"
                                               class="w-full px-2 py-1 text-sm border border-gray-300 rounded">
                                    </div>
                                    <div>
                                        <label class="block text-xs text-gray-600 mb-1">Desc. Fundo</label>
                                        <input type="number" step="0.01" name="descarga_fundo"
                                               class="w-full px-2 py-1 text-sm border border-gray-300 rounded">
                                    </div>
                                    <div>
                                        <label class="block text-xs text-gray-600 mb-1">Desc. Superfície</label>
                                        <input type="number" step="0.01" name="descarga_superficie"
                                               class="w-full px-2 py-1 text-sm border border-gray-300 rounded">
                                    </div>
                                    <div>
                                        <label class="block text-xs text-gray-600 mb-1">Turbinado</label>
                                        <input type="number" step="0.01" name="caudal_turbinado"
                                               class="w-full px-2 py-1 text-sm border border-gray-300 rounded">
                                    </div>
                                    <div>
                                        <label class="block text-xs text-gray-600 mb-1">Descarregador</label>
                                        <input type="number" step="0.01" name="caudal_descarregador"
                                               class="w-full px-2 py-1 text-sm border border-gray-300 rounded">
                                    </div>
                                </div>

                                <div>
                                    <label class="block text-xs text-gray-600 mb-1">Observações</label>
                                    <textarea name="observacoes" rows="3"
                                              placeholder="Notas sobre a leitura..."
                                              class="w-full px-2 py-1 text-sm border border-gray-300 rounded resize-none"></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Botões -->
                        <div class="flex justify-end gap-3 mt-6 pt-4 border-t border-gray-200">
                            <button type="button" onclick="fecharModal()"
                                    class="px-5 py-2 text-gray-700 bg-gray-200 hover:bg-gray-300 rounded-lg transition-colors">
                                <i class="fas fa-times mr-2"></i>Cancelar
                            </button>
                            <button type="submit"
                                    class="px-6 py-2 text-white rounded-lg transition-colors font-semibold bg-green-600 hover:bg-green-700">
                                <i class="fas fa-save mr-2"></i>Salvar Leitura
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Parâmetros da barragem para cálculos
const barragemConfig = {
    temEscalaNpa: {{ $temEscalaNpa ? 'true' : 'false' }},
    cotaNpa: {{ (float)($barragem->cota_npa ?? 0) }},
    escalaNpa: {{ (float)($barragem->escala_npa ?? 0) }},
    volumeMaximo: {{ (float)($barragem->volume_maximo ?? 0) }},
    volumeMorto: {{ (float)($barragem->volume_morto ?? 0) }},
    cotaNme: {{ (float)($barragem->cota_nme ?? 0) }},
};

console.log('Barragem Config:', barragemConfig);

// Abrir modal
function toggleNovaLeitura() {
    const modal = document.getElementById('novaLeituraModal');
    modal.classList.remove('hidden');
    document.body.style.overflow = 'hidden';

    // Focar no campo principal
    setTimeout(() => {
        const input = document.getElementById('nivel_hidrometrico') || document.getElementById('cota_actual');
        if (input) input.focus();
    }, 100);
}

// Fechar modal
function fecharModal() {
    const modal = document.getElementById('novaLeituraModal');
    modal.classList.add('hidden');
    document.body.style.overflow = 'auto';
    resetForm();
}

// Resetar formulário
function resetForm() {
    const form = document.getElementById('leituraForm');
    if (form) {
        form.reset();
        document.querySelector('input[name="data_leitura"]').value = new Date().toISOString().split('T')[0];
        document.querySelector('select[name="hora_leitura"]').value = '06:00';

        // Resetar displays
        if (document.getElementById('display_cota')) document.getElementById('display_cota').textContent = '-- m';
        document.getElementById('display_volume').textContent = '-- Mm³';
        document.getElementById('display_percentagem').textContent = '-- %';
        document.getElementById('display_total').textContent = '-- %';
    }
}

// Calcular volume baseado na cota (mesma lógica do backend)
function calcularVolume(cota) {
    const cotaNme = barragemConfig.cotaNme;
    const cotaNpa = barragemConfig.cotaNpa;
    const volMorto = barragemConfig.volumeMorto;
    const volMax = barragemConfig.volumeMaximo;

    console.log('=== CÁLCULO DE VOLUME ===');
    console.log('Cota inserida:', cota);
    console.log('NME:', cotaNme, '| NPA:', cotaNpa);
    console.log('Vol.Morto:', volMorto, '| Vol.Max:', volMax);

    // Se não temos volume máximo, não conseguimos calcular percentagens
    if (!volMax || volMax <= 0) {
        console.warn('Volume máximo não configurado!');
        return 0;
    }

    // Se não temos NPA, usar proporção simples baseada na cota
    if (!cotaNpa || cotaNpa <= 0) {
        console.warn('Cota NPA não configurada - usando cálculo simplificado');
        // Assumir que cota representa diretamente uma proporção
        return volMax * 0.5; // fallback
    }

    // Definir cotaNme se não existir (usar 80% do NPA como mínimo operacional)
    const cotaNmeReal = (cotaNme > 0) ? cotaNme : (cotaNpa * 0.8);

    console.log('NME usado para cálculo:', cotaNmeReal);

    // Se cota igual ou acima do NPA -> volume máximo
    if (cota >= cotaNpa) {
        console.log('Cota >= NPA -> Volume Máximo');
        return volMax;
    }

    // Se cota abaixo ou igual ao NME -> volume morto
    if (cota <= cotaNmeReal) {
        console.log('Cota <= NME -> Volume Morto');
        return volMorto;
    }

    // Interpolação linear entre NME e NPA
    const deltaCota = cotaNpa - cotaNmeReal;
    const deltaVolume = volMax - volMorto;
    const proporcao = (cota - cotaNmeReal) / deltaCota;
    const volume = volMorto + (deltaVolume * proporcao);

    console.log('Interpolação: proporção=', (proporcao * 100).toFixed(1) + '%', '-> Volume=', volume.toFixed(2));
    return volume;
}

// Calcular valores automaticamente
function calcularValores() {
    let cota = 0;

    if (barragemConfig.temEscalaNpa) {
        // Calcular cota a partir do nivel hidrometrico
        const nivelInput = document.getElementById('nivel_hidrometrico');
        const nivel = parseFloat(nivelInput?.value) || 0;

        console.log('Nível hidrometrico:', nivel);

        if (nivel > 0) {
            // Fórmula: Cota = NPA - (escala_npa - nivel_hidrometrico)
            cota = barragemConfig.cotaNpa - (barragemConfig.escalaNpa - nivel);
            console.log('Cota calculada:', cota);

            const cotaInput = document.getElementById('cota_actual');
            if (cotaInput) cotaInput.value = cota.toFixed(2);

            const displayCota = document.getElementById('display_cota');
            if (displayCota) displayCota.textContent = cota.toFixed(2) + ' m';
        } else {
            const displayCota = document.getElementById('display_cota');
            if (displayCota) displayCota.textContent = '-- m';
        }
    } else {
        const cotaInput = document.getElementById('cota_actual');
        cota = parseFloat(cotaInput?.value) || 0;
        console.log('Cota direta:', cota);
    }

    // Verificar se temos cota válida
    if (cota <= 0) {
        document.getElementById('display_volume').textContent = '-- Mm³';
        document.getElementById('display_percentagem').textContent = '-- %';
        document.getElementById('display_total').textContent = '-- %';
        return;
    }

    // Calcular volume
    const volume = calcularVolume(cota);

    if (volume <= 0 || barragemConfig.volumeMaximo <= 0) {
        document.getElementById('display_volume').textContent = '-- Mm³';
        document.getElementById('display_percentagem').textContent = '-- %';
        document.getElementById('display_total').textContent = '-- %';
        return;
    }

    // Percentagem total
    const percTotal = (volume / barragemConfig.volumeMaximo) * 100;

    // Percentagem enchimento (volume útil)
    const volumeUtil = volume - barragemConfig.volumeMorto;
    const volumeUtilMax = barragemConfig.volumeMaximo - barragemConfig.volumeMorto;
    const percEnchimento = volumeUtilMax > 0 ? Math.max(0, (volumeUtil / volumeUtilMax) * 100) : 0;

    console.log('Volume:', volume, '% Total:', percTotal, '% Enchimento:', percEnchimento);

    // Atualizar displays
    document.getElementById('display_volume').textContent = volume.toFixed(2) + ' Mm³';
    document.getElementById('display_percentagem').textContent = Math.min(100, percEnchimento).toFixed(1) + ' %';
    document.getElementById('display_total').textContent = Math.min(100, percTotal).toFixed(1) + ' %';
}

// Fechar modal com ESC
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        const modal = document.getElementById('novaLeituraModal');
        if (!modal.classList.contains('hidden')) {
            fecharModal();
        }
    }
});
</script>
@endsection